![douyin](https://socialify.git.ci/erma0/douyin/image?description=1&font=Source%20Code%20Pro&forks=1&issues=1&language=1&owner=1&pattern=Circuit%20Board&stargazers=1&theme=Auto)

# ✨DouyinCrawler

> ❤️[开源不易，欢迎star⭐](#star-history)

## 📢声明

> 本项目初衷为学习`python`爬虫、命令行调用`Aria2`及`python`实现`WebUI`的案例，后用于尝试体验AI编程（前端及前后端交互部分纯AI生成），应用程序功能为获取抖音平台上公开的信息，仅用于测试和学习研究，禁止用于商业用途或任何非法用途。
>
> 任何用户直接或间接使用、传播本仓库内容时责任自负，本仓库的贡献者不对该等行为产生的任何后果负责。
>
> **如果相关方认为该项目的代码可能涉嫌侵犯其权利，请及时联系我删除相关代码**。
>
> 使用本仓库的内容即表示您同意本免责声明的所有条款和条件。如果你不接受以上的免责声明，请立即停止使用本项目。

---

## 🏠项目地址

> [https://github.com/erma0/douyin](https://github.com/erma0/douyin)

## 🍬功能特性

### 📊 数据采集
- ✅ 指定作品数据
- ✅ 用户主页作品
- ✅ 用户喜欢作品（需目标开放权限）
- ✅ 用户收藏作品（需目标开放权限）
- ✅ 挑战话题作品
- ✅ 合集作品
- ⚠️ 音乐原声作品（功能异常）
- ✅ 关键词搜索作品

### 🎯 应用特性
- 🔄 **增量采集**：智能增量采集用户主页作品
- ⬇️ **批量下载**：集成Aria2，支持视频/图片批量下载
- 🎨 **可视化界面**：React桌面应用，实时日志显示
- 🎉 **首次运行向导**：友好的欢迎界面，引导配置

## 🚀快速开始

### 环境要求

> 📍测试环境：`Win10 x64` + `Python 3.12` + `Node.js 22.13.0` + `uv 0.9+`


### 快速启动

- 从 [Releases](https://github.com/erma0/douyin/releases) 下载最新版本
- 解压后双击运行 `DouyinCrawler.exe`


详细使用说明请查看 [USAGE.md](USAGE.md)

## ⚠️ 已知问题

1. **音乐功能异常** - 音乐原声作品采集可能失败

## 🔨构建和打包

### 📁 脚本目录

所有构建脚本已整理到 `scripts/` 目录：

```
scripts/
├── build/              # 打包脚本
│   ├── pyinstaller.ps1      # PyInstaller 打包
│   ├── pyinstaller-dir.spec # 目录模式配置
│   ├── pyinstaller-onefile.spec # 单文件配置
│   └── nuitka.ps1           # Nuitka 打包
├── setup/              # 环境配置
│   ├── uv.ps1               # 配置 uv 环境
│   ├── aria2.ps1            # 下载 aria2
│   └── pyinstaller.ps1      # 单独安装 PyInstaller
└── dev.ps1             # 开发环境构建
```

### 🚀 快速开始

#### 方式 1：使用快速启动菜单（推荐）

```powershell
.\quick-start.ps1
```

提供交互式菜单，按数字选择操作。

#### 方式 2：手动执行脚本

详见脚本目录

### 📦 打包说明

#### PyInstaller（推荐）
- ✅ 打包速度快（1-2分钟）
- ✅ 支持目录模式和单文件模式
- ✅ 兼容性好
- 📦 体积：目录模式 ~36MB，单文件 ~17MB

#### Nuitka（高性能）
- ✅ 编译为原生代码，性能更好
- ✅ 启动速度快
- ⚠️ 编译时间长（3-5分钟）
- ⚠️ 需要 MinGW64 编译器（自动下载）
- 📦 体积：目录模式 ~45MB，单文件 ~12MB

#### 打包产物
- **目录模式**：`dist/DouyinCrawler/DouyinCrawler.exe`（启动快）
- **单文件模式**：`dist/DouyinCrawler.exe`（便于分发）
- **发布包**：`release/DouyinCrawler_*.zip`（自动生成）


## 📊 技术栈

- **后端**: Python 3.12, PyWebView
- **前端**: React 18, TypeScript, Vite
- **下载**: Aria2
- **打包**: PyInstaller / Nuitka

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=erma0/douyin&type=Date)](https://star-history.com/#erma0/douyin&Date)