# 基本使用说明

有两点需要特别注意：  
1.在读取游戏时，游戏文件夹内不要有游戏自带的data文件夹以外的含有json文件的data文件夹  
2.注入翻译时，游戏一定要是原版游戏，否则会报错  

关于自动换行：  
如果将字数设为-1，将使用自动换行脚本（感谢@Morph大佬），但脚本未必适配所有游戏，所以如果报错需要手动删除js\plugins.js文件内的下面这行
> {"name":"自动换行","status":true,"description":"auto linefeed","parameters":{}},
  

# 进阶使用说明
本文档为StevExtraction的进阶使用方法说明，在你对默认设置的翻译效果不满意时，可以尝试阅读本文档，并根据自己的需要修改config.yaml文件。  
在实际修改config文件之前，需要明白StevExtraction中的两个概念：**code**和**地址**

## 什么是code

StevExtraction在提取文本时，是以code为依据进行处理和提取的，所以首先要明白什么是code。  
简单来说，code就是游戏的数据文件，json文件中数据的类型，每一种code对应一种数据。  
比如，随便打开一个json文件（比如说CommonEvents.json），并稍加整理，可以看到以下格式的数据，其中的356,401,201就是code，而parameters则是数据内容。

    {  
                    "code": 356,  
                    "indent": 0,  
                    "parameters": [  
                        "addLog \\C[24]ラピスフィリア。"  
                    ]  
    },  
    {  
                   "code": 401,  
                   "indent": 1,  
                   "parameters": [  
                       "\\ow[4]クロアはなんとかその場から逃げ出した。"  
                   ]  
    } ,
    {
                "code": 201,
                "indent": 0,
                "parameters": [
                    0,
                    232,
                    12,
                    24,
                    4,
                    0
                ]
    }  

有一些文本格式与上面的示例不同，是没有对应的code的，这类文本的code统一被设定为了"-1"

## 地址指什么

用**记事本**打开StevExtraction的任意一个翻译工程文件，会发现它有五列数据：原文，译文，地址，标签，code。每一列均可以作为索引定位到对应的文本行，其中地址是在config.yaml中使用比较多的索引。  
每一行文本都会至少有一个地址，它的格式是这样的

    json文件名\...文件内地址...+\u200B+n

其中\u200B是一个不会显示的字符，n表示的是文本求和后的数量；文件内地址中，字符串代表字典的键，数字代表列表的位置。  
不过这些都**不重要**。重要的是他怎么在config.yaml中使用。  
config.yaml中，使用**正则表达式**来选定地址列，比如'vents.*name'会选定所有地址中按顺序出现'vents'和'name'的文本行。

# config配置项的说明

在有了上面的基础知识后，便可以开始自定义修改config.yaml文件了。下面对各个配置项进行说明。

## ReadCode

字面意义，只有在其中的code才会被程序读取，除此之外的code均不会被读取（sptext中的除外，sptext的优先级大于ReadCode，sptext后面会介绍）。

## BlackCode

黑名单code，在这之中的code即使被读取了也不会被翻译。使用场景大概是读取的时候觉得没问题，但是后来发现这个code翻译了会出错。

## BlackDir  

黑名单地址，在其中的地址不会被翻译。作用比blackcode大，可以按需求添加，但不建议删减。

## BlackFiles

黑名单文件，不想翻译的文件名放进来就行


## NameWithout

为名字提取功能的相关设置，用来排除掉一些不需要被提取的名字。  
名字提取功能会自动提取所有地址中包含“name”的文本。如果有不需要提取的名字地址，可以添加到NameWithout中，提取的时候会自动排除掉。  
一般来说，事件名为'vents.*name'，道具名为'Items.*name'，技能名为'Skills.*name','States.*name'为状态名

## sumcode

文本求和功能的相关设置，用来设置需要求和的文本的code  

文本求和功能，就是把同一个对话框内的文本加在一起导出，注入的时候也一起注入，这样翻译出来的效果会更好。你在t++里看到的那些好多行的文本一般就是求和后的。

## sptext

特殊文本提取功能，用来提取一些需要特殊处理的文本的功能，一般来说这些文本会对应t++中自动标红的内容，也就是翻了可能会报错的内容  
正常文本基本和上面例子里的code401一样，parameters中的所有字符串，以及字符串中的所有内容都是可以翻译的  
特殊文本则类似于code356，字符串中有一部分内容是不能翻译。比如在上面的例子中，addLog就不能翻译  
此外，code356一般会有很多内容根本不能翻译，而能翻译的文本，一般会包含某些特定文本（简单起见，我们叫它mark），比如上面的addLog  
所以，特殊文本提取功能主要做了三件事：  
1.锁定特殊文本所对应的code  
2.判断该code的文本是否包含mark  
3.如果包含mark，则对文本内容应用正则匹配，提取其中可以翻译的部分  
sptext的设置格式如下

    'sptext': {  
        '355':{
            'addText':'[^a-zA-z0-9(),。]+',
            '多个mark示例':'这里填正则表达式'
            },  
        '655':{'空':'[^a-zA-z0-9(),。]+'},  
        '356':{'addLog':'[^a-zA-z0-9(),。]+'} 
    }

同一个code内可以添加多个mark，如果不需要设定mark，可以像655那样，填为“空”。正则表达式中，如果需要匹配单引号，需要用中文句号代替  
示例中的正则表达式，匹配的是连续的**非**英文字母，数字，()，英文逗号和单引号内容。如果不知道怎么设置正则表达式，可以直接用这个，应该是比较通用的  
在程序内，正则匹配使用的是re.findall()函数，并在匹配后会额外判定匹配到的内容是否包含中日字符  
需要注意的是，**在sptext中的code，不会被以正常方式读取**

## codewithnames

这是一个文本拆分规则，会在处理文件名时用到。如果你翻译的游戏遇到了文件名丢失的问题，可能需要调整这项设置（不过大部分情况是其他更难处理的原因）  
以默认设置'codewithnames': [["[","]"],["\"","\""],["<",">"]]为例  
假如需要拆分的文本中，同时存在"["和"]"，那么程序就可以把被[]包裹的部分提取出来，用作后续处理  
在处理文件名时，如果原文和游戏文件夹内某个文件名完全相同，那么将文本替换回原文（有些时候人名没被翻译就是因为这个）  
如果不完全相同，但是被某两个符号包裹的部分完全相同，会把包裹的这部分替换回原文  
**所以在这一配置项中，需要设置的就是可能会包裹文件名的两个符号**

## note_percent

这是一个处理note类文本时需要的参数  
note文本如果在游戏内出现，一般是类似于图鉴的内容。如果被错误翻译，图鉴可能无法收集和显示。  
此外，一些地图效果也是由note控制的，如果地图效果出现异常，也可以考虑是note的原因  
act类游戏，如果出现了无法攻击，或攻击没有效果，也是note的原因  
note文本举例

><SGカテゴリ:人物>  
><SG手動>  
><SGピクチャ:Actor10_jiten>  
><SG説明:>  
><SG説明2:久住千代（くすみちよ）  
>就读于县立相极高中的学生。  
>身高155cm，B97(H)・W60・H98。
>经常观察他人的表情，总是低头的少女。
>除了与她从幼年时期就相识的“明日香”之外，没有其他可以称之为朋友的存在,反而对明日香寄予了超越血缘的信任。>

文本可以按照<>分段，从<到:的内容是一定不能翻译的，而:后面的内容可能能翻译，可能不能翻译。  
一般来说，可以翻译的note文本都会很长，比如上面的SG説明2段  
**note_percent**就是用来判断note文本够不够长的参数，当<到:字符串长度占整个字符串长度的比值（只统计中日字符）小于note_percent时，说明文本不够长，整个<>都会被还原成原文；大于note_percent时，则会保留:后面的翻译  
如果出现了应该被翻译的文本没有翻译，就改小一点，反之就改大一点  
如果出现了note类错误，而且通过修改note_percent解决不了，就直接在黑名单地址里加上note，不翻译它了

# 更多功能

除了一键提取和注入功能外，StevExtraction还有很多其他功能，比如按条件搜索，替换，和提取等。基本能够满足文本数据处理的绝大部分需要了，但是这些功能都没有写出ui界面，所以需要去jtpp.py文件自己调用。

如果在读完整个文档后，还有问题解决不了，可以加我的q群：852682626。在这个群问的问题，我看到的可能性更大一点