PmodDPG1 IP
==============

Using the IP in Vivado
--------------
A tutorial for using Pmod IP cores in Vivado is available [here](https://reference.digilentinc.com/learn/programmable-logic/tutorials/pmod-ips/start).
When you get to the step for connecting reference clocks, be sure to connect the
IP's ext_spi_clk port to a 50 MHz clock. The 50 MHz clock can be generated by
either the Clocking Wizard or the Memory Interface Generator (MIG). Instructions
are available for both approaches in the tutorial.

Demo Program in Xilinx SDK
--------------
The demo program continuously polls the PmodDPG1 at regular time intervals for
pressure measurements and prints the Pmod's raw data and the data converted into
6 different units:
- kiloPascals            (kPa)
- atmospheres            (atm)
- pounds per square inch (psi)
- inches of water        (inH2O)
- centimeters of water   (cmH2O)
- millimeters of mercury (mmHg)

To set up the demo you will need to open a serial terminal, such as TeraTerm, to
see the data being printed out. Settings for the terminal will vary depending on
your board.

For Zynq projects, apply the following settings:
- Baud rate: 115200
- Data bits: 8
- Parity:    none
- Stop bits: 1

For MicroBlaze projects, apply the settings according to the AXI Uartlite IP
configurations. These settings can be found by double clicking the AXI Uartlite
IP in the block design and clicking the IP Configuration tab.
