PmodJSTK2 IP
============

Using the IP in Vivado
------------
A tutorial for using Pmod IP cores in  Vivado is available [here](https://reference.digilentinc.com/learn/programmable-logic/tutorials/pmod-ips/start).
At the step for connecting reference clocks, be sure to connect the IP's
ext_spi_clk port to a 16 MHz clock. The 16 MHz clock can be generated by either
the Clocking Wizard or the Memory Interface Generator (MIG). Instructions are
available for both approaches in the tutorial.

Demo Program in Xilinx SDK
------------
There are two demo programs for the PmodJSTK2 IP, basic_example.c and
calibrate_example.c.

The basic_example program reads the X and Y position of the joystick and maps
those values to the LED. If either the trigger button or the joystick button are
pressed, the LED will turn green. The program also prints the X and Y position
of the joystick and messages indicating when the joystick or trigger buttons are
pressed to the terminal.

The calibrate_example program runs through the calibration process for the
PmodJSTK2. After programming your board, wait for the blue blinking light on the
JSTK2 to turn on. Then, move the joystick in a circle at the far edges of where
it can move. After completing one full circle, release the joystick. Let the
joystick stay still until the green light flashes twice, this indicates that the
calbration process is complete. Status messages are printed to the terminal.

To see text output from the example programs, you will need to open a serial
terminal, such as TeraTerm. Settings for the terminal will vary depending on
your board.

For Zynq Projects, apply the following settings:
- Baud rate: 115200
- Data bits: 8
- Parity:    none
- Stop bits: 1

For MicroBlaze projects, apply the settings according to the AXI Uartlite IP
configurations. These settings can be found by double clicking the AXI Uartlite
IP in the block design and clicking the IP Configuration tab. By default, these
settings are:
- Baud rate: 9600
- Data bits: 8
- Parity:    none
- Stop bits: 1
