-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity hls_contrast_stretch is
generic (
    C_S_AXI_AXILITES_ADDR_WIDTH : INTEGER := 6;
    C_S_AXI_AXILITES_DATA_WIDTH : INTEGER := 32 );
port (
    s_axi_AXILiteS_AWVALID : IN STD_LOGIC;
    s_axi_AXILiteS_AWREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_ADDR_WIDTH-1 downto 0);
    s_axi_AXILiteS_WVALID : IN STD_LOGIC;
    s_axi_AXILiteS_WREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH-1 downto 0);
    s_axi_AXILiteS_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH/8-1 downto 0);
    s_axi_AXILiteS_ARVALID : IN STD_LOGIC;
    s_axi_AXILiteS_ARREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_ADDR_WIDTH-1 downto 0);
    s_axi_AXILiteS_RVALID : OUT STD_LOGIC;
    s_axi_AXILiteS_RREADY : IN STD_LOGIC;
    s_axi_AXILiteS_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH-1 downto 0);
    s_axi_AXILiteS_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_AXILiteS_BVALID : OUT STD_LOGIC;
    s_axi_AXILiteS_BREADY : IN STD_LOGIC;
    s_axi_AXILiteS_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    stream_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
    stream_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
    stream_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
    stream_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
    stream_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
    stream_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
    stream_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TVALID : IN STD_LOGIC;
    stream_in_TREADY : OUT STD_LOGIC;
    stream_out_TVALID : OUT STD_LOGIC;
    stream_out_TREADY : IN STD_LOGIC );
end;


architecture behav of hls_contrast_stretch is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "hls_contrast_stretch,hls_ip_2017_4,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xc7z020clg400-1,HLS_INPUT_CLOCK=6.670000,HLS_INPUT_ARCH=dataflow,HLS_SYN_CLOCK=6.380000,HLS_SYN_LAT=-1,HLS_SYN_TPT=-1,HLS_SYN_MEM=0,HLS_SYN_DSP=9,HLS_SYN_FF=3094,HLS_SYN_LUT=4583}";
    constant C_S_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_S_AXI_WSTRB_WIDTH : INTEGER range 63 downto 0 := 4;
    constant C_S_AXI_ADDR_WIDTH : INTEGER range 63 downto 0 := 20;
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_lv24_0 : STD_LOGIC_VECTOR (23 downto 0) := "000000000000000000000000";
    constant ap_const_lv3_0 : STD_LOGIC_VECTOR (2 downto 0) := "000";
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_logic_0 : STD_LOGIC := '0';

    signal ap_rst_n_inv : STD_LOGIC;
    signal height : STD_LOGIC_VECTOR (15 downto 0);
    signal width : STD_LOGIC_VECTOR (15 downto 0);
    signal min : STD_LOGIC_VECTOR (7 downto 0);
    signal max : STD_LOGIC_VECTOR (7 downto 0);
    signal Block_Mat_exit1573_p_U0_ap_start : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_start_full_n : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_ap_done : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_ap_continue : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_ap_idle : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_ap_ready : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_start_out : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_start_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_min_out_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Block_Mat_exit1573_p_U0_min_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_img0_rows_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit1573_p_U0_img0_rows_V_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_img0_cols_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit1573_p_U0_img0_cols_V_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_img2_rows_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit1573_p_U0_img2_rows_V_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_img2_cols_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit1573_p_U0_img2_cols_V_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_img3_rows_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit1573_p_U0_img3_rows_V_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_img3_cols_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit1573_p_U0_img3_cols_V_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_p_cols_assign_cast_out_out_din : STD_LOGIC_VECTOR (11 downto 0);
    signal Block_Mat_exit1573_p_U0_p_cols_assign_cast_out_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_p_rows_assign_cast_out_out_din : STD_LOGIC_VECTOR (11 downto 0);
    signal Block_Mat_exit1573_p_U0_p_rows_assign_cast_out_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_tmp_3_cast_out_out_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Block_Mat_exit1573_p_U0_tmp_3_cast_out_out_write : STD_LOGIC;
    signal Block_Mat_exit1573_p_U0_max_out_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Block_Mat_exit1573_p_U0_max_out_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_start : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_done : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_continue : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_idle : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_ready : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_out : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_stream_in_TREADY : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_rows_V_read : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_cols_V_read : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_0_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_1_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_2_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_rows_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal AXIvideo2Mat_U0_img_rows_V_out_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_cols_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal AXIvideo2Mat_U0_img_cols_V_out_write : STD_LOGIC;
    signal CvtColor_1_U0_ap_start : STD_LOGIC;
    signal CvtColor_1_U0_ap_done : STD_LOGIC;
    signal CvtColor_1_U0_ap_continue : STD_LOGIC;
    signal CvtColor_1_U0_ap_idle : STD_LOGIC;
    signal CvtColor_1_U0_ap_ready : STD_LOGIC;
    signal CvtColor_1_U0_p_src_rows_V_read : STD_LOGIC;
    signal CvtColor_1_U0_p_src_cols_V_read : STD_LOGIC;
    signal CvtColor_1_U0_p_src_data_stream_0_V_read : STD_LOGIC;
    signal CvtColor_1_U0_p_src_data_stream_1_V_read : STD_LOGIC;
    signal CvtColor_1_U0_p_src_data_stream_2_V_read : STD_LOGIC;
    signal CvtColor_1_U0_p_dst_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal CvtColor_1_U0_p_dst_data_stream_0_V_write : STD_LOGIC;
    signal CvtColor_1_U0_p_dst_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal CvtColor_1_U0_p_dst_data_stream_1_V_write : STD_LOGIC;
    signal CvtColor_1_U0_p_dst_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal CvtColor_1_U0_p_dst_data_stream_2_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_start : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_done : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_continue : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_idle : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_ready : STD_LOGIC;
    signal Loop_loop_height_pro_U0_max_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_p_rows_assign_cast_loc_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_p_cols_assign_cast_loc_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img2_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Loop_loop_height_pro_U0_img2_data_stream_0_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img2_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Loop_loop_height_pro_U0_img2_data_stream_1_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img2_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Loop_loop_height_pro_U0_img2_data_stream_2_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img1_data_stream_0_V_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img1_data_stream_1_V_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img1_data_stream_2_V_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_min_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_tmp_3_cast_loc_read : STD_LOGIC;
    signal CvtColor_U0_ap_start : STD_LOGIC;
    signal CvtColor_U0_ap_done : STD_LOGIC;
    signal CvtColor_U0_ap_continue : STD_LOGIC;
    signal CvtColor_U0_ap_idle : STD_LOGIC;
    signal CvtColor_U0_ap_ready : STD_LOGIC;
    signal CvtColor_U0_p_src_rows_V_read : STD_LOGIC;
    signal CvtColor_U0_p_src_cols_V_read : STD_LOGIC;
    signal CvtColor_U0_p_src_data_stream_0_V_read : STD_LOGIC;
    signal CvtColor_U0_p_src_data_stream_1_V_read : STD_LOGIC;
    signal CvtColor_U0_p_src_data_stream_2_V_read : STD_LOGIC;
    signal CvtColor_U0_p_dst_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal CvtColor_U0_p_dst_data_stream_0_V_write : STD_LOGIC;
    signal CvtColor_U0_p_dst_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal CvtColor_U0_p_dst_data_stream_1_V_write : STD_LOGIC;
    signal CvtColor_U0_p_dst_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal CvtColor_U0_p_dst_data_stream_2_V_write : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_start : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_done : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_continue : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_idle : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_ready : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_rows_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_cols_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_0_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_1_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_2_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_stream_out_TDATA : STD_LOGIC_VECTOR (23 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TVALID : STD_LOGIC;
    signal Mat2AXIvideo_U0_stream_out_TKEEP : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TSTRB : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TLAST : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TID : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TDEST : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_sync_continue : STD_LOGIC;
    signal min_c_full_n : STD_LOGIC;
    signal min_c_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal min_c_empty_n : STD_LOGIC;
    signal img0_rows_V_c_full_n : STD_LOGIC;
    signal img0_rows_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img0_rows_V_c_empty_n : STD_LOGIC;
    signal img0_cols_V_c_full_n : STD_LOGIC;
    signal img0_cols_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img0_cols_V_c_empty_n : STD_LOGIC;
    signal img2_rows_V_c_full_n : STD_LOGIC;
    signal img2_rows_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img2_rows_V_c_empty_n : STD_LOGIC;
    signal img2_cols_V_c_full_n : STD_LOGIC;
    signal img2_cols_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img2_cols_V_c_empty_n : STD_LOGIC;
    signal img3_rows_V_c_full_n : STD_LOGIC;
    signal img3_rows_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img3_rows_V_c_empty_n : STD_LOGIC;
    signal img3_cols_V_c_full_n : STD_LOGIC;
    signal img3_cols_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img3_cols_V_c_empty_n : STD_LOGIC;
    signal p_cols_assign_cast_lo_full_n : STD_LOGIC;
    signal p_cols_assign_cast_lo_dout : STD_LOGIC_VECTOR (11 downto 0);
    signal p_cols_assign_cast_lo_empty_n : STD_LOGIC;
    signal p_rows_assign_cast_lo_full_n : STD_LOGIC;
    signal p_rows_assign_cast_lo_dout : STD_LOGIC_VECTOR (11 downto 0);
    signal p_rows_assign_cast_lo_empty_n : STD_LOGIC;
    signal tmp_3_cast_loc_c_full_n : STD_LOGIC;
    signal tmp_3_cast_loc_c_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal tmp_3_cast_loc_c_empty_n : STD_LOGIC;
    signal max_c_full_n : STD_LOGIC;
    signal max_c_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal max_c_empty_n : STD_LOGIC;
    signal img0_data_stream_0_s_full_n : STD_LOGIC;
    signal img0_data_stream_0_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img0_data_stream_0_s_empty_n : STD_LOGIC;
    signal img0_data_stream_1_s_full_n : STD_LOGIC;
    signal img0_data_stream_1_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img0_data_stream_1_s_empty_n : STD_LOGIC;
    signal img0_data_stream_2_s_full_n : STD_LOGIC;
    signal img0_data_stream_2_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img0_data_stream_2_s_empty_n : STD_LOGIC;
    signal img0_rows_V_c83_full_n : STD_LOGIC;
    signal img0_rows_V_c83_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img0_rows_V_c83_empty_n : STD_LOGIC;
    signal img0_cols_V_c84_full_n : STD_LOGIC;
    signal img0_cols_V_c84_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img0_cols_V_c84_empty_n : STD_LOGIC;
    signal img1_data_stream_0_s_full_n : STD_LOGIC;
    signal img1_data_stream_0_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img1_data_stream_0_s_empty_n : STD_LOGIC;
    signal img1_data_stream_1_s_full_n : STD_LOGIC;
    signal img1_data_stream_1_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img1_data_stream_1_s_empty_n : STD_LOGIC;
    signal img1_data_stream_2_s_full_n : STD_LOGIC;
    signal img1_data_stream_2_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img1_data_stream_2_s_empty_n : STD_LOGIC;
    signal img2_data_stream_0_s_full_n : STD_LOGIC;
    signal img2_data_stream_0_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img2_data_stream_0_s_empty_n : STD_LOGIC;
    signal img2_data_stream_1_s_full_n : STD_LOGIC;
    signal img2_data_stream_1_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img2_data_stream_1_s_empty_n : STD_LOGIC;
    signal img2_data_stream_2_s_full_n : STD_LOGIC;
    signal img2_data_stream_2_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img2_data_stream_2_s_empty_n : STD_LOGIC;
    signal img3_data_stream_0_s_full_n : STD_LOGIC;
    signal img3_data_stream_0_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img3_data_stream_0_s_empty_n : STD_LOGIC;
    signal img3_data_stream_1_s_full_n : STD_LOGIC;
    signal img3_data_stream_1_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img3_data_stream_1_s_empty_n : STD_LOGIC;
    signal img3_data_stream_2_s_full_n : STD_LOGIC;
    signal img3_data_stream_2_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img3_data_stream_2_s_empty_n : STD_LOGIC;
    signal start_for_Loop_loop_height_pro_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Loop_loop_height_pro_U0_full_n : STD_LOGIC;
    signal start_for_Loop_loop_height_pro_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Loop_loop_height_pro_U0_empty_n : STD_LOGIC;
    signal start_for_CvtColor_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_CvtColor_U0_full_n : STD_LOGIC;
    signal start_for_CvtColor_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_CvtColor_U0_empty_n : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_full_n : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_empty_n : STD_LOGIC;
    signal start_for_CvtColor_1_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_CvtColor_1_U0_full_n : STD_LOGIC;
    signal start_for_CvtColor_1_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_CvtColor_1_U0_empty_n : STD_LOGIC;
    signal CvtColor_1_U0_start_full_n : STD_LOGIC;
    signal CvtColor_1_U0_start_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_start_full_n : STD_LOGIC;
    signal Loop_loop_height_pro_U0_start_write : STD_LOGIC;
    signal CvtColor_U0_start_full_n : STD_LOGIC;
    signal CvtColor_U0_start_write : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_full_n : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_write : STD_LOGIC;

    component Block_Mat_exit1573_p IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        height : IN STD_LOGIC_VECTOR (15 downto 0);
        width : IN STD_LOGIC_VECTOR (15 downto 0);
        min : IN STD_LOGIC_VECTOR (7 downto 0);
        max : IN STD_LOGIC_VECTOR (7 downto 0);
        min_out_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        min_out_full_n : IN STD_LOGIC;
        min_out_write : OUT STD_LOGIC;
        img0_rows_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img0_rows_V_out_full_n : IN STD_LOGIC;
        img0_rows_V_out_write : OUT STD_LOGIC;
        img0_cols_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img0_cols_V_out_full_n : IN STD_LOGIC;
        img0_cols_V_out_write : OUT STD_LOGIC;
        img2_rows_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img2_rows_V_out_full_n : IN STD_LOGIC;
        img2_rows_V_out_write : OUT STD_LOGIC;
        img2_cols_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img2_cols_V_out_full_n : IN STD_LOGIC;
        img2_cols_V_out_write : OUT STD_LOGIC;
        img3_rows_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img3_rows_V_out_full_n : IN STD_LOGIC;
        img3_rows_V_out_write : OUT STD_LOGIC;
        img3_cols_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img3_cols_V_out_full_n : IN STD_LOGIC;
        img3_cols_V_out_write : OUT STD_LOGIC;
        p_cols_assign_cast_out_out_din : OUT STD_LOGIC_VECTOR (11 downto 0);
        p_cols_assign_cast_out_out_full_n : IN STD_LOGIC;
        p_cols_assign_cast_out_out_write : OUT STD_LOGIC;
        p_rows_assign_cast_out_out_din : OUT STD_LOGIC_VECTOR (11 downto 0);
        p_rows_assign_cast_out_out_full_n : IN STD_LOGIC;
        p_rows_assign_cast_out_out_write : OUT STD_LOGIC;
        tmp_3_cast_out_out_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        tmp_3_cast_out_out_full_n : IN STD_LOGIC;
        tmp_3_cast_out_out_write : OUT STD_LOGIC;
        max_out_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        max_out_full_n : IN STD_LOGIC;
        max_out_write : OUT STD_LOGIC );
    end component;


    component AXIvideo2Mat IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        stream_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
        stream_in_TVALID : IN STD_LOGIC;
        stream_in_TREADY : OUT STD_LOGIC;
        stream_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
        stream_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
        stream_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
        img_rows_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        img_rows_V_empty_n : IN STD_LOGIC;
        img_rows_V_read : OUT STD_LOGIC;
        img_cols_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        img_cols_V_empty_n : IN STD_LOGIC;
        img_cols_V_read : OUT STD_LOGIC;
        img_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_full_n : IN STD_LOGIC;
        img_data_stream_0_V_write : OUT STD_LOGIC;
        img_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_full_n : IN STD_LOGIC;
        img_data_stream_1_V_write : OUT STD_LOGIC;
        img_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_full_n : IN STD_LOGIC;
        img_data_stream_2_V_write : OUT STD_LOGIC;
        img_rows_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img_rows_V_out_full_n : IN STD_LOGIC;
        img_rows_V_out_write : OUT STD_LOGIC;
        img_cols_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img_cols_V_out_full_n : IN STD_LOGIC;
        img_cols_V_out_write : OUT STD_LOGIC );
    end component;


    component CvtColor_1 IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        p_src_rows_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        p_src_rows_V_empty_n : IN STD_LOGIC;
        p_src_rows_V_read : OUT STD_LOGIC;
        p_src_cols_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        p_src_cols_V_empty_n : IN STD_LOGIC;
        p_src_cols_V_read : OUT STD_LOGIC;
        p_src_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_0_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_0_V_read : OUT STD_LOGIC;
        p_src_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_1_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_1_V_read : OUT STD_LOGIC;
        p_src_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_2_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_2_V_read : OUT STD_LOGIC;
        p_dst_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_0_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_0_V_write : OUT STD_LOGIC;
        p_dst_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_1_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_1_V_write : OUT STD_LOGIC;
        p_dst_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_2_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_2_V_write : OUT STD_LOGIC );
    end component;


    component Loop_loop_height_pro IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        max_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        max_empty_n : IN STD_LOGIC;
        max_read : OUT STD_LOGIC;
        p_rows_assign_cast_loc_dout : IN STD_LOGIC_VECTOR (11 downto 0);
        p_rows_assign_cast_loc_empty_n : IN STD_LOGIC;
        p_rows_assign_cast_loc_read : OUT STD_LOGIC;
        p_cols_assign_cast_loc_dout : IN STD_LOGIC_VECTOR (11 downto 0);
        p_cols_assign_cast_loc_empty_n : IN STD_LOGIC;
        p_cols_assign_cast_loc_read : OUT STD_LOGIC;
        img2_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img2_data_stream_0_V_full_n : IN STD_LOGIC;
        img2_data_stream_0_V_write : OUT STD_LOGIC;
        img2_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img2_data_stream_1_V_full_n : IN STD_LOGIC;
        img2_data_stream_1_V_write : OUT STD_LOGIC;
        img2_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img2_data_stream_2_V_full_n : IN STD_LOGIC;
        img2_data_stream_2_V_write : OUT STD_LOGIC;
        img1_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img1_data_stream_0_V_empty_n : IN STD_LOGIC;
        img1_data_stream_0_V_read : OUT STD_LOGIC;
        img1_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img1_data_stream_1_V_empty_n : IN STD_LOGIC;
        img1_data_stream_1_V_read : OUT STD_LOGIC;
        img1_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img1_data_stream_2_V_empty_n : IN STD_LOGIC;
        img1_data_stream_2_V_read : OUT STD_LOGIC;
        min_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        min_empty_n : IN STD_LOGIC;
        min_read : OUT STD_LOGIC;
        tmp_3_cast_loc_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        tmp_3_cast_loc_empty_n : IN STD_LOGIC;
        tmp_3_cast_loc_read : OUT STD_LOGIC );
    end component;


    component CvtColor IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        p_src_rows_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        p_src_rows_V_empty_n : IN STD_LOGIC;
        p_src_rows_V_read : OUT STD_LOGIC;
        p_src_cols_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        p_src_cols_V_empty_n : IN STD_LOGIC;
        p_src_cols_V_read : OUT STD_LOGIC;
        p_src_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_0_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_0_V_read : OUT STD_LOGIC;
        p_src_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_1_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_1_V_read : OUT STD_LOGIC;
        p_src_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_2_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_2_V_read : OUT STD_LOGIC;
        p_dst_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_0_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_0_V_write : OUT STD_LOGIC;
        p_dst_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_1_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_1_V_write : OUT STD_LOGIC;
        p_dst_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_2_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_2_V_write : OUT STD_LOGIC );
    end component;


    component Mat2AXIvideo IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        img_rows_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        img_rows_V_empty_n : IN STD_LOGIC;
        img_rows_V_read : OUT STD_LOGIC;
        img_cols_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        img_cols_V_empty_n : IN STD_LOGIC;
        img_cols_V_read : OUT STD_LOGIC;
        img_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_empty_n : IN STD_LOGIC;
        img_data_stream_0_V_read : OUT STD_LOGIC;
        img_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_empty_n : IN STD_LOGIC;
        img_data_stream_1_V_read : OUT STD_LOGIC;
        img_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_empty_n : IN STD_LOGIC;
        img_data_stream_2_V_read : OUT STD_LOGIC;
        stream_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
        stream_out_TVALID : OUT STD_LOGIC;
        stream_out_TREADY : IN STD_LOGIC;
        stream_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
        stream_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
        stream_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0) );
    end component;


    component fifo_w8_d3_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (7 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (7 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w16_d1_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (15 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (15 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w16_d4_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (15 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (15 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w16_d5_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (15 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (15 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w12_d3_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (11 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (11 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w8_d1_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (7 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (7 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Loop_lojbC IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_CvtColokbM IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Mat2AXIlbW IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_CvtColomb6 IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component hls_contrast_stretch_AXILiteS_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        height : OUT STD_LOGIC_VECTOR (15 downto 0);
        width : OUT STD_LOGIC_VECTOR (15 downto 0);
        min : OUT STD_LOGIC_VECTOR (7 downto 0);
        max : OUT STD_LOGIC_VECTOR (7 downto 0) );
    end component;



begin
    hls_contrast_stretch_AXILiteS_s_axi_U : component hls_contrast_stretch_AXILiteS_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_AXILITES_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_AXILITES_DATA_WIDTH)
    port map (
        AWVALID => s_axi_AXILiteS_AWVALID,
        AWREADY => s_axi_AXILiteS_AWREADY,
        AWADDR => s_axi_AXILiteS_AWADDR,
        WVALID => s_axi_AXILiteS_WVALID,
        WREADY => s_axi_AXILiteS_WREADY,
        WDATA => s_axi_AXILiteS_WDATA,
        WSTRB => s_axi_AXILiteS_WSTRB,
        ARVALID => s_axi_AXILiteS_ARVALID,
        ARREADY => s_axi_AXILiteS_ARREADY,
        ARADDR => s_axi_AXILiteS_ARADDR,
        RVALID => s_axi_AXILiteS_RVALID,
        RREADY => s_axi_AXILiteS_RREADY,
        RDATA => s_axi_AXILiteS_RDATA,
        RRESP => s_axi_AXILiteS_RRESP,
        BVALID => s_axi_AXILiteS_BVALID,
        BREADY => s_axi_AXILiteS_BREADY,
        BRESP => s_axi_AXILiteS_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        height => height,
        width => width,
        min => min,
        max => max);

    Block_Mat_exit1573_p_U0 : component Block_Mat_exit1573_p
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Block_Mat_exit1573_p_U0_ap_start,
        start_full_n => Block_Mat_exit1573_p_U0_start_full_n,
        ap_done => Block_Mat_exit1573_p_U0_ap_done,
        ap_continue => Block_Mat_exit1573_p_U0_ap_continue,
        ap_idle => Block_Mat_exit1573_p_U0_ap_idle,
        ap_ready => Block_Mat_exit1573_p_U0_ap_ready,
        start_out => Block_Mat_exit1573_p_U0_start_out,
        start_write => Block_Mat_exit1573_p_U0_start_write,
        height => height,
        width => width,
        min => min,
        max => max,
        min_out_din => Block_Mat_exit1573_p_U0_min_out_din,
        min_out_full_n => min_c_full_n,
        min_out_write => Block_Mat_exit1573_p_U0_min_out_write,
        img0_rows_V_out_din => Block_Mat_exit1573_p_U0_img0_rows_V_out_din,
        img0_rows_V_out_full_n => img0_rows_V_c_full_n,
        img0_rows_V_out_write => Block_Mat_exit1573_p_U0_img0_rows_V_out_write,
        img0_cols_V_out_din => Block_Mat_exit1573_p_U0_img0_cols_V_out_din,
        img0_cols_V_out_full_n => img0_cols_V_c_full_n,
        img0_cols_V_out_write => Block_Mat_exit1573_p_U0_img0_cols_V_out_write,
        img2_rows_V_out_din => Block_Mat_exit1573_p_U0_img2_rows_V_out_din,
        img2_rows_V_out_full_n => img2_rows_V_c_full_n,
        img2_rows_V_out_write => Block_Mat_exit1573_p_U0_img2_rows_V_out_write,
        img2_cols_V_out_din => Block_Mat_exit1573_p_U0_img2_cols_V_out_din,
        img2_cols_V_out_full_n => img2_cols_V_c_full_n,
        img2_cols_V_out_write => Block_Mat_exit1573_p_U0_img2_cols_V_out_write,
        img3_rows_V_out_din => Block_Mat_exit1573_p_U0_img3_rows_V_out_din,
        img3_rows_V_out_full_n => img3_rows_V_c_full_n,
        img3_rows_V_out_write => Block_Mat_exit1573_p_U0_img3_rows_V_out_write,
        img3_cols_V_out_din => Block_Mat_exit1573_p_U0_img3_cols_V_out_din,
        img3_cols_V_out_full_n => img3_cols_V_c_full_n,
        img3_cols_V_out_write => Block_Mat_exit1573_p_U0_img3_cols_V_out_write,
        p_cols_assign_cast_out_out_din => Block_Mat_exit1573_p_U0_p_cols_assign_cast_out_out_din,
        p_cols_assign_cast_out_out_full_n => p_cols_assign_cast_lo_full_n,
        p_cols_assign_cast_out_out_write => Block_Mat_exit1573_p_U0_p_cols_assign_cast_out_out_write,
        p_rows_assign_cast_out_out_din => Block_Mat_exit1573_p_U0_p_rows_assign_cast_out_out_din,
        p_rows_assign_cast_out_out_full_n => p_rows_assign_cast_lo_full_n,
        p_rows_assign_cast_out_out_write => Block_Mat_exit1573_p_U0_p_rows_assign_cast_out_out_write,
        tmp_3_cast_out_out_din => Block_Mat_exit1573_p_U0_tmp_3_cast_out_out_din,
        tmp_3_cast_out_out_full_n => tmp_3_cast_loc_c_full_n,
        tmp_3_cast_out_out_write => Block_Mat_exit1573_p_U0_tmp_3_cast_out_out_write,
        max_out_din => Block_Mat_exit1573_p_U0_max_out_din,
        max_out_full_n => max_c_full_n,
        max_out_write => Block_Mat_exit1573_p_U0_max_out_write);

    AXIvideo2Mat_U0 : component AXIvideo2Mat
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => AXIvideo2Mat_U0_ap_start,
        start_full_n => start_for_CvtColor_1_U0_full_n,
        ap_done => AXIvideo2Mat_U0_ap_done,
        ap_continue => AXIvideo2Mat_U0_ap_continue,
        ap_idle => AXIvideo2Mat_U0_ap_idle,
        ap_ready => AXIvideo2Mat_U0_ap_ready,
        start_out => AXIvideo2Mat_U0_start_out,
        start_write => AXIvideo2Mat_U0_start_write,
        stream_in_TDATA => stream_in_TDATA,
        stream_in_TVALID => stream_in_TVALID,
        stream_in_TREADY => AXIvideo2Mat_U0_stream_in_TREADY,
        stream_in_TKEEP => stream_in_TKEEP,
        stream_in_TSTRB => stream_in_TSTRB,
        stream_in_TUSER => stream_in_TUSER,
        stream_in_TLAST => stream_in_TLAST,
        stream_in_TID => stream_in_TID,
        stream_in_TDEST => stream_in_TDEST,
        img_rows_V_dout => img0_rows_V_c_dout,
        img_rows_V_empty_n => img0_rows_V_c_empty_n,
        img_rows_V_read => AXIvideo2Mat_U0_img_rows_V_read,
        img_cols_V_dout => img0_cols_V_c_dout,
        img_cols_V_empty_n => img0_cols_V_c_empty_n,
        img_cols_V_read => AXIvideo2Mat_U0_img_cols_V_read,
        img_data_stream_0_V_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        img_data_stream_0_V_full_n => img0_data_stream_0_s_full_n,
        img_data_stream_0_V_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        img_data_stream_1_V_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        img_data_stream_1_V_full_n => img0_data_stream_1_s_full_n,
        img_data_stream_1_V_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        img_data_stream_2_V_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        img_data_stream_2_V_full_n => img0_data_stream_2_s_full_n,
        img_data_stream_2_V_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        img_rows_V_out_din => AXIvideo2Mat_U0_img_rows_V_out_din,
        img_rows_V_out_full_n => img0_rows_V_c83_full_n,
        img_rows_V_out_write => AXIvideo2Mat_U0_img_rows_V_out_write,
        img_cols_V_out_din => AXIvideo2Mat_U0_img_cols_V_out_din,
        img_cols_V_out_full_n => img0_cols_V_c84_full_n,
        img_cols_V_out_write => AXIvideo2Mat_U0_img_cols_V_out_write);

    CvtColor_1_U0 : component CvtColor_1
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => CvtColor_1_U0_ap_start,
        ap_done => CvtColor_1_U0_ap_done,
        ap_continue => CvtColor_1_U0_ap_continue,
        ap_idle => CvtColor_1_U0_ap_idle,
        ap_ready => CvtColor_1_U0_ap_ready,
        p_src_rows_V_dout => img0_rows_V_c83_dout,
        p_src_rows_V_empty_n => img0_rows_V_c83_empty_n,
        p_src_rows_V_read => CvtColor_1_U0_p_src_rows_V_read,
        p_src_cols_V_dout => img0_cols_V_c84_dout,
        p_src_cols_V_empty_n => img0_cols_V_c84_empty_n,
        p_src_cols_V_read => CvtColor_1_U0_p_src_cols_V_read,
        p_src_data_stream_0_V_dout => img0_data_stream_0_s_dout,
        p_src_data_stream_0_V_empty_n => img0_data_stream_0_s_empty_n,
        p_src_data_stream_0_V_read => CvtColor_1_U0_p_src_data_stream_0_V_read,
        p_src_data_stream_1_V_dout => img0_data_stream_1_s_dout,
        p_src_data_stream_1_V_empty_n => img0_data_stream_1_s_empty_n,
        p_src_data_stream_1_V_read => CvtColor_1_U0_p_src_data_stream_1_V_read,
        p_src_data_stream_2_V_dout => img0_data_stream_2_s_dout,
        p_src_data_stream_2_V_empty_n => img0_data_stream_2_s_empty_n,
        p_src_data_stream_2_V_read => CvtColor_1_U0_p_src_data_stream_2_V_read,
        p_dst_data_stream_0_V_din => CvtColor_1_U0_p_dst_data_stream_0_V_din,
        p_dst_data_stream_0_V_full_n => img1_data_stream_0_s_full_n,
        p_dst_data_stream_0_V_write => CvtColor_1_U0_p_dst_data_stream_0_V_write,
        p_dst_data_stream_1_V_din => CvtColor_1_U0_p_dst_data_stream_1_V_din,
        p_dst_data_stream_1_V_full_n => img1_data_stream_1_s_full_n,
        p_dst_data_stream_1_V_write => CvtColor_1_U0_p_dst_data_stream_1_V_write,
        p_dst_data_stream_2_V_din => CvtColor_1_U0_p_dst_data_stream_2_V_din,
        p_dst_data_stream_2_V_full_n => img1_data_stream_2_s_full_n,
        p_dst_data_stream_2_V_write => CvtColor_1_U0_p_dst_data_stream_2_V_write);

    Loop_loop_height_pro_U0 : component Loop_loop_height_pro
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Loop_loop_height_pro_U0_ap_start,
        ap_done => Loop_loop_height_pro_U0_ap_done,
        ap_continue => Loop_loop_height_pro_U0_ap_continue,
        ap_idle => Loop_loop_height_pro_U0_ap_idle,
        ap_ready => Loop_loop_height_pro_U0_ap_ready,
        max_dout => max_c_dout,
        max_empty_n => max_c_empty_n,
        max_read => Loop_loop_height_pro_U0_max_read,
        p_rows_assign_cast_loc_dout => p_rows_assign_cast_lo_dout,
        p_rows_assign_cast_loc_empty_n => p_rows_assign_cast_lo_empty_n,
        p_rows_assign_cast_loc_read => Loop_loop_height_pro_U0_p_rows_assign_cast_loc_read,
        p_cols_assign_cast_loc_dout => p_cols_assign_cast_lo_dout,
        p_cols_assign_cast_loc_empty_n => p_cols_assign_cast_lo_empty_n,
        p_cols_assign_cast_loc_read => Loop_loop_height_pro_U0_p_cols_assign_cast_loc_read,
        img2_data_stream_0_V_din => Loop_loop_height_pro_U0_img2_data_stream_0_V_din,
        img2_data_stream_0_V_full_n => img2_data_stream_0_s_full_n,
        img2_data_stream_0_V_write => Loop_loop_height_pro_U0_img2_data_stream_0_V_write,
        img2_data_stream_1_V_din => Loop_loop_height_pro_U0_img2_data_stream_1_V_din,
        img2_data_stream_1_V_full_n => img2_data_stream_1_s_full_n,
        img2_data_stream_1_V_write => Loop_loop_height_pro_U0_img2_data_stream_1_V_write,
        img2_data_stream_2_V_din => Loop_loop_height_pro_U0_img2_data_stream_2_V_din,
        img2_data_stream_2_V_full_n => img2_data_stream_2_s_full_n,
        img2_data_stream_2_V_write => Loop_loop_height_pro_U0_img2_data_stream_2_V_write,
        img1_data_stream_0_V_dout => img1_data_stream_0_s_dout,
        img1_data_stream_0_V_empty_n => img1_data_stream_0_s_empty_n,
        img1_data_stream_0_V_read => Loop_loop_height_pro_U0_img1_data_stream_0_V_read,
        img1_data_stream_1_V_dout => img1_data_stream_1_s_dout,
        img1_data_stream_1_V_empty_n => img1_data_stream_1_s_empty_n,
        img1_data_stream_1_V_read => Loop_loop_height_pro_U0_img1_data_stream_1_V_read,
        img1_data_stream_2_V_dout => img1_data_stream_2_s_dout,
        img1_data_stream_2_V_empty_n => img1_data_stream_2_s_empty_n,
        img1_data_stream_2_V_read => Loop_loop_height_pro_U0_img1_data_stream_2_V_read,
        min_dout => min_c_dout,
        min_empty_n => min_c_empty_n,
        min_read => Loop_loop_height_pro_U0_min_read,
        tmp_3_cast_loc_dout => tmp_3_cast_loc_c_dout,
        tmp_3_cast_loc_empty_n => tmp_3_cast_loc_c_empty_n,
        tmp_3_cast_loc_read => Loop_loop_height_pro_U0_tmp_3_cast_loc_read);

    CvtColor_U0 : component CvtColor
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => CvtColor_U0_ap_start,
        ap_done => CvtColor_U0_ap_done,
        ap_continue => CvtColor_U0_ap_continue,
        ap_idle => CvtColor_U0_ap_idle,
        ap_ready => CvtColor_U0_ap_ready,
        p_src_rows_V_dout => img2_rows_V_c_dout,
        p_src_rows_V_empty_n => img2_rows_V_c_empty_n,
        p_src_rows_V_read => CvtColor_U0_p_src_rows_V_read,
        p_src_cols_V_dout => img2_cols_V_c_dout,
        p_src_cols_V_empty_n => img2_cols_V_c_empty_n,
        p_src_cols_V_read => CvtColor_U0_p_src_cols_V_read,
        p_src_data_stream_0_V_dout => img2_data_stream_0_s_dout,
        p_src_data_stream_0_V_empty_n => img2_data_stream_0_s_empty_n,
        p_src_data_stream_0_V_read => CvtColor_U0_p_src_data_stream_0_V_read,
        p_src_data_stream_1_V_dout => img2_data_stream_1_s_dout,
        p_src_data_stream_1_V_empty_n => img2_data_stream_1_s_empty_n,
        p_src_data_stream_1_V_read => CvtColor_U0_p_src_data_stream_1_V_read,
        p_src_data_stream_2_V_dout => img2_data_stream_2_s_dout,
        p_src_data_stream_2_V_empty_n => img2_data_stream_2_s_empty_n,
        p_src_data_stream_2_V_read => CvtColor_U0_p_src_data_stream_2_V_read,
        p_dst_data_stream_0_V_din => CvtColor_U0_p_dst_data_stream_0_V_din,
        p_dst_data_stream_0_V_full_n => img3_data_stream_0_s_full_n,
        p_dst_data_stream_0_V_write => CvtColor_U0_p_dst_data_stream_0_V_write,
        p_dst_data_stream_1_V_din => CvtColor_U0_p_dst_data_stream_1_V_din,
        p_dst_data_stream_1_V_full_n => img3_data_stream_1_s_full_n,
        p_dst_data_stream_1_V_write => CvtColor_U0_p_dst_data_stream_1_V_write,
        p_dst_data_stream_2_V_din => CvtColor_U0_p_dst_data_stream_2_V_din,
        p_dst_data_stream_2_V_full_n => img3_data_stream_2_s_full_n,
        p_dst_data_stream_2_V_write => CvtColor_U0_p_dst_data_stream_2_V_write);

    Mat2AXIvideo_U0 : component Mat2AXIvideo
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Mat2AXIvideo_U0_ap_start,
        ap_done => Mat2AXIvideo_U0_ap_done,
        ap_continue => Mat2AXIvideo_U0_ap_continue,
        ap_idle => Mat2AXIvideo_U0_ap_idle,
        ap_ready => Mat2AXIvideo_U0_ap_ready,
        img_rows_V_dout => img3_rows_V_c_dout,
        img_rows_V_empty_n => img3_rows_V_c_empty_n,
        img_rows_V_read => Mat2AXIvideo_U0_img_rows_V_read,
        img_cols_V_dout => img3_cols_V_c_dout,
        img_cols_V_empty_n => img3_cols_V_c_empty_n,
        img_cols_V_read => Mat2AXIvideo_U0_img_cols_V_read,
        img_data_stream_0_V_dout => img3_data_stream_0_s_dout,
        img_data_stream_0_V_empty_n => img3_data_stream_0_s_empty_n,
        img_data_stream_0_V_read => Mat2AXIvideo_U0_img_data_stream_0_V_read,
        img_data_stream_1_V_dout => img3_data_stream_1_s_dout,
        img_data_stream_1_V_empty_n => img3_data_stream_1_s_empty_n,
        img_data_stream_1_V_read => Mat2AXIvideo_U0_img_data_stream_1_V_read,
        img_data_stream_2_V_dout => img3_data_stream_2_s_dout,
        img_data_stream_2_V_empty_n => img3_data_stream_2_s_empty_n,
        img_data_stream_2_V_read => Mat2AXIvideo_U0_img_data_stream_2_V_read,
        stream_out_TDATA => Mat2AXIvideo_U0_stream_out_TDATA,
        stream_out_TVALID => Mat2AXIvideo_U0_stream_out_TVALID,
        stream_out_TREADY => stream_out_TREADY,
        stream_out_TKEEP => Mat2AXIvideo_U0_stream_out_TKEEP,
        stream_out_TSTRB => Mat2AXIvideo_U0_stream_out_TSTRB,
        stream_out_TUSER => Mat2AXIvideo_U0_stream_out_TUSER,
        stream_out_TLAST => Mat2AXIvideo_U0_stream_out_TLAST,
        stream_out_TID => Mat2AXIvideo_U0_stream_out_TID,
        stream_out_TDEST => Mat2AXIvideo_U0_stream_out_TDEST);

    min_c_U : component fifo_w8_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_min_out_din,
        if_full_n => min_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_min_out_write,
        if_dout => min_c_dout,
        if_empty_n => min_c_empty_n,
        if_read => Loop_loop_height_pro_U0_min_read);

    img0_rows_V_c_U : component fifo_w16_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_img0_rows_V_out_din,
        if_full_n => img0_rows_V_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_img0_rows_V_out_write,
        if_dout => img0_rows_V_c_dout,
        if_empty_n => img0_rows_V_c_empty_n,
        if_read => AXIvideo2Mat_U0_img_rows_V_read);

    img0_cols_V_c_U : component fifo_w16_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_img0_cols_V_out_din,
        if_full_n => img0_cols_V_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_img0_cols_V_out_write,
        if_dout => img0_cols_V_c_dout,
        if_empty_n => img0_cols_V_c_empty_n,
        if_read => AXIvideo2Mat_U0_img_cols_V_read);

    img2_rows_V_c_U : component fifo_w16_d4_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_img2_rows_V_out_din,
        if_full_n => img2_rows_V_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_img2_rows_V_out_write,
        if_dout => img2_rows_V_c_dout,
        if_empty_n => img2_rows_V_c_empty_n,
        if_read => CvtColor_U0_p_src_rows_V_read);

    img2_cols_V_c_U : component fifo_w16_d4_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_img2_cols_V_out_din,
        if_full_n => img2_cols_V_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_img2_cols_V_out_write,
        if_dout => img2_cols_V_c_dout,
        if_empty_n => img2_cols_V_c_empty_n,
        if_read => CvtColor_U0_p_src_cols_V_read);

    img3_rows_V_c_U : component fifo_w16_d5_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_img3_rows_V_out_din,
        if_full_n => img3_rows_V_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_img3_rows_V_out_write,
        if_dout => img3_rows_V_c_dout,
        if_empty_n => img3_rows_V_c_empty_n,
        if_read => Mat2AXIvideo_U0_img_rows_V_read);

    img3_cols_V_c_U : component fifo_w16_d5_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_img3_cols_V_out_din,
        if_full_n => img3_cols_V_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_img3_cols_V_out_write,
        if_dout => img3_cols_V_c_dout,
        if_empty_n => img3_cols_V_c_empty_n,
        if_read => Mat2AXIvideo_U0_img_cols_V_read);

    p_cols_assign_cast_lo_U : component fifo_w12_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_p_cols_assign_cast_out_out_din,
        if_full_n => p_cols_assign_cast_lo_full_n,
        if_write => Block_Mat_exit1573_p_U0_p_cols_assign_cast_out_out_write,
        if_dout => p_cols_assign_cast_lo_dout,
        if_empty_n => p_cols_assign_cast_lo_empty_n,
        if_read => Loop_loop_height_pro_U0_p_cols_assign_cast_loc_read);

    p_rows_assign_cast_lo_U : component fifo_w12_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_p_rows_assign_cast_out_out_din,
        if_full_n => p_rows_assign_cast_lo_full_n,
        if_write => Block_Mat_exit1573_p_U0_p_rows_assign_cast_out_out_write,
        if_dout => p_rows_assign_cast_lo_dout,
        if_empty_n => p_rows_assign_cast_lo_empty_n,
        if_read => Loop_loop_height_pro_U0_p_rows_assign_cast_loc_read);

    tmp_3_cast_loc_c_U : component fifo_w8_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_tmp_3_cast_out_out_din,
        if_full_n => tmp_3_cast_loc_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_tmp_3_cast_out_out_write,
        if_dout => tmp_3_cast_loc_c_dout,
        if_empty_n => tmp_3_cast_loc_c_empty_n,
        if_read => Loop_loop_height_pro_U0_tmp_3_cast_loc_read);

    max_c_U : component fifo_w8_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit1573_p_U0_max_out_din,
        if_full_n => max_c_full_n,
        if_write => Block_Mat_exit1573_p_U0_max_out_write,
        if_dout => max_c_dout,
        if_empty_n => max_c_empty_n,
        if_read => Loop_loop_height_pro_U0_max_read);

    img0_data_stream_0_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        if_full_n => img0_data_stream_0_s_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        if_dout => img0_data_stream_0_s_dout,
        if_empty_n => img0_data_stream_0_s_empty_n,
        if_read => CvtColor_1_U0_p_src_data_stream_0_V_read);

    img0_data_stream_1_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        if_full_n => img0_data_stream_1_s_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        if_dout => img0_data_stream_1_s_dout,
        if_empty_n => img0_data_stream_1_s_empty_n,
        if_read => CvtColor_1_U0_p_src_data_stream_1_V_read);

    img0_data_stream_2_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        if_full_n => img0_data_stream_2_s_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        if_dout => img0_data_stream_2_s_dout,
        if_empty_n => img0_data_stream_2_s_empty_n,
        if_read => CvtColor_1_U0_p_src_data_stream_2_V_read);

    img0_rows_V_c83_U : component fifo_w16_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_rows_V_out_din,
        if_full_n => img0_rows_V_c83_full_n,
        if_write => AXIvideo2Mat_U0_img_rows_V_out_write,
        if_dout => img0_rows_V_c83_dout,
        if_empty_n => img0_rows_V_c83_empty_n,
        if_read => CvtColor_1_U0_p_src_rows_V_read);

    img0_cols_V_c84_U : component fifo_w16_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_cols_V_out_din,
        if_full_n => img0_cols_V_c84_full_n,
        if_write => AXIvideo2Mat_U0_img_cols_V_out_write,
        if_dout => img0_cols_V_c84_dout,
        if_empty_n => img0_cols_V_c84_empty_n,
        if_read => CvtColor_1_U0_p_src_cols_V_read);

    img1_data_stream_0_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => CvtColor_1_U0_p_dst_data_stream_0_V_din,
        if_full_n => img1_data_stream_0_s_full_n,
        if_write => CvtColor_1_U0_p_dst_data_stream_0_V_write,
        if_dout => img1_data_stream_0_s_dout,
        if_empty_n => img1_data_stream_0_s_empty_n,
        if_read => Loop_loop_height_pro_U0_img1_data_stream_0_V_read);

    img1_data_stream_1_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => CvtColor_1_U0_p_dst_data_stream_1_V_din,
        if_full_n => img1_data_stream_1_s_full_n,
        if_write => CvtColor_1_U0_p_dst_data_stream_1_V_write,
        if_dout => img1_data_stream_1_s_dout,
        if_empty_n => img1_data_stream_1_s_empty_n,
        if_read => Loop_loop_height_pro_U0_img1_data_stream_1_V_read);

    img1_data_stream_2_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => CvtColor_1_U0_p_dst_data_stream_2_V_din,
        if_full_n => img1_data_stream_2_s_full_n,
        if_write => CvtColor_1_U0_p_dst_data_stream_2_V_write,
        if_dout => img1_data_stream_2_s_dout,
        if_empty_n => img1_data_stream_2_s_empty_n,
        if_read => Loop_loop_height_pro_U0_img1_data_stream_2_V_read);

    img2_data_stream_0_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Loop_loop_height_pro_U0_img2_data_stream_0_V_din,
        if_full_n => img2_data_stream_0_s_full_n,
        if_write => Loop_loop_height_pro_U0_img2_data_stream_0_V_write,
        if_dout => img2_data_stream_0_s_dout,
        if_empty_n => img2_data_stream_0_s_empty_n,
        if_read => CvtColor_U0_p_src_data_stream_0_V_read);

    img2_data_stream_1_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Loop_loop_height_pro_U0_img2_data_stream_1_V_din,
        if_full_n => img2_data_stream_1_s_full_n,
        if_write => Loop_loop_height_pro_U0_img2_data_stream_1_V_write,
        if_dout => img2_data_stream_1_s_dout,
        if_empty_n => img2_data_stream_1_s_empty_n,
        if_read => CvtColor_U0_p_src_data_stream_1_V_read);

    img2_data_stream_2_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Loop_loop_height_pro_U0_img2_data_stream_2_V_din,
        if_full_n => img2_data_stream_2_s_full_n,
        if_write => Loop_loop_height_pro_U0_img2_data_stream_2_V_write,
        if_dout => img2_data_stream_2_s_dout,
        if_empty_n => img2_data_stream_2_s_empty_n,
        if_read => CvtColor_U0_p_src_data_stream_2_V_read);

    img3_data_stream_0_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => CvtColor_U0_p_dst_data_stream_0_V_din,
        if_full_n => img3_data_stream_0_s_full_n,
        if_write => CvtColor_U0_p_dst_data_stream_0_V_write,
        if_dout => img3_data_stream_0_s_dout,
        if_empty_n => img3_data_stream_0_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_0_V_read);

    img3_data_stream_1_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => CvtColor_U0_p_dst_data_stream_1_V_din,
        if_full_n => img3_data_stream_1_s_full_n,
        if_write => CvtColor_U0_p_dst_data_stream_1_V_write,
        if_dout => img3_data_stream_1_s_dout,
        if_empty_n => img3_data_stream_1_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_1_V_read);

    img3_data_stream_2_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => CvtColor_U0_p_dst_data_stream_2_V_din,
        if_full_n => img3_data_stream_2_s_full_n,
        if_write => CvtColor_U0_p_dst_data_stream_2_V_write,
        if_dout => img3_data_stream_2_s_dout,
        if_empty_n => img3_data_stream_2_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_2_V_read);

    start_for_Loop_lojbC_U : component start_for_Loop_lojbC
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Loop_loop_height_pro_U0_din,
        if_full_n => start_for_Loop_loop_height_pro_U0_full_n,
        if_write => Block_Mat_exit1573_p_U0_start_write,
        if_dout => start_for_Loop_loop_height_pro_U0_dout,
        if_empty_n => start_for_Loop_loop_height_pro_U0_empty_n,
        if_read => Loop_loop_height_pro_U0_ap_ready);

    start_for_CvtColokbM_U : component start_for_CvtColokbM
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_CvtColor_U0_din,
        if_full_n => start_for_CvtColor_U0_full_n,
        if_write => Block_Mat_exit1573_p_U0_start_write,
        if_dout => start_for_CvtColor_U0_dout,
        if_empty_n => start_for_CvtColor_U0_empty_n,
        if_read => CvtColor_U0_ap_ready);

    start_for_Mat2AXIlbW_U : component start_for_Mat2AXIlbW
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Mat2AXIvideo_U0_din,
        if_full_n => start_for_Mat2AXIvideo_U0_full_n,
        if_write => Block_Mat_exit1573_p_U0_start_write,
        if_dout => start_for_Mat2AXIvideo_U0_dout,
        if_empty_n => start_for_Mat2AXIvideo_U0_empty_n,
        if_read => Mat2AXIvideo_U0_ap_ready);

    start_for_CvtColomb6_U : component start_for_CvtColomb6
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_CvtColor_1_U0_din,
        if_full_n => start_for_CvtColor_1_U0_full_n,
        if_write => AXIvideo2Mat_U0_start_write,
        if_dout => start_for_CvtColor_1_U0_dout,
        if_empty_n => start_for_CvtColor_1_U0_empty_n,
        if_read => CvtColor_1_U0_ap_ready);




    AXIvideo2Mat_U0_ap_continue <= ap_const_logic_1;
    AXIvideo2Mat_U0_ap_start <= ap_const_logic_1;
    Block_Mat_exit1573_p_U0_ap_continue <= ap_const_logic_1;
    Block_Mat_exit1573_p_U0_ap_start <= ap_const_logic_1;
    Block_Mat_exit1573_p_U0_start_full_n <= (start_for_Mat2AXIvideo_U0_full_n and start_for_Loop_loop_height_pro_U0_full_n and start_for_CvtColor_U0_full_n);
    CvtColor_1_U0_ap_continue <= ap_const_logic_1;
    CvtColor_1_U0_ap_start <= start_for_CvtColor_1_U0_empty_n;
    CvtColor_1_U0_start_full_n <= ap_const_logic_1;
    CvtColor_1_U0_start_write <= ap_const_logic_0;
    CvtColor_U0_ap_continue <= ap_const_logic_1;
    CvtColor_U0_ap_start <= start_for_CvtColor_U0_empty_n;
    CvtColor_U0_start_full_n <= ap_const_logic_1;
    CvtColor_U0_start_write <= ap_const_logic_0;
    Loop_loop_height_pro_U0_ap_continue <= ap_const_logic_1;
    Loop_loop_height_pro_U0_ap_start <= start_for_Loop_loop_height_pro_U0_empty_n;
    Loop_loop_height_pro_U0_start_full_n <= ap_const_logic_1;
    Loop_loop_height_pro_U0_start_write <= ap_const_logic_0;
    Mat2AXIvideo_U0_ap_continue <= ap_const_logic_1;
    Mat2AXIvideo_U0_ap_start <= start_for_Mat2AXIvideo_U0_empty_n;
    Mat2AXIvideo_U0_start_full_n <= ap_const_logic_1;
    Mat2AXIvideo_U0_start_write <= ap_const_logic_0;

    ap_rst_n_inv_assign_proc : process(ap_rst_n)
    begin
                ap_rst_n_inv <= not(ap_rst_n);
    end process;

    ap_sync_continue <= ap_const_logic_0;
    start_for_CvtColor_1_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_CvtColor_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_Loop_loop_height_pro_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_Mat2AXIvideo_U0_din <= (0=>ap_const_logic_1, others=>'-');
    stream_in_TREADY <= AXIvideo2Mat_U0_stream_in_TREADY;
    stream_out_TDATA <= Mat2AXIvideo_U0_stream_out_TDATA;
    stream_out_TDEST <= Mat2AXIvideo_U0_stream_out_TDEST;
    stream_out_TID <= Mat2AXIvideo_U0_stream_out_TID;
    stream_out_TKEEP <= Mat2AXIvideo_U0_stream_out_TKEEP;
    stream_out_TLAST <= Mat2AXIvideo_U0_stream_out_TLAST;
    stream_out_TSTRB <= Mat2AXIvideo_U0_stream_out_TSTRB;
    stream_out_TUSER <= Mat2AXIvideo_U0_stream_out_TUSER;
    stream_out_TVALID <= Mat2AXIvideo_U0_stream_out_TVALID;
end behav;
