-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_bkb_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_bkb_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 => "00000000", 1 => "00010101", 2 => "00011100", 3 => "00100010", 
    4 => "00100111", 5 => "00101011", 6 => "00101110", 7 => "00110010", 
    8 => "00110101", 9 => "00111000", 10 => "00111011", 11 => "00111101", 
    12 => "01000000", 13 => "01000010", 14 => "01000100", 15 => "01000110", 
    16 => "01001000", 17 => "01001010", 18 => "01001100", 19 => "01001110", 
    20 => "01010000", 21 => "01010010", 22 => "01010100", 23 => "01010101", 
    24 => "01010111", 25 => "01011001", 26 => "01011010", 27 => "01011100", 
    28 => "01011101", 29 => "01011111", 30 => "01100000", 31 => "01100010", 
    32 => "01100011", 33 => "01100101", 34 => "01100110", 35 => "01100111", 
    36 => "01101001", 37 => "01101010", 38 => "01101011", 39 => "01101101", 
    40 => "01101110", 41 => "01101111", 42 => "01110000", 43 => "01110010", 
    44 => "01110011", 45 => "01110100", 46 => "01110101", 47 => "01110110", 
    48 => "01110111", 49 => "01111000", 50 => "01111010", 51 => "01111011", 
    52 => "01111100", 53 => "01111101", 54 => "01111110", 55 => "01111111", 
    56 => "10000000", 57 => "10000001", 58 => "10000010", 59 => "10000011", 
    60 => "10000100", 61 => "10000101", 62 => "10000110", 63 => "10000111", 
    64 => "10001000", 65 => "10001001", 66 => "10001010", 67 => "10001011", 
    68 => "10001100", 69 => "10001101", 70 => "10001110", 71 => "10001111", 
    72 to 73=> "10010000", 74 => "10010001", 75 => "10010010", 76 => "10010011", 
    77 => "10010100", 78 => "10010101", 79 => "10010110", 80 to 81=> "10010111", 
    82 => "10011000", 83 => "10011001", 84 => "10011010", 85 => "10011011", 
    86 to 87=> "10011100", 88 => "10011101", 89 => "10011110", 90 => "10011111", 
    91 to 92=> "10100000", 93 => "10100001", 94 => "10100010", 95 => "10100011", 
    96 to 97=> "10100100", 98 => "10100101", 99 => "10100110", 100 to 101=> "10100111", 
    102 => "10101000", 103 => "10101001", 104 to 105=> "10101010", 106 => "10101011", 
    107 => "10101100", 108 to 109=> "10101101", 110 => "10101110", 111 to 112=> "10101111", 
    113 => "10110000", 114 => "10110001", 115 to 116=> "10110010", 117 => "10110011", 
    118 to 119=> "10110100", 120 => "10110101", 121 to 122=> "10110110", 123 => "10110111", 
    124 to 125=> "10111000", 126 => "10111001", 127 to 128=> "10111010", 129 => "10111011", 
    130 to 131=> "10111100", 132 => "10111101", 133 to 134=> "10111110", 135 => "10111111", 
    136 to 137=> "11000000", 138 => "11000001", 139 to 140=> "11000010", 141 to 142=> "11000011", 
    143 => "11000100", 144 to 145=> "11000101", 146 => "11000110", 147 to 148=> "11000111", 
    149 to 150=> "11001000", 151 => "11001001", 152 to 153=> "11001010", 154 to 155=> "11001011", 
    156 => "11001100", 157 to 158=> "11001101", 159 to 160=> "11001110", 161 to 162=> "11001111", 
    163 => "11010000", 164 to 165=> "11010001", 166 to 167=> "11010010", 168 => "11010011", 
    169 to 170=> "11010100", 171 to 172=> "11010101", 173 to 174=> "11010110", 175 to 176=> "11010111", 
    177 => "11011000", 178 to 179=> "11011001", 180 to 181=> "11011010", 182 to 183=> "11011011", 
    184 to 185=> "11011100", 186 to 187=> "11011101", 188 => "11011110", 189 to 190=> "11011111", 
    191 to 192=> "11100000", 193 to 194=> "11100001", 195 to 196=> "11100010", 197 to 198=> "11100011", 
    199 to 200=> "11100100", 201 to 202=> "11100101", 203 to 204=> "11100110", 205 to 206=> "11100111", 
    207 to 208=> "11101000", 209 to 210=> "11101001", 211 to 212=> "11101010", 213 to 214=> "11101011", 
    215 to 216=> "11101100", 217 to 218=> "11101101", 219 to 220=> "11101110", 221 to 222=> "11101111", 
    223 to 224=> "11110000", 225 to 226=> "11110001", 227 to 228=> "11110010", 229 to 230=> "11110011", 
    231 to 232=> "11110100", 233 to 234=> "11110101", 235 to 236=> "11110110", 237 to 238=> "11110111", 
    239 to 240=> "11111000", 241 to 243=> "11111001", 244 to 245=> "11111010", 246 to 247=> "11111011", 
    248 to 249=> "11111100", 250 to 251=> "11111101", 252 to 253=> "11111110", 254 to 255=> "11111111" );
signal mem1 : mem_array := (
    0 => "00000000", 1 => "00010101", 2 => "00011100", 3 => "00100010", 
    4 => "00100111", 5 => "00101011", 6 => "00101110", 7 => "00110010", 
    8 => "00110101", 9 => "00111000", 10 => "00111011", 11 => "00111101", 
    12 => "01000000", 13 => "01000010", 14 => "01000100", 15 => "01000110", 
    16 => "01001000", 17 => "01001010", 18 => "01001100", 19 => "01001110", 
    20 => "01010000", 21 => "01010010", 22 => "01010100", 23 => "01010101", 
    24 => "01010111", 25 => "01011001", 26 => "01011010", 27 => "01011100", 
    28 => "01011101", 29 => "01011111", 30 => "01100000", 31 => "01100010", 
    32 => "01100011", 33 => "01100101", 34 => "01100110", 35 => "01100111", 
    36 => "01101001", 37 => "01101010", 38 => "01101011", 39 => "01101101", 
    40 => "01101110", 41 => "01101111", 42 => "01110000", 43 => "01110010", 
    44 => "01110011", 45 => "01110100", 46 => "01110101", 47 => "01110110", 
    48 => "01110111", 49 => "01111000", 50 => "01111010", 51 => "01111011", 
    52 => "01111100", 53 => "01111101", 54 => "01111110", 55 => "01111111", 
    56 => "10000000", 57 => "10000001", 58 => "10000010", 59 => "10000011", 
    60 => "10000100", 61 => "10000101", 62 => "10000110", 63 => "10000111", 
    64 => "10001000", 65 => "10001001", 66 => "10001010", 67 => "10001011", 
    68 => "10001100", 69 => "10001101", 70 => "10001110", 71 => "10001111", 
    72 to 73=> "10010000", 74 => "10010001", 75 => "10010010", 76 => "10010011", 
    77 => "10010100", 78 => "10010101", 79 => "10010110", 80 to 81=> "10010111", 
    82 => "10011000", 83 => "10011001", 84 => "10011010", 85 => "10011011", 
    86 to 87=> "10011100", 88 => "10011101", 89 => "10011110", 90 => "10011111", 
    91 to 92=> "10100000", 93 => "10100001", 94 => "10100010", 95 => "10100011", 
    96 to 97=> "10100100", 98 => "10100101", 99 => "10100110", 100 to 101=> "10100111", 
    102 => "10101000", 103 => "10101001", 104 to 105=> "10101010", 106 => "10101011", 
    107 => "10101100", 108 to 109=> "10101101", 110 => "10101110", 111 to 112=> "10101111", 
    113 => "10110000", 114 => "10110001", 115 to 116=> "10110010", 117 => "10110011", 
    118 to 119=> "10110100", 120 => "10110101", 121 to 122=> "10110110", 123 => "10110111", 
    124 to 125=> "10111000", 126 => "10111001", 127 to 128=> "10111010", 129 => "10111011", 
    130 to 131=> "10111100", 132 => "10111101", 133 to 134=> "10111110", 135 => "10111111", 
    136 to 137=> "11000000", 138 => "11000001", 139 to 140=> "11000010", 141 to 142=> "11000011", 
    143 => "11000100", 144 to 145=> "11000101", 146 => "11000110", 147 to 148=> "11000111", 
    149 to 150=> "11001000", 151 => "11001001", 152 to 153=> "11001010", 154 to 155=> "11001011", 
    156 => "11001100", 157 to 158=> "11001101", 159 to 160=> "11001110", 161 to 162=> "11001111", 
    163 => "11010000", 164 to 165=> "11010001", 166 to 167=> "11010010", 168 => "11010011", 
    169 to 170=> "11010100", 171 to 172=> "11010101", 173 to 174=> "11010110", 175 to 176=> "11010111", 
    177 => "11011000", 178 to 179=> "11011001", 180 to 181=> "11011010", 182 to 183=> "11011011", 
    184 to 185=> "11011100", 186 to 187=> "11011101", 188 => "11011110", 189 to 190=> "11011111", 
    191 to 192=> "11100000", 193 to 194=> "11100001", 195 to 196=> "11100010", 197 to 198=> "11100011", 
    199 to 200=> "11100100", 201 to 202=> "11100101", 203 to 204=> "11100110", 205 to 206=> "11100111", 
    207 to 208=> "11101000", 209 to 210=> "11101001", 211 to 212=> "11101010", 213 to 214=> "11101011", 
    215 to 216=> "11101100", 217 to 218=> "11101101", 219 to 220=> "11101110", 221 to 222=> "11101111", 
    223 to 224=> "11110000", 225 to 226=> "11110001", 227 to 228=> "11110010", 229 to 230=> "11110011", 
    231 to 232=> "11110100", 233 to 234=> "11110101", 235 to 236=> "11110110", 237 to 238=> "11110111", 
    239 to 240=> "11111000", 241 to 243=> "11111001", 244 to 245=> "11111010", 246 to 247=> "11111011", 
    248 to 249=> "11111100", 250 to 251=> "11111101", 252 to 253=> "11111110", 254 to 255=> "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_bkb is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_bkb is
    component Loop_loop_height_bkb_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_bkb_rom_U :  component Loop_loop_height_bkb_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


