-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_cud_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_cud_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 to 21=> "00000000", 22 to 32=> "00000001", 33 to 40=> "00000010", 41 to 45=> "00000011", 
    46 to 50=> "00000100", 51 to 54=> "00000101", 55 to 58=> "00000110", 59 to 62=> "00000111", 
    63 to 65=> "00001000", 66 to 68=> "00001001", 69 to 71=> "00001010", 72 to 73=> "00001011", 
    74 to 76=> "00001100", 77 to 78=> "00001101", 79 to 80=> "00001110", 81 to 83=> "00001111", 
    84 to 85=> "00010000", 86 to 87=> "00010001", 88 to 89=> "00010010", 90 to 91=> "00010011", 
    92 to 93=> "00010100", 94 => "00010101", 95 to 96=> "00010110", 97 to 98=> "00010111", 
    99 => "00011000", 100 to 101=> "00011001", 102 to 103=> "00011010", 104 => "00011011", 
    105 to 106=> "00011100", 107 => "00011101", 108 to 109=> "00011110", 110 => "00011111", 
    111 => "00100000", 112 to 113=> "00100001", 114 => "00100010", 115 => "00100011", 
    116 to 117=> "00100100", 118 => "00100101", 119 => "00100110", 120 => "00100111", 
    121 to 122=> "00101000", 123 => "00101001", 124 => "00101010", 125 => "00101011", 
    126 => "00101100", 127 => "00101101", 128 to 129=> "00101110", 130 => "00101111", 
    131 => "00110000", 132 => "00110001", 133 => "00110010", 134 => "00110011", 
    135 => "00110100", 136 => "00110101", 137 => "00110110", 138 => "00110111", 
    139 => "00111000", 140 => "00111001", 141 => "00111010", 142 => "00111011", 
    143 => "00111100", 144 => "00111101", 145 => "00111110", 146 => "00111111", 
    147 => "01000000", 148 => "01000001", 149 => "01000011", 150 => "01000100", 
    151 => "01000101", 152 => "01000110", 153 => "01000111", 154 => "01001000", 
    155 => "01001001", 156 => "01001011", 157 => "01001100", 158 => "01001101", 
    159 => "01001110", 160 => "01010000", 161 => "01010001", 162 => "01010010", 
    163 => "01010011", 164 => "01010101", 165 => "01010110", 166 => "01010111", 
    167 => "01011001", 168 => "01011010", 169 => "01011011", 170 => "01011101", 
    171 => "01011110", 172 => "01011111", 173 => "01100001", 174 => "01100010", 
    175 => "01100011", 176 => "01100101", 177 => "01100110", 178 => "01101000", 
    179 => "01101001", 180 => "01101011", 181 => "01101100", 182 => "01101110", 
    183 => "01101111", 184 => "01110001", 185 => "01110010", 186 => "01110100", 
    187 => "01110101", 188 => "01110111", 189 => "01111001", 190 => "01111010", 
    191 => "01111100", 192 => "01111101", 193 => "01111111", 194 => "10000001", 
    195 => "10000010", 196 => "10000100", 197 => "10000110", 198 => "10000111", 
    199 => "10001001", 200 => "10001011", 201 => "10001101", 202 => "10001110", 
    203 => "10010000", 204 => "10010010", 205 => "10010100", 206 => "10010110", 
    207 => "10010111", 208 => "10011001", 209 => "10011011", 210 => "10011101", 
    211 => "10011111", 212 => "10100001", 213 => "10100011", 214 => "10100101", 
    215 => "10100110", 216 => "10101000", 217 => "10101010", 218 => "10101100", 
    219 => "10101110", 220 => "10110000", 221 => "10110010", 222 => "10110100", 
    223 => "10110110", 224 => "10111000", 225 => "10111010", 226 => "10111101", 
    227 => "10111111", 228 => "11000001", 229 => "11000011", 230 => "11000101", 
    231 => "11000111", 232 => "11001001", 233 => "11001100", 234 => "11001110", 
    235 => "11010000", 236 => "11010010", 237 => "11010100", 238 => "11010111", 
    239 => "11011001", 240 => "11011011", 241 => "11011101", 242 => "11100000", 
    243 => "11100010", 244 => "11100100", 245 => "11100111", 246 => "11101001", 
    247 => "11101011", 248 => "11101110", 249 => "11110000", 250 => "11110011", 
    251 => "11110101", 252 => "11111000", 253 => "11111010", 254 => "11111101", 
    255 => "11111111" );
signal mem1 : mem_array := (
    0 to 21=> "00000000", 22 to 32=> "00000001", 33 to 40=> "00000010", 41 to 45=> "00000011", 
    46 to 50=> "00000100", 51 to 54=> "00000101", 55 to 58=> "00000110", 59 to 62=> "00000111", 
    63 to 65=> "00001000", 66 to 68=> "00001001", 69 to 71=> "00001010", 72 to 73=> "00001011", 
    74 to 76=> "00001100", 77 to 78=> "00001101", 79 to 80=> "00001110", 81 to 83=> "00001111", 
    84 to 85=> "00010000", 86 to 87=> "00010001", 88 to 89=> "00010010", 90 to 91=> "00010011", 
    92 to 93=> "00010100", 94 => "00010101", 95 to 96=> "00010110", 97 to 98=> "00010111", 
    99 => "00011000", 100 to 101=> "00011001", 102 to 103=> "00011010", 104 => "00011011", 
    105 to 106=> "00011100", 107 => "00011101", 108 to 109=> "00011110", 110 => "00011111", 
    111 => "00100000", 112 to 113=> "00100001", 114 => "00100010", 115 => "00100011", 
    116 to 117=> "00100100", 118 => "00100101", 119 => "00100110", 120 => "00100111", 
    121 to 122=> "00101000", 123 => "00101001", 124 => "00101010", 125 => "00101011", 
    126 => "00101100", 127 => "00101101", 128 to 129=> "00101110", 130 => "00101111", 
    131 => "00110000", 132 => "00110001", 133 => "00110010", 134 => "00110011", 
    135 => "00110100", 136 => "00110101", 137 => "00110110", 138 => "00110111", 
    139 => "00111000", 140 => "00111001", 141 => "00111010", 142 => "00111011", 
    143 => "00111100", 144 => "00111101", 145 => "00111110", 146 => "00111111", 
    147 => "01000000", 148 => "01000001", 149 => "01000011", 150 => "01000100", 
    151 => "01000101", 152 => "01000110", 153 => "01000111", 154 => "01001000", 
    155 => "01001001", 156 => "01001011", 157 => "01001100", 158 => "01001101", 
    159 => "01001110", 160 => "01010000", 161 => "01010001", 162 => "01010010", 
    163 => "01010011", 164 => "01010101", 165 => "01010110", 166 => "01010111", 
    167 => "01011001", 168 => "01011010", 169 => "01011011", 170 => "01011101", 
    171 => "01011110", 172 => "01011111", 173 => "01100001", 174 => "01100010", 
    175 => "01100011", 176 => "01100101", 177 => "01100110", 178 => "01101000", 
    179 => "01101001", 180 => "01101011", 181 => "01101100", 182 => "01101110", 
    183 => "01101111", 184 => "01110001", 185 => "01110010", 186 => "01110100", 
    187 => "01110101", 188 => "01110111", 189 => "01111001", 190 => "01111010", 
    191 => "01111100", 192 => "01111101", 193 => "01111111", 194 => "10000001", 
    195 => "10000010", 196 => "10000100", 197 => "10000110", 198 => "10000111", 
    199 => "10001001", 200 => "10001011", 201 => "10001101", 202 => "10001110", 
    203 => "10010000", 204 => "10010010", 205 => "10010100", 206 => "10010110", 
    207 => "10010111", 208 => "10011001", 209 => "10011011", 210 => "10011101", 
    211 => "10011111", 212 => "10100001", 213 => "10100011", 214 => "10100101", 
    215 => "10100110", 216 => "10101000", 217 => "10101010", 218 => "10101100", 
    219 => "10101110", 220 => "10110000", 221 => "10110010", 222 => "10110100", 
    223 => "10110110", 224 => "10111000", 225 => "10111010", 226 => "10111101", 
    227 => "10111111", 228 => "11000001", 229 => "11000011", 230 => "11000101", 
    231 => "11000111", 232 => "11001001", 233 => "11001100", 234 => "11001110", 
    235 => "11010000", 236 => "11010010", 237 => "11010100", 238 => "11010111", 
    239 => "11011001", 240 => "11011011", 241 => "11011101", 242 => "11100000", 
    243 => "11100010", 244 => "11100100", 245 => "11100111", 246 => "11101001", 
    247 => "11101011", 248 => "11101110", 249 => "11110000", 250 => "11110011", 
    251 => "11110101", 252 => "11111000", 253 => "11111010", 254 => "11111101", 
    255 => "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_cud is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_cud is
    component Loop_loop_height_cud_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_cud_rom_U :  component Loop_loop_height_cud_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


