-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_dEe_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_dEe_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 to 73=> "00000000", 74 to 91=> "00000001", 92 to 101=> "00000010", 102 to 108=> "00000011", 
    109 to 113=> "00000100", 114 to 118=> "00000101", 119 to 122=> "00000110", 123 to 125=> "00000111", 
    126 to 129=> "00001000", 130 to 132=> "00001001", 133 to 134=> "00001010", 135 to 137=> "00001011", 
    138 to 139=> "00001100", 140 to 141=> "00001101", 142 to 143=> "00001110", 144 to 145=> "00001111", 
    146 to 147=> "00010000", 148 to 149=> "00010001", 150 => "00010010", 151 to 152=> "00010011", 
    153 to 154=> "00010100", 155 => "00010101", 156 => "00010110", 157 to 158=> "00010111", 
    159 => "00011000", 160 => "00011001", 161 to 162=> "00011010", 163 => "00011011", 
    164 => "00011100", 165 => "00011101", 166 => "00011110", 167 => "00011111", 
    168 => "00100000", 169 => "00100001", 170 => "00100010", 171 => "00100011", 
    172 => "00100100", 173 => "00100101", 174 => "00100110", 175 => "00100111", 
    176 => "00101000", 177 => "00101001", 178 => "00101010", 179 => "00101011", 
    180 => "00101101", 181 => "00101110", 182 => "00101111", 183 => "00110001", 
    184 => "00110010", 185 => "00110011", 186 => "00110101", 187 => "00110110", 
    188 => "00111000", 189 => "00111001", 190 => "00111011", 191 => "00111100", 
    192 => "00111110", 193 => "00111111", 194 => "01000001", 195 => "01000011", 
    196 => "01000100", 197 => "01000110", 198 => "01001000", 199 => "01001010", 
    200 => "01001100", 201 => "01001110", 202 => "01010000", 203 => "01010010", 
    204 => "01010100", 205 => "01010110", 206 => "01011000", 207 => "01011010", 
    208 => "01011100", 209 => "01011110", 210 => "01100001", 211 => "01100011", 
    212 => "01100101", 213 => "01101000", 214 => "01101010", 215 => "01101101", 
    216 => "01101111", 217 => "01110010", 218 => "01110100", 219 => "01110111", 
    220 => "01111010", 221 => "01111101", 222 => "10000000", 223 => "10000010", 
    224 => "10000101", 225 => "10001000", 226 => "10001011", 227 => "10001111", 
    228 => "10010010", 229 => "10010101", 230 => "10011000", 231 => "10011100", 
    232 => "10011111", 233 => "10100010", 234 => "10100110", 235 => "10101010", 
    236 => "10101101", 237 => "10110001", 238 => "10110101", 239 => "10111000", 
    240 => "10111100", 241 => "11000000", 242 => "11000100", 243 => "11001000", 
    244 => "11001101", 245 => "11010001", 246 => "11010101", 247 => "11011001", 
    248 => "11011110", 249 => "11100010", 250 => "11100111", 251 => "11101100", 
    252 => "11110000", 253 => "11110101", 254 => "11111010", 255 => "11111111" );
signal mem1 : mem_array := (
    0 to 73=> "00000000", 74 to 91=> "00000001", 92 to 101=> "00000010", 102 to 108=> "00000011", 
    109 to 113=> "00000100", 114 to 118=> "00000101", 119 to 122=> "00000110", 123 to 125=> "00000111", 
    126 to 129=> "00001000", 130 to 132=> "00001001", 133 to 134=> "00001010", 135 to 137=> "00001011", 
    138 to 139=> "00001100", 140 to 141=> "00001101", 142 to 143=> "00001110", 144 to 145=> "00001111", 
    146 to 147=> "00010000", 148 to 149=> "00010001", 150 => "00010010", 151 to 152=> "00010011", 
    153 to 154=> "00010100", 155 => "00010101", 156 => "00010110", 157 to 158=> "00010111", 
    159 => "00011000", 160 => "00011001", 161 to 162=> "00011010", 163 => "00011011", 
    164 => "00011100", 165 => "00011101", 166 => "00011110", 167 => "00011111", 
    168 => "00100000", 169 => "00100001", 170 => "00100010", 171 => "00100011", 
    172 => "00100100", 173 => "00100101", 174 => "00100110", 175 => "00100111", 
    176 => "00101000", 177 => "00101001", 178 => "00101010", 179 => "00101011", 
    180 => "00101101", 181 => "00101110", 182 => "00101111", 183 => "00110001", 
    184 => "00110010", 185 => "00110011", 186 => "00110101", 187 => "00110110", 
    188 => "00111000", 189 => "00111001", 190 => "00111011", 191 => "00111100", 
    192 => "00111110", 193 => "00111111", 194 => "01000001", 195 => "01000011", 
    196 => "01000100", 197 => "01000110", 198 => "01001000", 199 => "01001010", 
    200 => "01001100", 201 => "01001110", 202 => "01010000", 203 => "01010010", 
    204 => "01010100", 205 => "01010110", 206 => "01011000", 207 => "01011010", 
    208 => "01011100", 209 => "01011110", 210 => "01100001", 211 => "01100011", 
    212 => "01100101", 213 => "01101000", 214 => "01101010", 215 => "01101101", 
    216 => "01101111", 217 => "01110010", 218 => "01110100", 219 => "01110111", 
    220 => "01111010", 221 => "01111101", 222 => "10000000", 223 => "10000010", 
    224 => "10000101", 225 => "10001000", 226 => "10001011", 227 => "10001111", 
    228 => "10010010", 229 => "10010101", 230 => "10011000", 231 => "10011100", 
    232 => "10011111", 233 => "10100010", 234 => "10100110", 235 => "10101010", 
    236 => "10101101", 237 => "10110001", 238 => "10110101", 239 => "10111000", 
    240 => "10111100", 241 => "11000000", 242 => "11000100", 243 => "11001000", 
    244 => "11001101", 245 => "11010001", 246 => "11010101", 247 => "11011001", 
    248 => "11011110", 249 => "11100010", 250 => "11100111", 251 => "11101100", 
    252 => "11110000", 253 => "11110101", 254 => "11111010", 255 => "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_dEe is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_dEe is
    component Loop_loop_height_dEe_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_dEe_rom_U :  component Loop_loop_height_dEe_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


