-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_fYi_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_fYi_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 => "00000000", 1 => "00000101", 2 => "00001000", 3 => "00001011", 
    4 => "00001101", 5 => "00001111", 6 => "00010010", 7 => "00010100", 
    8 => "00010110", 9 => "00010111", 10 => "00011001", 11 => "00011011", 
    12 => "00011101", 13 => "00011110", 14 => "00100000", 15 => "00100010", 
    16 => "00100011", 17 => "00100101", 18 => "00100110", 19 => "00101000", 
    20 => "00101001", 21 => "00101011", 22 => "00101100", 23 => "00101110", 
    24 => "00101111", 25 => "00110001", 26 => "00110010", 27 => "00110011", 
    28 => "00110101", 29 => "00110110", 30 => "00110111", 31 => "00111001", 
    32 => "00111010", 33 => "00111011", 34 => "00111100", 35 => "00111110", 
    36 => "00111111", 37 => "01000000", 38 => "01000001", 39 => "01000011", 
    40 => "01000100", 41 => "01000101", 42 => "01000110", 43 => "01001000", 
    44 => "01001001", 45 => "01001010", 46 => "01001011", 47 => "01001100", 
    48 => "01001101", 49 => "01001110", 50 => "01010000", 51 => "01010001", 
    52 => "01010010", 53 => "01010011", 54 => "01010100", 55 => "01010101", 
    56 => "01010110", 57 => "01010111", 58 => "01011001", 59 => "01011010", 
    60 => "01011011", 61 => "01011100", 62 => "01011101", 63 => "01011110", 
    64 => "01011111", 65 => "01100000", 66 => "01100001", 67 => "01100010", 
    68 => "01100011", 69 => "01100100", 70 => "01100101", 71 => "01100110", 
    72 => "01100111", 73 => "01101000", 74 => "01101001", 75 => "01101010", 
    76 => "01101011", 77 => "01101100", 78 => "01101101", 79 => "01101110", 
    80 => "01101111", 81 => "01110000", 82 => "01110001", 83 => "01110010", 
    84 => "01110011", 85 => "01110100", 86 => "01110101", 87 => "01110110", 
    88 => "01110111", 89 => "01111000", 90 => "01111001", 91 => "01111010", 
    92 => "01111011", 93 => "01111100", 94 => "01111101", 95 => "01111110", 
    96 => "01111111", 97 => "10000000", 98 => "10000001", 99 => "10000010", 
    100 => "10000011", 101 => "10000100", 102 to 103=> "10000101", 104 => "10000110", 
    105 => "10000111", 106 => "10001000", 107 => "10001001", 108 => "10001010", 
    109 => "10001011", 110 => "10001100", 111 => "10001101", 112 => "10001110", 
    113 to 114=> "10001111", 115 => "10010000", 116 => "10010001", 117 => "10010010", 
    118 => "10010011", 119 => "10010100", 120 => "10010101", 121 => "10010110", 
    122 to 123=> "10010111", 124 => "10011000", 125 => "10011001", 126 => "10011010", 
    127 => "10011011", 128 => "10011100", 129 => "10011101", 130 to 131=> "10011110", 
    132 => "10011111", 133 => "10100000", 134 => "10100001", 135 => "10100010", 
    136 => "10100011", 137 to 138=> "10100100", 139 => "10100101", 140 => "10100110", 
    141 => "10100111", 142 => "10101000", 143 => "10101001", 144 to 145=> "10101010", 
    146 => "10101011", 147 => "10101100", 148 => "10101101", 149 => "10101110", 
    150 to 151=> "10101111", 152 => "10110000", 153 => "10110001", 154 => "10110010", 
    155 => "10110011", 156 to 157=> "10110100", 158 => "10110101", 159 => "10110110", 
    160 => "10110111", 161 to 162=> "10111000", 163 => "10111001", 164 => "10111010", 
    165 => "10111011", 166 to 167=> "10111100", 168 => "10111101", 169 => "10111110", 
    170 => "10111111", 171 to 172=> "11000000", 173 => "11000001", 174 => "11000010", 
    175 => "11000011", 176 to 177=> "11000100", 178 => "11000101", 179 => "11000110", 
    180 => "11000111", 181 to 182=> "11001000", 183 => "11001001", 184 => "11001010", 
    185 => "11001011", 186 to 187=> "11001100", 188 => "11001101", 189 => "11001110", 
    190 to 191=> "11001111", 192 => "11010000", 193 => "11010001", 194 => "11010010", 
    195 to 196=> "11010011", 197 => "11010100", 198 => "11010101", 199 to 200=> "11010110", 
    201 => "11010111", 202 => "11011000", 203 to 204=> "11011001", 205 => "11011010", 
    206 => "11011011", 207 to 208=> "11011100", 209 => "11011101", 210 => "11011110", 
    211 to 212=> "11011111", 213 => "11100000", 214 => "11100001", 215 to 216=> "11100010", 
    217 => "11100011", 218 => "11100100", 219 to 220=> "11100101", 221 => "11100110", 
    222 => "11100111", 223 to 224=> "11101000", 225 => "11101001", 226 => "11101010", 
    227 to 228=> "11101011", 229 => "11101100", 230 => "11101101", 231 to 232=> "11101110", 
    233 => "11101111", 234 => "11110000", 235 to 236=> "11110001", 237 => "11110010", 
    238 to 239=> "11110011", 240 => "11110100", 241 => "11110101", 242 to 243=> "11110110", 
    244 => "11110111", 245 => "11111000", 246 to 247=> "11111001", 248 => "11111010", 
    249 to 250=> "11111011", 251 => "11111100", 252 => "11111101", 253 to 254=> "11111110", 
    255 => "11111111" );
signal mem1 : mem_array := (
    0 => "00000000", 1 => "00000101", 2 => "00001000", 3 => "00001011", 
    4 => "00001101", 5 => "00001111", 6 => "00010010", 7 => "00010100", 
    8 => "00010110", 9 => "00010111", 10 => "00011001", 11 => "00011011", 
    12 => "00011101", 13 => "00011110", 14 => "00100000", 15 => "00100010", 
    16 => "00100011", 17 => "00100101", 18 => "00100110", 19 => "00101000", 
    20 => "00101001", 21 => "00101011", 22 => "00101100", 23 => "00101110", 
    24 => "00101111", 25 => "00110001", 26 => "00110010", 27 => "00110011", 
    28 => "00110101", 29 => "00110110", 30 => "00110111", 31 => "00111001", 
    32 => "00111010", 33 => "00111011", 34 => "00111100", 35 => "00111110", 
    36 => "00111111", 37 => "01000000", 38 => "01000001", 39 => "01000011", 
    40 => "01000100", 41 => "01000101", 42 => "01000110", 43 => "01001000", 
    44 => "01001001", 45 => "01001010", 46 => "01001011", 47 => "01001100", 
    48 => "01001101", 49 => "01001110", 50 => "01010000", 51 => "01010001", 
    52 => "01010010", 53 => "01010011", 54 => "01010100", 55 => "01010101", 
    56 => "01010110", 57 => "01010111", 58 => "01011001", 59 => "01011010", 
    60 => "01011011", 61 => "01011100", 62 => "01011101", 63 => "01011110", 
    64 => "01011111", 65 => "01100000", 66 => "01100001", 67 => "01100010", 
    68 => "01100011", 69 => "01100100", 70 => "01100101", 71 => "01100110", 
    72 => "01100111", 73 => "01101000", 74 => "01101001", 75 => "01101010", 
    76 => "01101011", 77 => "01101100", 78 => "01101101", 79 => "01101110", 
    80 => "01101111", 81 => "01110000", 82 => "01110001", 83 => "01110010", 
    84 => "01110011", 85 => "01110100", 86 => "01110101", 87 => "01110110", 
    88 => "01110111", 89 => "01111000", 90 => "01111001", 91 => "01111010", 
    92 => "01111011", 93 => "01111100", 94 => "01111101", 95 => "01111110", 
    96 => "01111111", 97 => "10000000", 98 => "10000001", 99 => "10000010", 
    100 => "10000011", 101 => "10000100", 102 to 103=> "10000101", 104 => "10000110", 
    105 => "10000111", 106 => "10001000", 107 => "10001001", 108 => "10001010", 
    109 => "10001011", 110 => "10001100", 111 => "10001101", 112 => "10001110", 
    113 to 114=> "10001111", 115 => "10010000", 116 => "10010001", 117 => "10010010", 
    118 => "10010011", 119 => "10010100", 120 => "10010101", 121 => "10010110", 
    122 to 123=> "10010111", 124 => "10011000", 125 => "10011001", 126 => "10011010", 
    127 => "10011011", 128 => "10011100", 129 => "10011101", 130 to 131=> "10011110", 
    132 => "10011111", 133 => "10100000", 134 => "10100001", 135 => "10100010", 
    136 => "10100011", 137 to 138=> "10100100", 139 => "10100101", 140 => "10100110", 
    141 => "10100111", 142 => "10101000", 143 => "10101001", 144 to 145=> "10101010", 
    146 => "10101011", 147 => "10101100", 148 => "10101101", 149 => "10101110", 
    150 to 151=> "10101111", 152 => "10110000", 153 => "10110001", 154 => "10110010", 
    155 => "10110011", 156 to 157=> "10110100", 158 => "10110101", 159 => "10110110", 
    160 => "10110111", 161 to 162=> "10111000", 163 => "10111001", 164 => "10111010", 
    165 => "10111011", 166 to 167=> "10111100", 168 => "10111101", 169 => "10111110", 
    170 => "10111111", 171 to 172=> "11000000", 173 => "11000001", 174 => "11000010", 
    175 => "11000011", 176 to 177=> "11000100", 178 => "11000101", 179 => "11000110", 
    180 => "11000111", 181 to 182=> "11001000", 183 => "11001001", 184 => "11001010", 
    185 => "11001011", 186 to 187=> "11001100", 188 => "11001101", 189 => "11001110", 
    190 to 191=> "11001111", 192 => "11010000", 193 => "11010001", 194 => "11010010", 
    195 to 196=> "11010011", 197 => "11010100", 198 => "11010101", 199 to 200=> "11010110", 
    201 => "11010111", 202 => "11011000", 203 to 204=> "11011001", 205 => "11011010", 
    206 => "11011011", 207 to 208=> "11011100", 209 => "11011101", 210 => "11011110", 
    211 to 212=> "11011111", 213 => "11100000", 214 => "11100001", 215 to 216=> "11100010", 
    217 => "11100011", 218 => "11100100", 219 to 220=> "11100101", 221 => "11100110", 
    222 => "11100111", 223 to 224=> "11101000", 225 => "11101001", 226 => "11101010", 
    227 to 228=> "11101011", 229 => "11101100", 230 => "11101101", 231 to 232=> "11101110", 
    233 => "11101111", 234 => "11110000", 235 to 236=> "11110001", 237 => "11110010", 
    238 to 239=> "11110011", 240 => "11110100", 241 => "11110101", 242 to 243=> "11110110", 
    244 => "11110111", 245 => "11111000", 246 to 247=> "11111001", 248 => "11111010", 
    249 to 250=> "11111011", 251 => "11111100", 252 => "11111101", 253 to 254=> "11111110", 
    255 => "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_fYi is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_fYi is
    component Loop_loop_height_fYi_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_fYi_rom_U :  component Loop_loop_height_fYi_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


