-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_ibs_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          addr1      : in std_logic_vector(awidth-1 downto 0); 
          ce1       : in std_logic; 
          q1         : out std_logic_vector(dwidth-1 downto 0);
          addr2      : in std_logic_vector(awidth-1 downto 0); 
          ce2       : in std_logic; 
          q2         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_ibs_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr1_tmp : std_logic_vector(awidth-1 downto 0); 
signal addr2_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem0 : mem_array := (
    0 => "00000000", 1 => "00010000", 2 => "00010111", 3 => "00011100", 
    4 => "00100000", 5 => "00100100", 6 => "00100111", 7 => "00101010", 
    8 => "00101101", 9 => "00110000", 10 => "00110010", 11 => "00110101", 
    12 => "00110111", 13 => "00111010", 14 => "00111100", 15 => "00111110", 
    16 => "01000000", 17 => "01000010", 18 => "01000100", 19 => "01000110", 
    20 => "01000111", 21 => "01001001", 22 => "01001011", 23 => "01001101", 
    24 => "01001110", 25 => "01010000", 26 => "01010001", 27 => "01010011", 
    28 => "01010100", 29 => "01010110", 30 => "01010111", 31 => "01011001", 
    32 => "01011010", 33 => "01011100", 34 => "01011101", 35 => "01011110", 
    36 => "01100000", 37 => "01100001", 38 => "01100010", 39 => "01100100", 
    40 => "01100101", 41 => "01100110", 42 => "01100111", 43 => "01101001", 
    44 => "01101010", 45 => "01101011", 46 => "01101100", 47 => "01101101", 
    48 => "01101111", 49 => "01110000", 50 => "01110001", 51 => "01110010", 
    52 => "01110011", 53 => "01110100", 54 => "01110101", 55 => "01110110", 
    56 => "01110111", 57 => "01111001", 58 => "01111010", 59 => "01111011", 
    60 => "01111100", 61 => "01111101", 62 => "01111110", 63 => "01111111", 
    64 => "10000000", 65 => "10000001", 66 => "10000010", 67 => "10000011", 
    68 => "10000100", 69 => "10000101", 70 => "10000110", 71 to 72=> "10000111", 
    73 => "10001000", 74 => "10001001", 75 => "10001010", 76 => "10001011", 
    77 => "10001100", 78 => "10001101", 79 => "10001110", 80 => "10001111", 
    81 => "10010000", 82 to 83=> "10010001", 84 => "10010010", 85 => "10010011", 
    86 => "10010100", 87 => "10010101", 88 => "10010110", 89 to 90=> "10010111", 
    91 => "10011000", 92 => "10011001", 93 => "10011010", 94 => "10011011", 
    95 to 96=> "10011100", 97 => "10011101", 98 => "10011110", 99 => "10011111", 
    100 to 101=> "10100000", 102 => "10100001", 103 => "10100010", 104 => "10100011", 
    105 to 106=> "10100100", 107 => "10100101", 108 => "10100110", 109 to 110=> "10100111", 
    111 => "10101000", 112 => "10101001", 113 to 114=> "10101010", 115 => "10101011", 
    116 => "10101100", 117 to 118=> "10101101", 119 => "10101110", 120 => "10101111", 
    121 to 122=> "10110000", 123 => "10110001", 124 => "10110010", 125 to 126=> "10110011", 
    127 => "10110100", 128 to 129=> "10110101", 130 => "10110110", 131 to 132=> "10110111", 
    133 => "10111000", 134 => "10111001", 135 to 136=> "10111010", 137 => "10111011", 
    138 to 139=> "10111100", 140 => "10111101", 141 to 142=> "10111110", 143 => "10111111", 
    144 to 145=> "11000000", 146 => "11000001", 147 to 148=> "11000010", 149 => "11000011", 
    150 to 151=> "11000100", 152 => "11000101", 153 to 154=> "11000110", 155 to 156=> "11000111", 
    157 => "11001000", 158 to 159=> "11001001", 160 => "11001010", 161 to 162=> "11001011", 
    163 to 164=> "11001100", 165 => "11001101", 166 to 167=> "11001110", 168 => "11001111", 
    169 to 170=> "11010000", 171 to 172=> "11010001", 173 => "11010010", 174 to 175=> "11010011", 
    176 to 177=> "11010100", 178 => "11010101", 179 to 180=> "11010110", 181 to 182=> "11010111", 
    183 => "11011000", 184 to 185=> "11011001", 186 to 187=> "11011010", 188 => "11011011", 
    189 to 190=> "11011100", 191 to 192=> "11011101", 193 to 194=> "11011110", 195 => "11011111", 
    196 to 197=> "11100000", 198 to 199=> "11100001", 200 to 201=> "11100010", 202 => "11100011", 
    203 to 204=> "11100100", 205 to 206=> "11100101", 207 to 208=> "11100110", 209 to 210=> "11100111", 
    211 => "11101000", 212 to 213=> "11101001", 214 to 215=> "11101010", 216 to 217=> "11101011", 
    218 to 219=> "11101100", 220 to 221=> "11101101", 222 to 223=> "11101110", 224 => "11101111", 
    225 to 226=> "11110000", 227 to 228=> "11110001", 229 to 230=> "11110010", 231 to 232=> "11110011", 
    233 to 234=> "11110100", 235 to 236=> "11110101", 237 to 238=> "11110110", 239 to 240=> "11110111", 
    241 to 242=> "11111000", 243 to 244=> "11111001", 245 to 246=> "11111010", 247 to 248=> "11111011", 
    249 to 250=> "11111100", 251 to 252=> "11111101", 253 to 254=> "11111110", 255 => "11111111" );
signal mem1 : mem_array := (
    0 => "00000000", 1 => "00010000", 2 => "00010111", 3 => "00011100", 
    4 => "00100000", 5 => "00100100", 6 => "00100111", 7 => "00101010", 
    8 => "00101101", 9 => "00110000", 10 => "00110010", 11 => "00110101", 
    12 => "00110111", 13 => "00111010", 14 => "00111100", 15 => "00111110", 
    16 => "01000000", 17 => "01000010", 18 => "01000100", 19 => "01000110", 
    20 => "01000111", 21 => "01001001", 22 => "01001011", 23 => "01001101", 
    24 => "01001110", 25 => "01010000", 26 => "01010001", 27 => "01010011", 
    28 => "01010100", 29 => "01010110", 30 => "01010111", 31 => "01011001", 
    32 => "01011010", 33 => "01011100", 34 => "01011101", 35 => "01011110", 
    36 => "01100000", 37 => "01100001", 38 => "01100010", 39 => "01100100", 
    40 => "01100101", 41 => "01100110", 42 => "01100111", 43 => "01101001", 
    44 => "01101010", 45 => "01101011", 46 => "01101100", 47 => "01101101", 
    48 => "01101111", 49 => "01110000", 50 => "01110001", 51 => "01110010", 
    52 => "01110011", 53 => "01110100", 54 => "01110101", 55 => "01110110", 
    56 => "01110111", 57 => "01111001", 58 => "01111010", 59 => "01111011", 
    60 => "01111100", 61 => "01111101", 62 => "01111110", 63 => "01111111", 
    64 => "10000000", 65 => "10000001", 66 => "10000010", 67 => "10000011", 
    68 => "10000100", 69 => "10000101", 70 => "10000110", 71 to 72=> "10000111", 
    73 => "10001000", 74 => "10001001", 75 => "10001010", 76 => "10001011", 
    77 => "10001100", 78 => "10001101", 79 => "10001110", 80 => "10001111", 
    81 => "10010000", 82 to 83=> "10010001", 84 => "10010010", 85 => "10010011", 
    86 => "10010100", 87 => "10010101", 88 => "10010110", 89 to 90=> "10010111", 
    91 => "10011000", 92 => "10011001", 93 => "10011010", 94 => "10011011", 
    95 to 96=> "10011100", 97 => "10011101", 98 => "10011110", 99 => "10011111", 
    100 to 101=> "10100000", 102 => "10100001", 103 => "10100010", 104 => "10100011", 
    105 to 106=> "10100100", 107 => "10100101", 108 => "10100110", 109 to 110=> "10100111", 
    111 => "10101000", 112 => "10101001", 113 to 114=> "10101010", 115 => "10101011", 
    116 => "10101100", 117 to 118=> "10101101", 119 => "10101110", 120 => "10101111", 
    121 to 122=> "10110000", 123 => "10110001", 124 => "10110010", 125 to 126=> "10110011", 
    127 => "10110100", 128 to 129=> "10110101", 130 => "10110110", 131 to 132=> "10110111", 
    133 => "10111000", 134 => "10111001", 135 to 136=> "10111010", 137 => "10111011", 
    138 to 139=> "10111100", 140 => "10111101", 141 to 142=> "10111110", 143 => "10111111", 
    144 to 145=> "11000000", 146 => "11000001", 147 to 148=> "11000010", 149 => "11000011", 
    150 to 151=> "11000100", 152 => "11000101", 153 to 154=> "11000110", 155 to 156=> "11000111", 
    157 => "11001000", 158 to 159=> "11001001", 160 => "11001010", 161 to 162=> "11001011", 
    163 to 164=> "11001100", 165 => "11001101", 166 to 167=> "11001110", 168 => "11001111", 
    169 to 170=> "11010000", 171 to 172=> "11010001", 173 => "11010010", 174 to 175=> "11010011", 
    176 to 177=> "11010100", 178 => "11010101", 179 to 180=> "11010110", 181 to 182=> "11010111", 
    183 => "11011000", 184 to 185=> "11011001", 186 to 187=> "11011010", 188 => "11011011", 
    189 to 190=> "11011100", 191 to 192=> "11011101", 193 to 194=> "11011110", 195 => "11011111", 
    196 to 197=> "11100000", 198 to 199=> "11100001", 200 to 201=> "11100010", 202 => "11100011", 
    203 to 204=> "11100100", 205 to 206=> "11100101", 207 to 208=> "11100110", 209 to 210=> "11100111", 
    211 => "11101000", 212 to 213=> "11101001", 214 to 215=> "11101010", 216 to 217=> "11101011", 
    218 to 219=> "11101100", 220 to 221=> "11101101", 222 to 223=> "11101110", 224 => "11101111", 
    225 to 226=> "11110000", 227 to 228=> "11110001", 229 to 230=> "11110010", 231 to 232=> "11110011", 
    233 to 234=> "11110100", 235 to 236=> "11110101", 237 to 238=> "11110110", 239 to 240=> "11110111", 
    241 to 242=> "11111000", 243 to 244=> "11111001", 245 to 246=> "11111010", 247 to 248=> "11111011", 
    249 to 250=> "11111100", 251 to 252=> "11111101", 253 to 254=> "11111110", 255 => "11111111" );

attribute syn_rom_style : string;
attribute syn_rom_style of mem0 : signal is "block_rom";
attribute syn_rom_style of mem1 : signal is "block_rom";
attribute ROM_STYLE : string;
attribute ROM_STYLE of mem0 : signal is "block";
attribute ROM_STYLE of mem1 : signal is "block";

begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

memory_access_guard_1: process (addr1) 
begin
      addr1_tmp <= addr1;
--synthesis translate_off
      if (CONV_INTEGER(addr1) > mem_size-1) then
           addr1_tmp <= (others => '0');
      else 
           addr1_tmp <= addr1;
      end if;
--synthesis translate_on
end process;

memory_access_guard_2: process (addr2) 
begin
      addr2_tmp <= addr2;
--synthesis translate_off
      if (CONV_INTEGER(addr2) > mem_size-1) then
           addr2_tmp <= (others => '0');
      else 
           addr2_tmp <= addr2;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem0(CONV_INTEGER(addr0_tmp)); 
        end if;
        if (ce1 = '1') then 
            q1 <= mem0(CONV_INTEGER(addr1_tmp)); 
        end if;
        if (ce2 = '1') then 
            q2 <= mem1(CONV_INTEGER(addr2_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_ibs is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address1 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce1 : IN STD_LOGIC;
        q1 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0);
        address2 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce2 : IN STD_LOGIC;
        q2 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_ibs is
    component Loop_loop_height_ibs_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR;
            addr1 : IN STD_LOGIC_VECTOR;
            ce1 : IN STD_LOGIC;
            q1 : OUT STD_LOGIC_VECTOR;
            addr2 : IN STD_LOGIC_VECTOR;
            ce2 : IN STD_LOGIC;
            q2 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_ibs_rom_U :  component Loop_loop_height_ibs_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0,
        addr1 => address1,
        ce1 => ce1,
        q1 => q1,
        addr2 => address2,
        ce2 => ce2,
        q2 => q2);

end architecture;


