-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity hls_gamma_correction is
generic (
    C_S_AXI_AXILITES_ADDR_WIDTH : INTEGER := 6;
    C_S_AXI_AXILITES_DATA_WIDTH : INTEGER := 32 );
port (
    s_axi_AXILiteS_AWVALID : IN STD_LOGIC;
    s_axi_AXILiteS_AWREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_ADDR_WIDTH-1 downto 0);
    s_axi_AXILiteS_WVALID : IN STD_LOGIC;
    s_axi_AXILiteS_WREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH-1 downto 0);
    s_axi_AXILiteS_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH/8-1 downto 0);
    s_axi_AXILiteS_ARVALID : IN STD_LOGIC;
    s_axi_AXILiteS_ARREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_ADDR_WIDTH-1 downto 0);
    s_axi_AXILiteS_RVALID : OUT STD_LOGIC;
    s_axi_AXILiteS_RREADY : IN STD_LOGIC;
    s_axi_AXILiteS_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH-1 downto 0);
    s_axi_AXILiteS_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_AXILiteS_BVALID : OUT STD_LOGIC;
    s_axi_AXILiteS_BREADY : IN STD_LOGIC;
    s_axi_AXILiteS_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    stream_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
    stream_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
    stream_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
    stream_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
    stream_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
    stream_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
    stream_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0);
    stream_in_TVALID : IN STD_LOGIC;
    stream_in_TREADY : OUT STD_LOGIC;
    stream_out_TVALID : OUT STD_LOGIC;
    stream_out_TREADY : IN STD_LOGIC );
end;


architecture behav of hls_gamma_correction is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "hls_gamma_correction,hls_ip_2017_4,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xc7z020clg400-1,HLS_INPUT_CLOCK=6.670000,HLS_INPUT_ARCH=dataflow,HLS_SYN_CLOCK=5.658125,HLS_SYN_LAT=-1,HLS_SYN_TPT=-1,HLS_SYN_MEM=16,HLS_SYN_DSP=0,HLS_SYN_FF=1097,HLS_SYN_LUT=2358}";
    constant C_S_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_S_AXI_WSTRB_WIDTH : INTEGER range 63 downto 0 := 4;
    constant C_S_AXI_ADDR_WIDTH : INTEGER range 63 downto 0 := 20;
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_lv24_0 : STD_LOGIC_VECTOR (23 downto 0) := "000000000000000000000000";
    constant ap_const_lv3_0 : STD_LOGIC_VECTOR (2 downto 0) := "000";
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_const_boolean_1 : BOOLEAN := true;

    signal ap_rst_n_inv : STD_LOGIC;
    signal gamma : STD_LOGIC_VECTOR (7 downto 0);
    signal height : STD_LOGIC_VECTOR (15 downto 0);
    signal width : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit570_pr_U0_ap_start : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_start_full_n : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_ap_done : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_ap_continue : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_ap_idle : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_ap_ready : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_start_out : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_start_write : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_img3_rows_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit570_pr_U0_img3_rows_V_out_write : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_img3_cols_V_out_din : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit570_pr_U0_img3_cols_V_out_write : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_p_cols_assign_cast_out_out_din : STD_LOGIC_VECTOR (11 downto 0);
    signal Block_Mat_exit570_pr_U0_p_cols_assign_cast_out_out_write : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_p_rows_assign_cast_out_out_din : STD_LOGIC_VECTOR (11 downto 0);
    signal Block_Mat_exit570_pr_U0_p_rows_assign_cast_out_out_write : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_gamma_out_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Block_Mat_exit570_pr_U0_gamma_out_write : STD_LOGIC;
    signal Block_Mat_exit570_pr_U0_ap_return_0 : STD_LOGIC_VECTOR (15 downto 0);
    signal Block_Mat_exit570_pr_U0_ap_return_1 : STD_LOGIC_VECTOR (15 downto 0);
    signal ap_channel_done_img0_cols_V_channel : STD_LOGIC;
    signal img0_cols_V_channel_full_n : STD_LOGIC;
    signal ap_sync_reg_channel_write_img0_cols_V_channel : STD_LOGIC := '0';
    signal ap_sync_channel_write_img0_cols_V_channel : STD_LOGIC;
    signal ap_channel_done_img0_rows_V_channel : STD_LOGIC;
    signal img0_rows_V_channel_full_n : STD_LOGIC;
    signal ap_sync_reg_channel_write_img0_rows_V_channel : STD_LOGIC := '0';
    signal ap_sync_channel_write_img0_rows_V_channel : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_start : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_done : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_continue : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_idle : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_ready : STD_LOGIC;
    signal AXIvideo2Mat_U0_stream_in_TREADY : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_0_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_1_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_2_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_start : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_done : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_continue : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_idle : STD_LOGIC;
    signal Loop_loop_height_pro_U0_ap_ready : STD_LOGIC;
    signal Loop_loop_height_pro_U0_p_rows_assign_cast_loc_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_p_cols_assign_cast_loc_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img3_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Loop_loop_height_pro_U0_img3_data_stream_0_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img3_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Loop_loop_height_pro_U0_img3_data_stream_1_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img3_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Loop_loop_height_pro_U0_img3_data_stream_2_V_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_gamma_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img0_data_stream_0_V_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img0_data_stream_1_V_read : STD_LOGIC;
    signal Loop_loop_height_pro_U0_img0_data_stream_2_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_start : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_done : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_continue : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_idle : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_ready : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_rows_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_cols_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_0_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_1_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_2_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_stream_out_TDATA : STD_LOGIC_VECTOR (23 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TVALID : STD_LOGIC;
    signal Mat2AXIvideo_U0_stream_out_TKEEP : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TSTRB : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TLAST : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TID : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_stream_out_TDEST : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_sync_continue : STD_LOGIC;
    signal img3_rows_V_c_full_n : STD_LOGIC;
    signal img3_rows_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img3_rows_V_c_empty_n : STD_LOGIC;
    signal img3_cols_V_c_full_n : STD_LOGIC;
    signal img3_cols_V_c_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img3_cols_V_c_empty_n : STD_LOGIC;
    signal p_cols_assign_cast_lo_full_n : STD_LOGIC;
    signal p_cols_assign_cast_lo_dout : STD_LOGIC_VECTOR (11 downto 0);
    signal p_cols_assign_cast_lo_empty_n : STD_LOGIC;
    signal p_rows_assign_cast_lo_full_n : STD_LOGIC;
    signal p_rows_assign_cast_lo_dout : STD_LOGIC_VECTOR (11 downto 0);
    signal p_rows_assign_cast_lo_empty_n : STD_LOGIC;
    signal gamma_c_full_n : STD_LOGIC;
    signal gamma_c_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal gamma_c_empty_n : STD_LOGIC;
    signal img0_rows_V_channel_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img0_rows_V_channel_empty_n : STD_LOGIC;
    signal img0_cols_V_channel_dout : STD_LOGIC_VECTOR (15 downto 0);
    signal img0_cols_V_channel_empty_n : STD_LOGIC;
    signal img0_data_stream_0_s_full_n : STD_LOGIC;
    signal img0_data_stream_0_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img0_data_stream_0_s_empty_n : STD_LOGIC;
    signal img0_data_stream_1_s_full_n : STD_LOGIC;
    signal img0_data_stream_1_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img0_data_stream_1_s_empty_n : STD_LOGIC;
    signal img0_data_stream_2_s_full_n : STD_LOGIC;
    signal img0_data_stream_2_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img0_data_stream_2_s_empty_n : STD_LOGIC;
    signal img3_data_stream_0_s_full_n : STD_LOGIC;
    signal img3_data_stream_0_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img3_data_stream_0_s_empty_n : STD_LOGIC;
    signal img3_data_stream_1_s_full_n : STD_LOGIC;
    signal img3_data_stream_1_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img3_data_stream_1_s_empty_n : STD_LOGIC;
    signal img3_data_stream_2_s_full_n : STD_LOGIC;
    signal img3_data_stream_2_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img3_data_stream_2_s_empty_n : STD_LOGIC;
    signal start_for_Loop_loop_height_pro_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Loop_loop_height_pro_U0_full_n : STD_LOGIC;
    signal start_for_Loop_loop_height_pro_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Loop_loop_height_pro_U0_empty_n : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_full_n : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_empty_n : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_full_n : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_write : STD_LOGIC;
    signal Loop_loop_height_pro_U0_start_full_n : STD_LOGIC;
    signal Loop_loop_height_pro_U0_start_write : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_full_n : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_write : STD_LOGIC;

    component Block_Mat_exit570_pr IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        height : IN STD_LOGIC_VECTOR (15 downto 0);
        width : IN STD_LOGIC_VECTOR (15 downto 0);
        gamma : IN STD_LOGIC_VECTOR (7 downto 0);
        img3_rows_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img3_rows_V_out_full_n : IN STD_LOGIC;
        img3_rows_V_out_write : OUT STD_LOGIC;
        img3_cols_V_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
        img3_cols_V_out_full_n : IN STD_LOGIC;
        img3_cols_V_out_write : OUT STD_LOGIC;
        p_cols_assign_cast_out_out_din : OUT STD_LOGIC_VECTOR (11 downto 0);
        p_cols_assign_cast_out_out_full_n : IN STD_LOGIC;
        p_cols_assign_cast_out_out_write : OUT STD_LOGIC;
        p_rows_assign_cast_out_out_din : OUT STD_LOGIC_VECTOR (11 downto 0);
        p_rows_assign_cast_out_out_full_n : IN STD_LOGIC;
        p_rows_assign_cast_out_out_write : OUT STD_LOGIC;
        gamma_out_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        gamma_out_full_n : IN STD_LOGIC;
        gamma_out_write : OUT STD_LOGIC;
        ap_return_0 : OUT STD_LOGIC_VECTOR (15 downto 0);
        ap_return_1 : OUT STD_LOGIC_VECTOR (15 downto 0) );
    end component;


    component AXIvideo2Mat IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        stream_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
        stream_in_TVALID : IN STD_LOGIC;
        stream_in_TREADY : OUT STD_LOGIC;
        stream_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
        stream_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
        stream_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
        stream_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
        img_rows_V_read : IN STD_LOGIC_VECTOR (15 downto 0);
        img_cols_V_read : IN STD_LOGIC_VECTOR (15 downto 0);
        img_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_full_n : IN STD_LOGIC;
        img_data_stream_0_V_write : OUT STD_LOGIC;
        img_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_full_n : IN STD_LOGIC;
        img_data_stream_1_V_write : OUT STD_LOGIC;
        img_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_full_n : IN STD_LOGIC;
        img_data_stream_2_V_write : OUT STD_LOGIC );
    end component;


    component Loop_loop_height_pro IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        p_rows_assign_cast_loc_dout : IN STD_LOGIC_VECTOR (11 downto 0);
        p_rows_assign_cast_loc_empty_n : IN STD_LOGIC;
        p_rows_assign_cast_loc_read : OUT STD_LOGIC;
        p_cols_assign_cast_loc_dout : IN STD_LOGIC_VECTOR (11 downto 0);
        p_cols_assign_cast_loc_empty_n : IN STD_LOGIC;
        p_cols_assign_cast_loc_read : OUT STD_LOGIC;
        img3_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img3_data_stream_0_V_full_n : IN STD_LOGIC;
        img3_data_stream_0_V_write : OUT STD_LOGIC;
        img3_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img3_data_stream_1_V_full_n : IN STD_LOGIC;
        img3_data_stream_1_V_write : OUT STD_LOGIC;
        img3_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img3_data_stream_2_V_full_n : IN STD_LOGIC;
        img3_data_stream_2_V_write : OUT STD_LOGIC;
        gamma_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        gamma_empty_n : IN STD_LOGIC;
        gamma_read : OUT STD_LOGIC;
        img0_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img0_data_stream_0_V_empty_n : IN STD_LOGIC;
        img0_data_stream_0_V_read : OUT STD_LOGIC;
        img0_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img0_data_stream_1_V_empty_n : IN STD_LOGIC;
        img0_data_stream_1_V_read : OUT STD_LOGIC;
        img0_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img0_data_stream_2_V_empty_n : IN STD_LOGIC;
        img0_data_stream_2_V_read : OUT STD_LOGIC );
    end component;


    component Mat2AXIvideo IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        img_rows_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        img_rows_V_empty_n : IN STD_LOGIC;
        img_rows_V_read : OUT STD_LOGIC;
        img_cols_V_dout : IN STD_LOGIC_VECTOR (15 downto 0);
        img_cols_V_empty_n : IN STD_LOGIC;
        img_cols_V_read : OUT STD_LOGIC;
        img_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_empty_n : IN STD_LOGIC;
        img_data_stream_0_V_read : OUT STD_LOGIC;
        img_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_empty_n : IN STD_LOGIC;
        img_data_stream_1_V_read : OUT STD_LOGIC;
        img_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_empty_n : IN STD_LOGIC;
        img_data_stream_2_V_read : OUT STD_LOGIC;
        stream_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
        stream_out_TVALID : OUT STD_LOGIC;
        stream_out_TREADY : IN STD_LOGIC;
        stream_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
        stream_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
        stream_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
        stream_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0) );
    end component;


    component fifo_w16_d3_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (15 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (15 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w12_d2_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (11 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (11 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w8_d2_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (7 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (7 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w16_d2_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (15 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (15 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w8_d1_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (7 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (7 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Loop_lojbC IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Mat2AXIkbM IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component hls_gamma_correction_AXILiteS_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        gamma : OUT STD_LOGIC_VECTOR (7 downto 0);
        height : OUT STD_LOGIC_VECTOR (15 downto 0);
        width : OUT STD_LOGIC_VECTOR (15 downto 0) );
    end component;



begin
    hls_gamma_correction_AXILiteS_s_axi_U : component hls_gamma_correction_AXILiteS_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_AXILITES_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_AXILITES_DATA_WIDTH)
    port map (
        AWVALID => s_axi_AXILiteS_AWVALID,
        AWREADY => s_axi_AXILiteS_AWREADY,
        AWADDR => s_axi_AXILiteS_AWADDR,
        WVALID => s_axi_AXILiteS_WVALID,
        WREADY => s_axi_AXILiteS_WREADY,
        WDATA => s_axi_AXILiteS_WDATA,
        WSTRB => s_axi_AXILiteS_WSTRB,
        ARVALID => s_axi_AXILiteS_ARVALID,
        ARREADY => s_axi_AXILiteS_ARREADY,
        ARADDR => s_axi_AXILiteS_ARADDR,
        RVALID => s_axi_AXILiteS_RVALID,
        RREADY => s_axi_AXILiteS_RREADY,
        RDATA => s_axi_AXILiteS_RDATA,
        RRESP => s_axi_AXILiteS_RRESP,
        BVALID => s_axi_AXILiteS_BVALID,
        BREADY => s_axi_AXILiteS_BREADY,
        BRESP => s_axi_AXILiteS_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        gamma => gamma,
        height => height,
        width => width);

    Block_Mat_exit570_pr_U0 : component Block_Mat_exit570_pr
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Block_Mat_exit570_pr_U0_ap_start,
        start_full_n => Block_Mat_exit570_pr_U0_start_full_n,
        ap_done => Block_Mat_exit570_pr_U0_ap_done,
        ap_continue => Block_Mat_exit570_pr_U0_ap_continue,
        ap_idle => Block_Mat_exit570_pr_U0_ap_idle,
        ap_ready => Block_Mat_exit570_pr_U0_ap_ready,
        start_out => Block_Mat_exit570_pr_U0_start_out,
        start_write => Block_Mat_exit570_pr_U0_start_write,
        height => height,
        width => width,
        gamma => gamma,
        img3_rows_V_out_din => Block_Mat_exit570_pr_U0_img3_rows_V_out_din,
        img3_rows_V_out_full_n => img3_rows_V_c_full_n,
        img3_rows_V_out_write => Block_Mat_exit570_pr_U0_img3_rows_V_out_write,
        img3_cols_V_out_din => Block_Mat_exit570_pr_U0_img3_cols_V_out_din,
        img3_cols_V_out_full_n => img3_cols_V_c_full_n,
        img3_cols_V_out_write => Block_Mat_exit570_pr_U0_img3_cols_V_out_write,
        p_cols_assign_cast_out_out_din => Block_Mat_exit570_pr_U0_p_cols_assign_cast_out_out_din,
        p_cols_assign_cast_out_out_full_n => p_cols_assign_cast_lo_full_n,
        p_cols_assign_cast_out_out_write => Block_Mat_exit570_pr_U0_p_cols_assign_cast_out_out_write,
        p_rows_assign_cast_out_out_din => Block_Mat_exit570_pr_U0_p_rows_assign_cast_out_out_din,
        p_rows_assign_cast_out_out_full_n => p_rows_assign_cast_lo_full_n,
        p_rows_assign_cast_out_out_write => Block_Mat_exit570_pr_U0_p_rows_assign_cast_out_out_write,
        gamma_out_din => Block_Mat_exit570_pr_U0_gamma_out_din,
        gamma_out_full_n => gamma_c_full_n,
        gamma_out_write => Block_Mat_exit570_pr_U0_gamma_out_write,
        ap_return_0 => Block_Mat_exit570_pr_U0_ap_return_0,
        ap_return_1 => Block_Mat_exit570_pr_U0_ap_return_1);

    AXIvideo2Mat_U0 : component AXIvideo2Mat
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => AXIvideo2Mat_U0_ap_start,
        ap_done => AXIvideo2Mat_U0_ap_done,
        ap_continue => AXIvideo2Mat_U0_ap_continue,
        ap_idle => AXIvideo2Mat_U0_ap_idle,
        ap_ready => AXIvideo2Mat_U0_ap_ready,
        stream_in_TDATA => stream_in_TDATA,
        stream_in_TVALID => stream_in_TVALID,
        stream_in_TREADY => AXIvideo2Mat_U0_stream_in_TREADY,
        stream_in_TKEEP => stream_in_TKEEP,
        stream_in_TSTRB => stream_in_TSTRB,
        stream_in_TUSER => stream_in_TUSER,
        stream_in_TLAST => stream_in_TLAST,
        stream_in_TID => stream_in_TID,
        stream_in_TDEST => stream_in_TDEST,
        img_rows_V_read => img0_rows_V_channel_dout,
        img_cols_V_read => img0_cols_V_channel_dout,
        img_data_stream_0_V_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        img_data_stream_0_V_full_n => img0_data_stream_0_s_full_n,
        img_data_stream_0_V_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        img_data_stream_1_V_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        img_data_stream_1_V_full_n => img0_data_stream_1_s_full_n,
        img_data_stream_1_V_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        img_data_stream_2_V_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        img_data_stream_2_V_full_n => img0_data_stream_2_s_full_n,
        img_data_stream_2_V_write => AXIvideo2Mat_U0_img_data_stream_2_V_write);

    Loop_loop_height_pro_U0 : component Loop_loop_height_pro
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Loop_loop_height_pro_U0_ap_start,
        ap_done => Loop_loop_height_pro_U0_ap_done,
        ap_continue => Loop_loop_height_pro_U0_ap_continue,
        ap_idle => Loop_loop_height_pro_U0_ap_idle,
        ap_ready => Loop_loop_height_pro_U0_ap_ready,
        p_rows_assign_cast_loc_dout => p_rows_assign_cast_lo_dout,
        p_rows_assign_cast_loc_empty_n => p_rows_assign_cast_lo_empty_n,
        p_rows_assign_cast_loc_read => Loop_loop_height_pro_U0_p_rows_assign_cast_loc_read,
        p_cols_assign_cast_loc_dout => p_cols_assign_cast_lo_dout,
        p_cols_assign_cast_loc_empty_n => p_cols_assign_cast_lo_empty_n,
        p_cols_assign_cast_loc_read => Loop_loop_height_pro_U0_p_cols_assign_cast_loc_read,
        img3_data_stream_0_V_din => Loop_loop_height_pro_U0_img3_data_stream_0_V_din,
        img3_data_stream_0_V_full_n => img3_data_stream_0_s_full_n,
        img3_data_stream_0_V_write => Loop_loop_height_pro_U0_img3_data_stream_0_V_write,
        img3_data_stream_1_V_din => Loop_loop_height_pro_U0_img3_data_stream_1_V_din,
        img3_data_stream_1_V_full_n => img3_data_stream_1_s_full_n,
        img3_data_stream_1_V_write => Loop_loop_height_pro_U0_img3_data_stream_1_V_write,
        img3_data_stream_2_V_din => Loop_loop_height_pro_U0_img3_data_stream_2_V_din,
        img3_data_stream_2_V_full_n => img3_data_stream_2_s_full_n,
        img3_data_stream_2_V_write => Loop_loop_height_pro_U0_img3_data_stream_2_V_write,
        gamma_dout => gamma_c_dout,
        gamma_empty_n => gamma_c_empty_n,
        gamma_read => Loop_loop_height_pro_U0_gamma_read,
        img0_data_stream_0_V_dout => img0_data_stream_0_s_dout,
        img0_data_stream_0_V_empty_n => img0_data_stream_0_s_empty_n,
        img0_data_stream_0_V_read => Loop_loop_height_pro_U0_img0_data_stream_0_V_read,
        img0_data_stream_1_V_dout => img0_data_stream_1_s_dout,
        img0_data_stream_1_V_empty_n => img0_data_stream_1_s_empty_n,
        img0_data_stream_1_V_read => Loop_loop_height_pro_U0_img0_data_stream_1_V_read,
        img0_data_stream_2_V_dout => img0_data_stream_2_s_dout,
        img0_data_stream_2_V_empty_n => img0_data_stream_2_s_empty_n,
        img0_data_stream_2_V_read => Loop_loop_height_pro_U0_img0_data_stream_2_V_read);

    Mat2AXIvideo_U0 : component Mat2AXIvideo
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Mat2AXIvideo_U0_ap_start,
        ap_done => Mat2AXIvideo_U0_ap_done,
        ap_continue => Mat2AXIvideo_U0_ap_continue,
        ap_idle => Mat2AXIvideo_U0_ap_idle,
        ap_ready => Mat2AXIvideo_U0_ap_ready,
        img_rows_V_dout => img3_rows_V_c_dout,
        img_rows_V_empty_n => img3_rows_V_c_empty_n,
        img_rows_V_read => Mat2AXIvideo_U0_img_rows_V_read,
        img_cols_V_dout => img3_cols_V_c_dout,
        img_cols_V_empty_n => img3_cols_V_c_empty_n,
        img_cols_V_read => Mat2AXIvideo_U0_img_cols_V_read,
        img_data_stream_0_V_dout => img3_data_stream_0_s_dout,
        img_data_stream_0_V_empty_n => img3_data_stream_0_s_empty_n,
        img_data_stream_0_V_read => Mat2AXIvideo_U0_img_data_stream_0_V_read,
        img_data_stream_1_V_dout => img3_data_stream_1_s_dout,
        img_data_stream_1_V_empty_n => img3_data_stream_1_s_empty_n,
        img_data_stream_1_V_read => Mat2AXIvideo_U0_img_data_stream_1_V_read,
        img_data_stream_2_V_dout => img3_data_stream_2_s_dout,
        img_data_stream_2_V_empty_n => img3_data_stream_2_s_empty_n,
        img_data_stream_2_V_read => Mat2AXIvideo_U0_img_data_stream_2_V_read,
        stream_out_TDATA => Mat2AXIvideo_U0_stream_out_TDATA,
        stream_out_TVALID => Mat2AXIvideo_U0_stream_out_TVALID,
        stream_out_TREADY => stream_out_TREADY,
        stream_out_TKEEP => Mat2AXIvideo_U0_stream_out_TKEEP,
        stream_out_TSTRB => Mat2AXIvideo_U0_stream_out_TSTRB,
        stream_out_TUSER => Mat2AXIvideo_U0_stream_out_TUSER,
        stream_out_TLAST => Mat2AXIvideo_U0_stream_out_TLAST,
        stream_out_TID => Mat2AXIvideo_U0_stream_out_TID,
        stream_out_TDEST => Mat2AXIvideo_U0_stream_out_TDEST);

    img3_rows_V_c_U : component fifo_w16_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_img3_rows_V_out_din,
        if_full_n => img3_rows_V_c_full_n,
        if_write => Block_Mat_exit570_pr_U0_img3_rows_V_out_write,
        if_dout => img3_rows_V_c_dout,
        if_empty_n => img3_rows_V_c_empty_n,
        if_read => Mat2AXIvideo_U0_img_rows_V_read);

    img3_cols_V_c_U : component fifo_w16_d3_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_img3_cols_V_out_din,
        if_full_n => img3_cols_V_c_full_n,
        if_write => Block_Mat_exit570_pr_U0_img3_cols_V_out_write,
        if_dout => img3_cols_V_c_dout,
        if_empty_n => img3_cols_V_c_empty_n,
        if_read => Mat2AXIvideo_U0_img_cols_V_read);

    p_cols_assign_cast_lo_U : component fifo_w12_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_p_cols_assign_cast_out_out_din,
        if_full_n => p_cols_assign_cast_lo_full_n,
        if_write => Block_Mat_exit570_pr_U0_p_cols_assign_cast_out_out_write,
        if_dout => p_cols_assign_cast_lo_dout,
        if_empty_n => p_cols_assign_cast_lo_empty_n,
        if_read => Loop_loop_height_pro_U0_p_cols_assign_cast_loc_read);

    p_rows_assign_cast_lo_U : component fifo_w12_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_p_rows_assign_cast_out_out_din,
        if_full_n => p_rows_assign_cast_lo_full_n,
        if_write => Block_Mat_exit570_pr_U0_p_rows_assign_cast_out_out_write,
        if_dout => p_rows_assign_cast_lo_dout,
        if_empty_n => p_rows_assign_cast_lo_empty_n,
        if_read => Loop_loop_height_pro_U0_p_rows_assign_cast_loc_read);

    gamma_c_U : component fifo_w8_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_gamma_out_din,
        if_full_n => gamma_c_full_n,
        if_write => Block_Mat_exit570_pr_U0_gamma_out_write,
        if_dout => gamma_c_dout,
        if_empty_n => gamma_c_empty_n,
        if_read => Loop_loop_height_pro_U0_gamma_read);

    img0_rows_V_channel_U : component fifo_w16_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_ap_return_0,
        if_full_n => img0_rows_V_channel_full_n,
        if_write => ap_channel_done_img0_rows_V_channel,
        if_dout => img0_rows_V_channel_dout,
        if_empty_n => img0_rows_V_channel_empty_n,
        if_read => AXIvideo2Mat_U0_ap_ready);

    img0_cols_V_channel_U : component fifo_w16_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_Mat_exit570_pr_U0_ap_return_1,
        if_full_n => img0_cols_V_channel_full_n,
        if_write => ap_channel_done_img0_cols_V_channel,
        if_dout => img0_cols_V_channel_dout,
        if_empty_n => img0_cols_V_channel_empty_n,
        if_read => AXIvideo2Mat_U0_ap_ready);

    img0_data_stream_0_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        if_full_n => img0_data_stream_0_s_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        if_dout => img0_data_stream_0_s_dout,
        if_empty_n => img0_data_stream_0_s_empty_n,
        if_read => Loop_loop_height_pro_U0_img0_data_stream_0_V_read);

    img0_data_stream_1_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        if_full_n => img0_data_stream_1_s_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        if_dout => img0_data_stream_1_s_dout,
        if_empty_n => img0_data_stream_1_s_empty_n,
        if_read => Loop_loop_height_pro_U0_img0_data_stream_1_V_read);

    img0_data_stream_2_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        if_full_n => img0_data_stream_2_s_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        if_dout => img0_data_stream_2_s_dout,
        if_empty_n => img0_data_stream_2_s_empty_n,
        if_read => Loop_loop_height_pro_U0_img0_data_stream_2_V_read);

    img3_data_stream_0_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Loop_loop_height_pro_U0_img3_data_stream_0_V_din,
        if_full_n => img3_data_stream_0_s_full_n,
        if_write => Loop_loop_height_pro_U0_img3_data_stream_0_V_write,
        if_dout => img3_data_stream_0_s_dout,
        if_empty_n => img3_data_stream_0_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_0_V_read);

    img3_data_stream_1_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Loop_loop_height_pro_U0_img3_data_stream_1_V_din,
        if_full_n => img3_data_stream_1_s_full_n,
        if_write => Loop_loop_height_pro_U0_img3_data_stream_1_V_write,
        if_dout => img3_data_stream_1_s_dout,
        if_empty_n => img3_data_stream_1_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_1_V_read);

    img3_data_stream_2_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Loop_loop_height_pro_U0_img3_data_stream_2_V_din,
        if_full_n => img3_data_stream_2_s_full_n,
        if_write => Loop_loop_height_pro_U0_img3_data_stream_2_V_write,
        if_dout => img3_data_stream_2_s_dout,
        if_empty_n => img3_data_stream_2_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_2_V_read);

    start_for_Loop_lojbC_U : component start_for_Loop_lojbC
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Loop_loop_height_pro_U0_din,
        if_full_n => start_for_Loop_loop_height_pro_U0_full_n,
        if_write => Block_Mat_exit570_pr_U0_start_write,
        if_dout => start_for_Loop_loop_height_pro_U0_dout,
        if_empty_n => start_for_Loop_loop_height_pro_U0_empty_n,
        if_read => Loop_loop_height_pro_U0_ap_ready);

    start_for_Mat2AXIkbM_U : component start_for_Mat2AXIkbM
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Mat2AXIvideo_U0_din,
        if_full_n => start_for_Mat2AXIvideo_U0_full_n,
        if_write => Block_Mat_exit570_pr_U0_start_write,
        if_dout => start_for_Mat2AXIvideo_U0_dout,
        if_empty_n => start_for_Mat2AXIvideo_U0_empty_n,
        if_read => Mat2AXIvideo_U0_ap_ready);





    ap_sync_reg_channel_write_img0_cols_V_channel_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_sync_reg_channel_write_img0_cols_V_channel <= ap_const_logic_0;
            else
                if (((Block_Mat_exit570_pr_U0_ap_done and Block_Mat_exit570_pr_U0_ap_continue) = ap_const_logic_1)) then 
                    ap_sync_reg_channel_write_img0_cols_V_channel <= ap_const_logic_0;
                else 
                    ap_sync_reg_channel_write_img0_cols_V_channel <= ap_sync_channel_write_img0_cols_V_channel;
                end if; 
            end if;
        end if;
    end process;


    ap_sync_reg_channel_write_img0_rows_V_channel_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_sync_reg_channel_write_img0_rows_V_channel <= ap_const_logic_0;
            else
                if (((Block_Mat_exit570_pr_U0_ap_done and Block_Mat_exit570_pr_U0_ap_continue) = ap_const_logic_1)) then 
                    ap_sync_reg_channel_write_img0_rows_V_channel <= ap_const_logic_0;
                else 
                    ap_sync_reg_channel_write_img0_rows_V_channel <= ap_sync_channel_write_img0_rows_V_channel;
                end if; 
            end if;
        end if;
    end process;

    AXIvideo2Mat_U0_ap_continue <= ap_const_logic_1;
    AXIvideo2Mat_U0_ap_start <= (img0_rows_V_channel_empty_n and img0_cols_V_channel_empty_n);
    AXIvideo2Mat_U0_start_full_n <= ap_const_logic_1;
    AXIvideo2Mat_U0_start_write <= ap_const_logic_0;
    Block_Mat_exit570_pr_U0_ap_continue <= (ap_sync_channel_write_img0_rows_V_channel and ap_sync_channel_write_img0_cols_V_channel);
    Block_Mat_exit570_pr_U0_ap_start <= ap_const_logic_1;
    Block_Mat_exit570_pr_U0_start_full_n <= (start_for_Mat2AXIvideo_U0_full_n and start_for_Loop_loop_height_pro_U0_full_n);
    Loop_loop_height_pro_U0_ap_continue <= ap_const_logic_1;
    Loop_loop_height_pro_U0_ap_start <= start_for_Loop_loop_height_pro_U0_empty_n;
    Loop_loop_height_pro_U0_start_full_n <= ap_const_logic_1;
    Loop_loop_height_pro_U0_start_write <= ap_const_logic_0;
    Mat2AXIvideo_U0_ap_continue <= ap_const_logic_1;
    Mat2AXIvideo_U0_ap_start <= start_for_Mat2AXIvideo_U0_empty_n;
    Mat2AXIvideo_U0_start_full_n <= ap_const_logic_1;
    Mat2AXIvideo_U0_start_write <= ap_const_logic_0;
    ap_channel_done_img0_cols_V_channel <= ((ap_sync_reg_channel_write_img0_cols_V_channel xor ap_const_logic_1) and Block_Mat_exit570_pr_U0_ap_done);
    ap_channel_done_img0_rows_V_channel <= ((ap_sync_reg_channel_write_img0_rows_V_channel xor ap_const_logic_1) and Block_Mat_exit570_pr_U0_ap_done);

    ap_rst_n_inv_assign_proc : process(ap_rst_n)
    begin
                ap_rst_n_inv <= not(ap_rst_n);
    end process;

    ap_sync_channel_write_img0_cols_V_channel <= ((img0_cols_V_channel_full_n and ap_channel_done_img0_cols_V_channel) or ap_sync_reg_channel_write_img0_cols_V_channel);
    ap_sync_channel_write_img0_rows_V_channel <= ((img0_rows_V_channel_full_n and ap_channel_done_img0_rows_V_channel) or ap_sync_reg_channel_write_img0_rows_V_channel);
    ap_sync_continue <= ap_const_logic_0;
    start_for_Loop_loop_height_pro_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_Mat2AXIvideo_U0_din <= (0=>ap_const_logic_1, others=>'-');
    stream_in_TREADY <= AXIvideo2Mat_U0_stream_in_TREADY;
    stream_out_TDATA <= Mat2AXIvideo_U0_stream_out_TDATA;
    stream_out_TDEST <= Mat2AXIvideo_U0_stream_out_TDEST;
    stream_out_TID <= Mat2AXIvideo_U0_stream_out_TID;
    stream_out_TKEEP <= Mat2AXIvideo_U0_stream_out_TKEEP;
    stream_out_TLAST <= Mat2AXIvideo_U0_stream_out_TLAST;
    stream_out_TSTRB <= Mat2AXIvideo_U0_stream_out_TSTRB;
    stream_out_TUSER <= Mat2AXIvideo_U0_stream_out_TUSER;
    stream_out_TVALID <= Mat2AXIvideo_U0_stream_out_TVALID;
end behav;
