-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_hbi_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_hbi_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem : mem_array := (
    0 => "00000000", 1 => "00000001", 2 => "00000010", 3 => "00000100", 
    4 => "00000101", 5 => "00000110", 6 => "00000111", 7 => "00001000", 
    8 => "00001010", 9 => "00001011", 10 => "00001100", 11 => "00001101", 
    12 => "00001110", 13 => "00001111", 14 => "00010001", 15 => "00010010", 
    16 => "00010011", 17 => "00010100", 18 => "00010101", 19 => "00010111", 
    20 => "00011000", 21 => "00011001", 22 => "00011010", 23 => "00011011", 
    24 => "00011100", 25 => "00011110", 26 => "00011111", 27 => "00100000", 
    28 => "00100001", 29 => "00100010", 30 => "00100011", 31 => "00100100", 
    32 => "00100110", 33 => "00100111", 34 => "00101000", 35 => "00101001", 
    36 => "00101010", 37 => "00101011", 38 => "00101100", 39 => "00101110", 
    40 => "00101111", 41 => "00110000", 42 => "00110001", 43 => "00110010", 
    44 => "00110011", 45 => "00110100", 46 => "00110110", 47 => "00110111", 
    48 => "00111000", 49 => "00111001", 50 => "00111010", 51 => "00111011", 
    52 => "00111100", 53 => "00111101", 54 => "00111111", 55 => "01000000", 
    56 => "01000001", 57 => "01000010", 58 => "01000011", 59 => "01000100", 
    60 => "01000101", 61 => "01000110", 62 => "01000111", 63 => "01001000", 
    64 => "01001010", 65 => "01001011", 66 => "01001100", 67 => "01001101", 
    68 => "01001110", 69 => "01001111", 70 => "01010000", 71 => "01010001", 
    72 => "01010010", 73 => "01010011", 74 => "01010101", 75 => "01010110", 
    76 => "01010111", 77 => "01011000", 78 => "01011001", 79 => "01011010", 
    80 => "01011011", 81 => "01011100", 82 => "01011101", 83 => "01011110", 
    84 => "01011111", 85 => "01100000", 86 => "01100001", 87 => "01100010", 
    88 => "01100100", 89 => "01100101", 90 => "01100110", 91 => "01100111", 
    92 => "01101000", 93 => "01101001", 94 => "01101010", 95 => "01101011", 
    96 => "01101100", 97 => "01101101", 98 => "01101110", 99 => "01101111", 
    100 => "01110000", 101 => "01110001", 102 => "01110010", 103 => "01110011", 
    104 => "01110100", 105 => "01110101", 106 => "01110110", 107 => "01110111", 
    108 => "01111000", 109 => "01111001", 110 => "01111011", 111 => "01111100", 
    112 => "01111101", 113 => "01111110", 114 => "01111111", 115 => "10000000", 
    116 => "10000001", 117 => "10000010", 118 => "10000011", 119 => "10000100", 
    120 => "10000101", 121 => "10000110", 122 => "10000111", 123 => "10001000", 
    124 => "10001001", 125 => "10001010", 126 => "10001011", 127 => "10001100", 
    128 => "10001101", 129 => "10001110", 130 => "10001111", 131 => "10010000", 
    132 => "10010001", 133 => "10010010", 134 => "10010011", 135 => "10010100", 
    136 => "10010101", 137 => "10010110", 138 => "10010111", 139 => "10011000", 
    140 => "10011001", 141 => "10011010", 142 => "10011011", 143 => "10011100", 
    144 => "10011101", 145 to 146=> "10011110", 147 => "10011111", 148 => "10100000", 
    149 => "10100001", 150 => "10100010", 151 => "10100011", 152 => "10100100", 
    153 => "10100101", 154 => "10100110", 155 => "10100111", 156 => "10101000", 
    157 => "10101001", 158 => "10101010", 159 => "10101011", 160 => "10101100", 
    161 => "10101101", 162 => "10101110", 163 => "10101111", 164 => "10110000", 
    165 => "10110001", 166 => "10110010", 167 to 168=> "10110011", 169 => "10110100", 
    170 => "10110101", 171 => "10110110", 172 => "10110111", 173 => "10111000", 
    174 => "10111001", 175 => "10111010", 176 => "10111011", 177 => "10111100", 
    178 => "10111101", 179 => "10111110", 180 => "10111111", 181 to 182=> "11000000", 
    183 => "11000001", 184 => "11000010", 185 => "11000011", 186 => "11000100", 
    187 => "11000101", 188 => "11000110", 189 => "11000111", 190 => "11001000", 
    191 to 192=> "11001001", 193 => "11001010", 194 => "11001011", 195 => "11001100", 
    196 => "11001101", 197 => "11001110", 198 => "11001111", 199 => "11010000", 
    200 => "11010001", 201 to 202=> "11010010", 203 => "11010011", 204 => "11010100", 
    205 => "11010101", 206 => "11010110", 207 => "11010111", 208 => "11011000", 
    209 to 210=> "11011001", 211 => "11011010", 212 => "11011011", 213 => "11011100", 
    214 => "11011101", 215 => "11011110", 216 to 217=> "11011111", 218 => "11100000", 
    219 => "11100001", 220 => "11100010", 221 => "11100011", 222 => "11100100", 
    223 to 224=> "11100101", 225 => "11100110", 226 => "11100111", 227 => "11101000", 
    228 => "11101001", 229 => "11101010", 230 to 231=> "11101011", 232 => "11101100", 
    233 => "11101101", 234 => "11101110", 235 => "11101111", 236 to 237=> "11110000", 
    238 => "11110001", 239 => "11110010", 240 => "11110011", 241 to 242=> "11110100", 
    243 => "11110101", 244 => "11110110", 245 => "11110111", 246 => "11111000", 
    247 to 248=> "11111001", 249 => "11111010", 250 => "11111011", 251 => "11111100", 
    252 to 253=> "11111101", 254 => "11111110", 255 => "11111111" );


begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem(CONV_INTEGER(addr0_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_hbi is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_hbi is
    component Loop_loop_height_hbi_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_hbi_rom_U :  component Loop_loop_height_hbi_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0);

end architecture;


