-- ==============================================================
-- File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ==============================================================

library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity Loop_loop_height_ibs_rom is 
    generic(
             dwidth     : integer := 8; 
             awidth     : integer := 8; 
             mem_size    : integer := 256
    ); 
    port (
          addr0      : in std_logic_vector(awidth-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(dwidth-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of Loop_loop_height_ibs_rom is 

signal addr0_tmp : std_logic_vector(awidth-1 downto 0); 
type mem_array is array (0 to mem_size-1) of std_logic_vector (dwidth-1 downto 0); 
signal mem : mem_array := (
    0 => "00000000", 1 => "00000001", 2 => "00000011", 3 => "00000100", 
    4 => "00000110", 5 => "00000111", 6 => "00001000", 7 => "00001010", 
    8 => "00001011", 9 => "00001100", 10 => "00001110", 11 => "00001111", 
    12 => "00010001", 13 => "00010010", 14 => "00010011", 15 => "00010101", 
    16 => "00010110", 17 => "00010111", 18 => "00011001", 19 => "00011010", 
    20 => "00011011", 21 => "00011101", 22 => "00011110", 23 => "00011111", 
    24 => "00100001", 25 => "00100010", 26 => "00100011", 27 => "00100101", 
    28 => "00100110", 29 => "00100111", 30 => "00101001", 31 => "00101010", 
    32 => "00101011", 33 => "00101100", 34 => "00101110", 35 => "00101111", 
    36 => "00110000", 37 => "00110010", 38 => "00110011", 39 => "00110100", 
    40 => "00110101", 41 => "00110111", 42 => "00111000", 43 => "00111001", 
    44 => "00111011", 45 => "00111100", 46 => "00111101", 47 => "00111110", 
    48 => "01000000", 49 => "01000001", 50 => "01000010", 51 => "01000011", 
    52 => "01000101", 53 => "01000110", 54 => "01000111", 55 => "01001000", 
    56 => "01001001", 57 => "01001011", 58 => "01001100", 59 => "01001101", 
    60 => "01001110", 61 => "01010000", 62 => "01010001", 63 => "01010010", 
    64 => "01010011", 65 => "01010100", 66 => "01010110", 67 => "01010111", 
    68 => "01011000", 69 => "01011001", 70 => "01011010", 71 => "01011011", 
    72 => "01011101", 73 => "01011110", 74 => "01011111", 75 => "01100000", 
    76 => "01100001", 77 => "01100010", 78 => "01100100", 79 => "01100101", 
    80 => "01100110", 81 => "01100111", 82 => "01101000", 83 => "01101001", 
    84 => "01101011", 85 => "01101100", 86 => "01101101", 87 => "01101110", 
    88 => "01101111", 89 => "01110000", 90 => "01110001", 91 => "01110010", 
    92 => "01110100", 93 => "01110101", 94 => "01110110", 95 => "01110111", 
    96 => "01111000", 97 => "01111001", 98 => "01111010", 99 => "01111011", 
    100 => "01111100", 101 => "01111101", 102 => "01111110", 103 => "10000000", 
    104 => "10000001", 105 => "10000010", 106 => "10000011", 107 => "10000100", 
    108 => "10000101", 109 => "10000110", 110 => "10000111", 111 => "10001000", 
    112 => "10001001", 113 => "10001010", 114 => "10001011", 115 => "10001100", 
    116 => "10001101", 117 => "10001110", 118 => "10001111", 119 => "10010000", 
    120 => "10010001", 121 => "10010010", 122 => "10010011", 123 => "10010100", 
    124 => "10010101", 125 => "10010110", 126 => "10010111", 127 => "10011000", 
    128 => "10011001", 129 => "10011010", 130 => "10011011", 131 => "10011100", 
    132 => "10011101", 133 => "10011110", 134 => "10011111", 135 => "10100000", 
    136 => "10100001", 137 => "10100010", 138 => "10100011", 139 => "10100100", 
    140 => "10100101", 141 => "10100110", 142 => "10100111", 143 => "10101000", 
    144 => "10101001", 145 => "10101010", 146 => "10101011", 147 => "10101100", 
    148 => "10101101", 149 => "10101110", 150 => "10101111", 151 => "10110000", 
    152 to 153=> "10110001", 154 => "10110010", 155 => "10110011", 156 => "10110100", 
    157 => "10110101", 158 => "10110110", 159 => "10110111", 160 => "10111000", 
    161 => "10111001", 162 => "10111010", 163 to 164=> "10111011", 165 => "10111100", 
    166 => "10111101", 167 => "10111110", 168 => "10111111", 169 => "11000000", 
    170 => "11000001", 171 to 172=> "11000010", 173 => "11000011", 174 => "11000100", 
    175 => "11000101", 176 => "11000110", 177 to 178=> "11000111", 179 => "11001000", 
    180 => "11001001", 181 => "11001010", 182 => "11001011", 183 to 184=> "11001100", 
    185 => "11001101", 186 => "11001110", 187 => "11001111", 188 => "11010000", 
    189 to 190=> "11010001", 191 => "11010010", 192 => "11010011", 193 => "11010100", 
    194 to 195=> "11010101", 196 => "11010110", 197 => "11010111", 198 to 199=> "11011000", 
    200 => "11011001", 201 => "11011010", 202 => "11011011", 203 to 204=> "11011100", 
    205 => "11011101", 206 => "11011110", 207 to 208=> "11011111", 209 => "11100000", 
    210 => "11100001", 211 to 212=> "11100010", 213 => "11100011", 214 to 215=> "11100100", 
    216 => "11100101", 217 => "11100110", 218 to 219=> "11100111", 220 => "11101000", 
    221 to 222=> "11101001", 223 => "11101010", 224 => "11101011", 225 to 226=> "11101100", 
    227 => "11101101", 228 to 229=> "11101110", 230 => "11101111", 231 to 232=> "11110000", 
    233 => "11110001", 234 to 235=> "11110010", 236 => "11110011", 237 to 238=> "11110100", 
    239 => "11110101", 240 to 241=> "11110110", 242 => "11110111", 243 to 244=> "11111000", 
    245 to 246=> "11111001", 247 => "11111010", 248 to 249=> "11111011", 250 => "11111100", 
    251 to 252=> "11111101", 253 to 254=> "11111110", 255 => "11111111" );


begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem(CONV_INTEGER(addr0_tmp)); 
        end if;
    end if;
end process;

end rtl;


Library IEEE;
use IEEE.std_logic_1164.all;

entity Loop_loop_height_ibs is
    generic (
        DataWidth : INTEGER := 8;
        AddressRange : INTEGER := 256;
        AddressWidth : INTEGER := 8);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of Loop_loop_height_ibs is
    component Loop_loop_height_ibs_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    Loop_loop_height_ibs_rom_U :  component Loop_loop_height_ibs_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0);

end architecture;


