<!-- @page page_getting-started_index Introduction to the AMD FSR™ SDK -->

<h1>Introduction to the AMD FSR™ SDK</h1>

The FSR™ SDK is a collection of heavily optimized effects (headers and DLLs) that can be used by developers to improve their DirectX®12 applications. The FSR SDK includes:

- [FidelityFX Super Resolution 2.3.4](../../Kits/FidelityFX/docs/techniques/super-resolution-temporal.md)
- [FidelityFX Super Resolution 3.1.5](../../Kits/FidelityFX/docs/techniques/super-resolution-upscaler.md)
- [FSR™ Upscaling 4.0.3](../../Kits/FidelityFX/docs/techniques/super-resolution-ml.md)
- [FidelityFX Frame Generation 3.1.5](../../Kits/FidelityFX/docs/techniques/frame-interpolation.md)
- [FidelityFX Frame Generation Swapchain 3.1.5](../../Kits/FidelityFX/docs/techniques/frame-interpolation-swap-chain.md)
- [FSR™ Frame Generation 4.0.0](../../Kits/FidelityFX/docs/techniques/frame-interpolation-ml.md)
- [FSR™ Frame Generation Swapchain 4.0.0](../../Kits/FidelityFX/docs/techniques/frame-interpolation-swap-chain-ml.md)
- [FSR™ Ray Regeneration 1.0.0](../../Kits/FidelityFX/docs/techniques/denoising.md)
- [FSR™ Radiance Caching (Technical Preview)](../../Kits/FidelityFX/docs/techniques/radiance-cache.md)

<h2>Supported ecosystems</h2>

This version of the AMD FSR™ SDK comes with samples that run on the following APIs:

- DirectX(R)12

The shader code used by our sample framework is written in HLSL, and can easily be ported to other platforms which support modern shader models.

If you are a registered Xbox developer, you can find AMD FSR™ features available as part of the Microsoft Game Development Kit (GDK).

<h2>Samples</h2>

Most samples are written in C++, and use the [Cauldron Framework](../../Kits/Cauldron2/dx12/) sample framework.

<h2>Open source</h2>

AMD FSR™ SDK Samples are open source, and distributed under the MIT license.

For more information on the license terms please refer to the [license](../license.md).

<h2>Support</h2>

We endeavour to keep the AMD FSR™ SDK updated with new features and bug fixes as often as we can, and perform compatibility and performance testing on a wide range of hardware.

If you find an issue, or have a request for the FSR™ SDK, please consider opening an issue.

<!-- - @subpage page_getting-started_sdk-structure "SDK Structure" -->
<!-- - @subpage page_building-samples_index "Building the samples for the SDK" -->
<!-- - @subpage page_running-samples_index "Running the samples for the SDK" -->
<!-- - @subpage page_getting-started_naming-guidelines "FSR naming guidelines for game applications" -->
<!-- - @subpage page_ffx-api "Introduction to FSR API" -->
