/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import java.util.ArrayList;
import java.util.List;

class ProjectInsertListeners {
    private final List<InsertListener> insertListeners = new ArrayList<InsertListener>();

    ProjectInsertListeners() {
    }

    void addInsertListener(InsertListener insertListener) {
        this.insertListeners.add(insertListener);
    }

    void removeInsertListener(InsertListener insertListener) {
        this.insertListeners.remove(insertListener);
    }

    void fireProjectInsertStarted(Project project) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertStarted(project);
        }
    }

    void fireProjectURIGenerated(Project project, String uri) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectURIGenerated(project, uri);
        }
    }

    void fireProjectUploadFinished(Project project) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectUploadFinished(project);
        }
    }

    void fireProjectInsertProgress(Project project, int succeeded, int failed, int fatal, int total, boolean finalized) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertProgress(project, succeeded, failed, fatal, total, finalized);
        }
    }

    void fireProjectInsertFinished(Project project, boolean success, Throwable cause) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertFinished(project, success, cause);
        }
    }
}

