/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.UpdateListener;
import de.todesbaum.jsite.main.Version;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.ClientGet;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.Persistence;
import de.todesbaum.util.freenet.fcp2.ReturnType;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;

public class UpdateChecker
implements Runnable {
    private static final Logger logger = Logger.getLogger(UpdateChecker.class.getName());
    private static int counter = 0;
    private static final int UPDATE_EDITION = 12;
    private static final String UPDATE_KEY = "USK@1waTsw46L9-JEQ8yX1khjkfHcn--g0MlMsTlYHax9zQ,oYyxr5jyFnaTsVGDQWk9e3ddOWGKnqEASxAk08MHT2Y,AQACAAE";
    private final Object syncObject = new Object();
    private final List<UpdateListener> updateListeners = new ArrayList<UpdateListener>();
    private boolean shouldStop = false;
    private int lastUpdateEdition = 12;
    private Version lastVersion;
    private final Freenet7Interface freenetInterface;

    public UpdateChecker(Freenet7Interface freenetInterface, Version currentVersion) {
        this.freenetInterface = freenetInterface;
        this.lastVersion = currentVersion;
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        this.updateListeners.remove(updateListener);
    }

    protected void fireUpdateFound(Version foundVersion, long versionTimestamp) {
        for (UpdateListener updateListener : this.updateListeners) {
            updateListener.foundUpdateData(foundVersion, versionTimestamp);
        }
    }

    public Version getLatestVersion() {
        return this.lastVersion;
    }

    public void start() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.syncObject;
        synchronized (object) {
            this.shouldStop = true;
            this.syncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldStop() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.shouldStop;
        }
    }

    private static String constructUpdateKey(int edition) {
        return "USK@1waTsw46L9-JEQ8yX1khjkfHcn--g0MlMsTlYHax9zQ,oYyxr5jyFnaTsVGDQWk9e3ddOWGKnqEASxAk08MHT2Y,AQACAAE/jSite/" + edition + "/jSite.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int currentEdition = this.lastUpdateEdition;
        while (!this.shouldStop()) {
            Client client;
            while (true) {
                Connection connection = this.freenetInterface.getConnection("jSite-" + ++counter + "-UpdateChecker");
                try {
                    connection.connect();
                    logger.log(Level.INFO, "Connected to " + this.freenetInterface.getNode() + ".");
                    client = new Client(connection);
                }
                catch (IOException ioe12) {
                    logger.log(Level.INFO, "Could not connect to " + this.freenetInterface.getNode() + ".", ioe12);
                    if (connection.isConnected()) continue;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ioe12) {}
                    continue;
                }
                break;
            }
            boolean checkNow = false;
            logger.log(Level.FINE, "Trying " + UpdateChecker.constructUpdateKey(currentEdition));
            ClientGet clientGet = new ClientGet("get-update-key");
            clientGet.setUri(UpdateChecker.constructUpdateKey(currentEdition));
            clientGet.setPersistence(Persistence.CONNECTION);
            clientGet.setReturnType(ReturnType.direct);
            clientGet.setVerbosity(Verbosity.ALL);
            try {
                client.execute(clientGet);
                boolean stop = false;
                while (!stop) {
                    Version foundVersion;
                    Message message = client.readMessage();
                    logger.log(Level.FINEST, "Received message: " + message);
                    if (message == null) break;
                    if ("GetFailed".equals(message.getName()) && "27".equals(message.get("code"))) {
                        String editionString = message.get("redirecturi").split("/")[2];
                        int editionNumber = -1;
                        try {
                            editionNumber = Integer.parseInt(editionString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (editionNumber != -1) {
                            logger.log(Level.INFO, "Found new edition " + editionNumber);
                            currentEdition = editionNumber;
                            this.lastUpdateEdition = editionNumber;
                            checkNow = true;
                            break;
                        }
                    }
                    if (!"AllData".equals(message.getName())) continue;
                    logger.log(Level.FINE, "Update data found.");
                    InputStream dataInputStream = null;
                    Properties properties = new Properties();
                    try {
                        dataInputStream = message.getPayloadInputStream();
                        properties.load(dataInputStream);
                    }
                    finally {
                        Closer.close(dataInputStream);
                    }
                    String foundVersionString = properties.getProperty("jSite.Version");
                    if (foundVersionString == null || (foundVersion = Version.parse(foundVersionString)) == null) continue;
                    this.lastVersion = foundVersion;
                    String versionTimestampString = properties.getProperty("jSite.Date");
                    logger.log(Level.FINEST, "Version timestamp: " + versionTimestampString);
                    long versionTimestamp = -1L;
                    try {
                        versionTimestamp = Long.parseLong(versionTimestampString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.fireUpdateFound(foundVersion, versionTimestamp);
                    stop = true;
                    checkNow = true;
                    ++currentEdition;
                }
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Got IOException: " + e.getMessage());
                e.printStackTrace();
            }
            if (checkNow || this.shouldStop()) continue;
            Object object = this.syncObject;
            synchronized (object) {
                try {
                    this.syncObject.wait(900000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

