/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.main.JarFileLocator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ConfigurationLocator {
    private final Map<ConfigurationLocation, String> configurationFiles = new HashMap<ConfigurationLocation, String>();

    public ConfigurationLocator(JarFileLocator jarFileLocator) {
        Optional<File> jarFile = jarFileLocator.locateJarFile();
        if (jarFile.isPresent()) {
            File configurationFile = new File(jarFile.get().getParent(), "jSite.conf");
            this.configurationFiles.put(ConfigurationLocation.NEXT_TO_JAR_FILE, configurationFile.getPath());
        }
        File homeDirectoryFile = new File(System.getProperty("user.home"), ".jSite/config7");
        this.configurationFiles.put(ConfigurationLocation.HOME_DIRECTORY, homeDirectoryFile.getPath());
    }

    public void setCustomLocation(String customFile) {
        this.configurationFiles.put(ConfigurationLocation.CUSTOM, customFile);
    }

    public boolean isValidLocation(ConfigurationLocation configurationLocation) {
        return this.configurationFiles.containsKey((Object)configurationLocation);
    }

    public boolean hasFile(ConfigurationLocation configurationLocation) {
        if (!this.isValidLocation(configurationLocation)) {
            return false;
        }
        return new File(this.configurationFiles.get((Object)configurationLocation)).exists();
    }

    public String getFile(ConfigurationLocation configurationLocation) {
        return this.configurationFiles.get((Object)configurationLocation);
    }

    public ConfigurationLocation findPreferredLocation() {
        return this.findPreferredLocation(ConfigurationLocation.NEXT_TO_JAR_FILE);
    }

    public ConfigurationLocation findPreferredLocation(ConfigurationLocation defaultLocation) {
        if (this.hasFile(ConfigurationLocation.CUSTOM)) {
            return ConfigurationLocation.CUSTOM;
        }
        if (this.hasFile(ConfigurationLocation.NEXT_TO_JAR_FILE)) {
            return ConfigurationLocation.NEXT_TO_JAR_FILE;
        }
        if (this.hasFile(ConfigurationLocation.HOME_DIRECTORY)) {
            return ConfigurationLocation.HOME_DIRECTORY;
        }
        if (this.isValidLocation(defaultLocation)) {
            return defaultLocation;
        }
        return ConfigurationLocation.HOME_DIRECTORY;
    }

    public static enum ConfigurationLocation {
        NEXT_TO_JAR_FILE,
        HOME_DIRECTORY,
        CUSTOM;

    }
}

