/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.main.Main;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Optional;

public interface JarFileLocator {
    public Optional<File> locateJarFile();

    public static class DefaultJarFileLocator
    implements JarFileLocator {
        private final ClassLoader classLoader;

        public DefaultJarFileLocator(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Optional<File> locateJarFile() {
            URL resourceUrl = this.classLoader.getResource(Main.class.getName().replace(".", "/") + ".class");
            if (resourceUrl == null) {
                return Optional.empty();
            }
            String resource = resourceUrl.toString();
            if (resource.startsWith("jar:")) {
                try {
                    String jarFileLocation = URLDecoder.decode(resource.substring(9, resource.indexOf(".jar!") + 4), "UTF-8");
                    return Optional.of(new File(jarFileLocation));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        }
    }
}

