/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.DirectFileEntry;
import de.todesbaum.util.freenet.fcp2.DiskFileEntry;
import de.todesbaum.util.freenet.fcp2.FileEntry;
import de.todesbaum.util.freenet.fcp2.RedirectFileEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.io.Closer;

public class ClientPutComplexDir
extends ClientPutDir<ClientPutComplexDir> {
    private List<FileEntry> fileEntries = new ArrayList<FileEntry>();
    private boolean hasPayload = false;
    private File payloadFile;
    private long payloadLength = 0L;
    private final String tempDirectory;

    public ClientPutComplexDir(String identifier, String uri) {
        this(identifier, uri, null);
    }

    public ClientPutComplexDir(String identifier, String uri, String tempDirectory) {
        super("ClientPutComplexDir", identifier, uri);
        this.tempDirectory = tempDirectory;
    }

    public void addFileEntry(FileEntry fileEntry) throws IOException {
        block9: {
            block8: {
                if (!(fileEntry instanceof DirectFileEntry)) break block8;
                if (this.payloadFile == null) {
                    try {
                        this.payloadFile = File.createTempFile("payload", ".dat", this.tempDirectory != null ? new File(this.tempDirectory) : null);
                        this.payloadFile.deleteOnExit();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.payloadFile == null) break block9;
                InputStream payloadInputStream = ((DirectFileEntry)fileEntry).getDataInputStream();
                FileOutputStream payloadOutputStream = null;
                try {
                    payloadOutputStream = new FileOutputStream(this.payloadFile, true);
                    byte[] buffer = new byte[65536];
                    int read = 0;
                    while ((read = payloadInputStream.read(buffer)) != -1) {
                        payloadOutputStream.write(buffer, 0, read);
                    }
                    payloadOutputStream.flush();
                    this.fileEntries.add(fileEntry);
                }
                catch (IOException ioe1) {
                    try {
                        this.payloadFile.delete();
                        throw ioe1;
                    }
                    catch (Throwable throwable) {
                        Closer.close(payloadOutputStream);
                        Closer.close(payloadInputStream);
                        throw throwable;
                    }
                }
                Closer.close(payloadOutputStream);
                Closer.close(payloadInputStream);
                break block9;
            }
            this.fileEntries.add(fileEntry);
        }
    }

    @Override
    protected void write(Writer writer) throws IOException {
        super.write(writer);
        int fileIndex = 0;
        for (FileEntry fileEntry : this.fileEntries) {
            writer.write("Files." + fileIndex + ".Name=" + fileEntry.getFilename() + "\r\n");
            if (fileEntry.getContentType() != null) {
                writer.write("Files." + fileIndex + ".Metadata.ContentType=" + fileEntry.getContentType() + "\r\n");
            }
            writer.write("Files." + fileIndex + ".UploadFrom=" + fileEntry.getName() + "\r\n");
            if (fileEntry instanceof DirectFileEntry) {
                this.hasPayload = true;
                writer.write("Files." + fileIndex + ".DataLength=" + ((DirectFileEntry)fileEntry).getDataLength() + "\r\n");
                this.payloadLength += ((DirectFileEntry)fileEntry).getDataLength();
            } else if (fileEntry instanceof DiskFileEntry) {
                writer.write("Files." + fileIndex + ".Filename=" + ((DiskFileEntry)fileEntry).getFilename() + "\r\n");
            } else if (fileEntry instanceof RedirectFileEntry) {
                writer.write("Files." + fileIndex + ".TargetURI=" + ((RedirectFileEntry)fileEntry).getTargetURI() + "\r\n");
            }
            ++fileIndex;
        }
    }

    @Override
    protected boolean hasPayload() {
        return this.hasPayload;
    }

    @Override
    protected long getPayloadLength() {
        return this.payloadLength;
    }

    @Override
    protected InputStream getPayload() {
        if (this.payloadFile != null) {
            try {
                return new FileInputStream(this.payloadFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

