/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.swing;

import de.todesbaum.util.swing.TWizardPage;
import de.todesbaum.util.swing.WizardListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class TWizard
extends JFrame
implements WindowListener {
    protected List<WizardListener> wizardListeners = new ArrayList<WizardListener>();
    private Action previousAction;
    private Action nextAction;
    private Action quitAction;
    private JLabel pageIcon;
    private JPanel pagePanel;
    private JLabel pageHeading;
    private JLabel pageDescription;

    @Override
    protected void frameInit() {
        super.frameInit();
        this.setResizable(false);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.createActions();
        this.pageIcon = new JLabel();
        this.pageIcon.setVerticalAlignment(1);
        this.pageHeading = new JLabel();
        this.pageHeading.setFont(this.pageHeading.getFont().deriveFont((float)this.pageHeading.getFont().getSize() * 2.0f).deriveFont(1));
        this.pageDescription = new JLabel();
        JPanel contentPane = new JPanel(new BorderLayout(12, 12));
        contentPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel topPanel = new JPanel(new BorderLayout(12, 12));
        contentPane.add((Component)topPanel, "First");
        topPanel.add((Component)this.pageIcon, "Before");
        JPanel textPanel = new JPanel(new BorderLayout(12, 12));
        topPanel.add((Component)textPanel, "Center");
        textPanel.add((Component)this.pageHeading, "First");
        textPanel.add((Component)this.pageDescription, "Center");
        this.pagePanel = new JPanel(new BorderLayout(12, 12));
        contentPane.add((Component)this.pagePanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(4, 12, 12));
        buttonPanel.setBorder(new EmptyBorder(-12, -12, -12, -12));
        buttonPanel.add(new JButton(this.previousAction));
        buttonPanel.add(new JButton(this.nextAction));
        buttonPanel.add(new JButton(this.quitAction));
        contentPane.add((Component)buttonPanel, "Last");
        this.setContentPane(contentPane);
    }

    @Override
    public void pack() {
        super.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    private void createActions() {
        this.previousAction = new AbstractAction("Previous"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TWizard.this.actionPrevious();
            }
        };
        this.nextAction = new AbstractAction("Next"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TWizard.this.actionNext();
            }
        };
        this.quitAction = new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TWizard.this.actionQuit();
            }
        };
    }

    public void addWizardListener(WizardListener wizardListener) {
        this.wizardListeners.add(wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        this.wizardListeners.remove(wizardListener);
    }

    protected void fireWizardPreviousPressed() {
        for (WizardListener wizardListener : this.wizardListeners) {
            wizardListener.wizardPreviousPressed(this);
        }
    }

    protected void fireWizardNextPressed() {
        for (WizardListener wizardListener : this.wizardListeners) {
            wizardListener.wizardNextPressed(this);
        }
    }

    protected void fireWizardQuitPressed() {
        for (WizardListener wizardListener : this.wizardListeners) {
            wizardListener.wizardQuitPressed(this);
        }
    }

    public void setIcon(Icon icon) {
        this.pageIcon.setIcon(icon);
    }

    public void setPage(TWizardPage page) {
        this.setVisible(false);
        this.pageHeading.setText(page.getHeading());
        this.pageDescription.setText(page.getDescription());
        if (this.pagePanel.getComponentCount() > 0 && this.pagePanel.getComponent(0) instanceof TWizardPage) {
            ((TWizardPage)this.pagePanel.getComponent(0)).pageDeleted(this);
        }
        this.pagePanel.removeAll();
        this.pagePanel.add((Component)page, "Center");
        page.pageAdded(this);
        this.pack();
        this.setTitle(page.getHeading());
        this.setVisible(true);
    }

    public TWizardPage getPage() {
        return (TWizardPage)this.pagePanel.getComponent(0);
    }

    public void setPreviousEnabled(boolean previousEnabled) {
        this.previousAction.setEnabled(previousEnabled);
    }

    public void setPreviousName(String previousName) {
        this.previousAction.putValue("Name", previousName);
    }

    public void setNextEnabled(boolean nextEnabled) {
        this.nextAction.setEnabled(nextEnabled);
    }

    public void setNextName(String nextName) {
        this.nextAction.putValue("Name", nextName);
    }

    public void setQuitEnabled(boolean quitEnabled) {
        this.quitAction.setEnabled(quitEnabled);
    }

    public void setQuitName(String quitName) {
        this.quitAction.putValue("Name", quitName);
    }

    protected void actionPrevious() {
        this.fireWizardPreviousPressed();
    }

    protected void actionNext() {
        this.fireWizardNextPressed();
    }

    protected void actionQuit() {
        this.fireWizardQuitPressed();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.fireWizardQuitPressed();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

