/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import net.pterodactylus.util.validation.Validation;

public class Arrays {
    public static byte[] merge(byte[] first, byte[] second) throws IllegalArgumentException {
        Validation.begin().isNotNull("First Array", first).isNotNull("Second Array", second).check().isLessOrEqual("Combined Length", (long)first.length + (long)second.length, Integer.MAX_VALUE).check();
        if (first.length == 0) {
            return second;
        }
        if (second.length == 0) {
            return first;
        }
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

