/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListBuilder<T> {
    private final List<T> list;

    public ListBuilder() {
        this(new ArrayList());
    }

    public ListBuilder(List<T> list) {
        this.list = list;
    }

    public List<T> get() {
        return this.list;
    }

    public ListBuilder<T> add(T element) {
        this.list.add(element);
        return this;
    }

    public ListBuilder<T> addAll(Collection<? extends T> elements) {
        this.list.addAll(elements);
        return this;
    }

    public ListBuilder<T> sort() throws ClassCastException {
        Collections.sort(this.list);
        return this;
    }

    public ListBuilder<T> sort(Comparator<? super T> comparator) {
        Collections.sort(this.list, comparator);
        return this;
    }
}

