/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.Iterator;

public class Looper<T>
implements Iterable<Looped<T>> {
    private Iterable<T> originalIterable;

    public Looper(Iterable<T> originalIterable) {
        this.originalIterable = originalIterable;
    }

    @Override
    public Iterator<Looped<T>> iterator() {
        return new LooperIterator<T>(this.originalIterable.iterator());
    }

    public static class LooperIterator<T>
    implements Iterator<Looped<T>> {
        private final Iterator<T> originalIterator;
        private int index;

        public LooperIterator(Iterator<T> originalIterator) {
            this.originalIterator = originalIterator;
        }

        @Override
        public boolean hasNext() {
            return this.originalIterator.hasNext();
        }

        @Override
        public Looped<T> next() {
            T next = this.originalIterator.next();
            Looped<T> looped = new Looped<T>(next, this.index == 0, !this.hasNext(), this.index);
            ++this.index;
            return looped;
        }

        @Override
        public void remove() {
            this.originalIterator.remove();
        }
    }

    public static class Looped<T> {
        private final T originalElement;
        private final boolean first;
        private final boolean last;
        private final int index;

        public Looped(T originalElement, boolean first, boolean last, int index) {
            this.originalElement = originalElement;
            this.first = first;
            this.last = last;
            this.index = index;
        }

        public T get() {
            return this.originalElement;
        }

        public boolean first() {
            return this.first;
        }

        public boolean last() {
            return this.last;
        }

        public int index() {
            return this.index;
        }
    }
}

