/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import net.pterodactylus.util.database.Parameter;
import net.pterodactylus.util.database.ValueField;
import net.pterodactylus.util.database.WhereClause;

public class ValueFieldWhereClause
implements WhereClause {
    private final ValueField valueField;
    private final boolean invert;

    public ValueFieldWhereClause(ValueField valueField) {
        this(valueField, false);
    }

    public ValueFieldWhereClause(ValueField valueField, boolean invert) {
        this.valueField = valueField;
        this.invert = invert;
    }

    @Override
    public List<Parameter<?>> getParameters() {
        return Arrays.asList(this.valueField.getParameter());
    }

    @Override
    public void render(Writer writer) throws IOException {
        writer.write("(" + this.valueField.getName() + " " + (this.invert ? "!=" : "=") + " ?)");
    }
}

