/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.i18n;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.pterodactylus.util.i18n.I18nable;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;

public class I18n {
    private static final Logger logger = Logging.getLogger(I18n.class);
    public static boolean LOG_UNKNOWN_KEYS = true;
    private final Source mainSource;
    private final List<Source> additionalSources = Collections.synchronizedList(new ArrayList());
    private final List<I18nable> i18nables = new ArrayList<I18nable>();
    private final Map<RemovalReference, List<I18nable>> removalReferenceI18nables = new HashMap<RemovalReference, List<I18nable>>();
    private Locale locale;
    private Map<String, String> values = new HashMap<String, String>();
    private boolean useMessageFormat = false;

    public I18n(String name, String propertiesPath, Locale defaultLocale) {
        this(name, propertiesPath, defaultLocale, Thread.currentThread().getContextClassLoader(), Locale.getDefault());
    }

    public I18n(String name, String propertiesPath, Locale defaultLocale, ClassLoader classLoader, Locale currentLocale) {
        this(new Source(name, propertiesPath, defaultLocale, classLoader), currentLocale);
    }

    public I18n(Source source) {
        this(source, Locale.getDefault());
    }

    public I18n(Source source, Locale currentLocale) {
        this.mainSource = source;
        this.locale = currentLocale;
        this.reload();
    }

    public void addI18nable(I18nable i18nable) {
        this.addI18nable(i18nable, null);
    }

    public void addI18nable(I18nable i18nable, RemovalReference removalReference) {
        this.i18nables.add(i18nable);
        if (removalReference != null) {
            List<I18nable> i18nableList = this.removalReferenceI18nables.get(removalReference);
            if (i18nableList == null) {
                i18nableList = new ArrayList<I18nable>();
                this.removalReferenceI18nables.put(removalReference, i18nableList);
            }
            i18nableList.add(i18nable);
        }
    }

    public void removeI18nable(I18nable i18nable) {
        this.i18nables.remove(i18nable);
    }

    public void removeI18nables(RemovalReference removalReference) {
        List<I18nable> i18nableList = this.removalReferenceI18nables.remove(removalReference);
        if (i18nableList != null) {
            for (I18nable i18nable : i18nableList) {
                this.i18nables.remove(i18nable);
            }
        }
    }

    public void useMessageFormat(boolean useMessageFormat) {
        this.useMessageFormat = useMessageFormat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.reload();
    }

    public void addSource(Source source) {
        this.additionalSources.add(source);
        this.reload();
    }

    public void removeSource(Source source) {
        if (this.additionalSources.remove(source)) {
            this.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(String key) {
        Map<String, String> map = this.values;
        synchronized (map) {
            return this.values.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, Object ... parameters) {
        String value;
        Map<String, String> map = this.values;
        synchronized (map) {
            value = this.values.get(key);
        }
        if (value == null) {
            if (LOG_UNKNOWN_KEYS) {
                logger.log(Level.WARNING, String.format("Please supply a value for \u201c%1$s\u201d!", key), new Exception());
            }
            return key;
        }
        if (parameters != null && parameters.length > 0) {
            return this.useMessageFormat ? MessageFormat.format(value, parameters) : String.format(value, parameters);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKey(String key) {
        String value;
        Map<String, String> map = this.values;
        synchronized (map) {
            value = this.values.get(key);
        }
        if (value != null && value.startsWith("VK_")) {
            try {
                Field field = KeyEvent.class.getField(value);
                return field.getInt(null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (LOG_UNKNOWN_KEYS) {
            logger.log(Level.WARNING, "please fix \u201c" + key + "\u201d!", new Throwable());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStroke getKeyStroke(String key) {
        String value;
        Map<String, String> map = this.values;
        synchronized (map) {
            value = this.values.get(key);
        }
        if (value == null) {
            return null;
        }
        StringTokenizer keyTokens = new StringTokenizer(value, "+- ");
        int modifierMask = 0;
        while (keyTokens.hasMoreTokens()) {
            String keyToken = keyTokens.nextToken();
            if ("ctrl".equalsIgnoreCase(keyToken)) {
                modifierMask |= 0x80;
                continue;
            }
            if ("alt".equalsIgnoreCase(keyToken)) {
                modifierMask |= 0x200;
                continue;
            }
            if ("shift".equalsIgnoreCase(keyToken)) {
                modifierMask |= 0x40;
                continue;
            }
            if (keyToken.startsWith("VK_")) {
                if (keyToken.equals("VK_UNDEFINED")) {
                    return null;
                }
                try {
                    Field field = KeyEvent.class.getField(keyToken);
                    return KeyStroke.getKeyStroke(field.getInt(null), modifierMask);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return KeyStroke.getKeyStroke((int)keyToken.charAt(0), modifierMask);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        Properties currentValues = new Properties();
        this.loadSource(currentValues, this.mainSource, this.mainSource.getDefaultLocale());
        this.loadSource(currentValues, this.mainSource, this.locale);
        for (Source source : this.additionalSources) {
            this.loadSource(currentValues, source, source.getDefaultLocale());
            this.loadSource(currentValues, source, this.locale);
        }
        Iterator<I18nable> iterator = this.values;
        synchronized (iterator) {
            this.values.clear();
            for (Map.Entry<Object, Object> entry : currentValues.entrySet()) {
                this.values.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (I18nable i18nable : this.i18nables) {
            i18nable.updateI18n();
        }
    }

    private void loadSource(Properties currentValues, Source source, Locale locale) {
        for (String variant : this.buildResourceNames(locale)) {
            this.loadResource(currentValues, source.getClassLoader(), source.getPropertiesPath() + "/" + source.getName() + "_" + variant + ".properties");
        }
    }

    private String[] buildResourceNames(Locale locale) {
        ArrayList<String> variants = new ArrayList<String>();
        String currentVariant = locale.getLanguage();
        variants.add(currentVariant);
        if (!locale.getCountry().equals("")) {
            currentVariant = currentVariant + "_" + locale.getCountry();
            variants.add(currentVariant);
        }
        if (locale.getVariant() != null && !locale.getVariant().equals("")) {
            if (locale.getCountry().equals("")) {
                currentVariant = currentVariant + "_";
            }
            currentVariant = currentVariant + "_" + locale.getVariant();
            variants.add(locale.getVariant());
        }
        return variants.toArray(new String[variants.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadResource(Properties currentValues, ClassLoader classLoader, String resourceName) {
        block8: {
            logger.log(Level.FINEST, "Trying to load resources from " + resourceName + "\u2026");
            InputStream inputStream = classLoader.getResourceAsStream(resourceName);
            if (inputStream != null) {
                InputStreamReader inputStreamReader = null;
                try {
                    logger.log(Level.FINEST, "Loading resources from " + resourceName + "\u2026");
                    inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                    currentValues.load(inputStreamReader);
                    logger.log(Level.FINEST, "Resources successfully loaded.");
                    Closer.close(inputStreamReader);
                }
                catch (IOException ioe1) {
                    logger.log(Level.WARNING, String.format("Could not read properties from \u201c%1$s\u201d.", resourceName), ioe1);
                    break block8;
                }
                catch (IllegalArgumentException iae1) {
                    logger.log(Level.WARNING, String.format("Could not parse properties from \u201c%1$s\u201d.", resourceName), iae1);
                    break block8;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Closer.close(inputStreamReader);
                    Closer.close(inputStream);
                }
                Closer.close(inputStream);
            }
        }
    }

    public static class RemovalReference {
    }

    public static class Source {
        private final String name;
        private final String propertiesPath;
        private final Locale defaultLocale;
        private final ClassLoader classLoader;

        public Source(String name, String propertiesPath, Locale defaultLocale, ClassLoader classLoader) {
            this.name = name;
            this.propertiesPath = propertiesPath;
            this.defaultLocale = defaultLocale;
            this.classLoader = classLoader;
        }

        public String getName() {
            return this.name;
        }

        public String getPropertiesPath() {
            return this.propertiesPath;
        }

        public Locale getDefaultLocale() {
            return this.defaultLocale;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

