/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.notify;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import net.pterodactylus.util.io.Renderable;
import net.pterodactylus.util.notify.NotificationListener;

public interface Notification
extends Renderable {
    public static final Comparator<Notification> CREATED_TIME_SORTER = new Comparator<Notification>(){

        @Override
        public int compare(Notification leftNotification, Notification rightNotification) {
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, leftNotification.getCreatedTime() - rightNotification.getCreatedTime()));
        }
    };
    public static final Comparator<Notification> LAST_UPDATED_TIME_SORTER = new Comparator<Notification>(){

        @Override
        public int compare(Notification leftNotification, Notification rightNotification) {
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rightNotification.getLastUpdatedTime() - leftNotification.getLastUpdatedTime()));
        }
    };

    public void addNotificationListener(NotificationListener var1);

    public void removeNotificationListener(NotificationListener var1);

    public String getId();

    public long getLastUpdatedTime();

    public long getCreatedTime();

    public boolean isDismissable();

    public void dismiss();

    @Override
    public void render(Writer var1) throws IOException;
}

