/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.number;

public class Hex {
    public static String toHex(String buffer) {
        return Hex.toHex(buffer.getBytes());
    }

    public static String toHex(byte[] buffer) {
        return Hex.toHex(buffer, 0, buffer.length);
    }

    public static String toHex(byte[] buffer, int start, int length) {
        return Hex.toHex(buffer, start, length, false);
    }

    public static String toHex(String buffer, boolean upperCase) {
        return Hex.toHex(buffer.getBytes(), upperCase);
    }

    public static String toHex(byte[] buffer, boolean upperCase) {
        return Hex.toHex(buffer, 0, buffer.length, upperCase);
    }

    public static String toHex(byte[] buffer, int start, int length, boolean upperCase) {
        StringBuilder hexBuffer = new StringBuilder(length * 2);
        for (int index = start; index < length; ++index) {
            String hexByte = Integer.toHexString(buffer[index] & 0xFF);
            if (upperCase) {
                hexByte = hexByte.toUpperCase();
            }
            if (hexByte.length() < 2) {
                hexBuffer.append('0');
            }
            hexBuffer.append(hexByte);
        }
        return hexBuffer.toString();
    }

    public static String toHex(byte value) {
        return Hex.toHex(value, 2);
    }

    public static String toHex(short value) {
        return Hex.toHex(value, 4);
    }

    public static String toHex(int value) {
        return Hex.toHex(value, 8);
    }

    public static String toHex(long value) {
        return Hex.toHex(value, 16);
    }

    public static String toHex(long value, int digits) {
        String hexValue = Long.toHexString(value);
        if (hexValue.length() > digits) {
            hexValue = hexValue.substring(hexValue.length() - digits, hexValue.length());
        }
        while (hexValue.length() < digits) {
            hexValue = "0" + hexValue;
        }
        return hexValue;
    }

    public static byte[] toByte(String hexString) {
        String cleanedHexString = hexString.replaceAll("[^0-9A-Fa-f]", "");
        if ((cleanedHexString.length() & 1) == 1) {
            throw new IllegalArgumentException("hex string must have even length.");
        }
        byte[] dataBytes = new byte[cleanedHexString.length() / 2];
        for (int stringIndex = 0; stringIndex < cleanedHexString.length(); stringIndex += 2) {
            byte dataByte;
            String hexNumber = cleanedHexString.substring(stringIndex, stringIndex + 2);
            dataBytes[stringIndex / 2] = dataByte = (byte)Integer.parseInt(hexNumber, 16);
        }
        return dataBytes;
    }
}

