/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.storage;

import net.pterodactylus.util.storage.StorageException;

public interface Storable {
    public long getId();

    public byte[] getBuffer() throws StorageException;

    public static class Utils {
        public static char getChar(byte[] buffer, int position) {
            return (char)(buffer[position + 0] & 0xFF | buffer[position + 1] << 8);
        }

        public static int getInt(byte[] buffer, int position) {
            return buffer[position + 0] & 0xFF | buffer[position + 1] << 8 & 0xFF00 | buffer[position + 2] << 16 & 0xFF0000 | buffer[position + 3] << 24 & 0xFF000000;
        }

        public static long getLong(byte[] buffer, int position) {
            return (long)(buffer[position + 0] & 0xFF | buffer[position + 1] << 8 & 0xFF00 | buffer[position + 2] << 16 & 0xFF0000 | buffer[position + 3] << 24 & 0xFF000000) | (long)buffer[position + 4] << 32 & 0xFF00000000L | (long)buffer[position + 5] << 40 & 0xFF0000000000L | (long)buffer[position + 6] << 48 & 0xFF000000000000L | (long)buffer[position + 7] << 56 & 0xFF00000000000000L;
        }

        public static void putChar(char value, byte[] buffer, int position) {
            buffer[position + 0] = (byte)(value & 0xFF);
            buffer[position + 1] = (byte)(value >>> 8 & 0xFF);
        }

        public static void putInt(int value, byte[] buffer, int position) {
            buffer[position + 0] = (byte)(value & 0xFF);
            buffer[position + 1] = (byte)(value >>> 8 & 0xFF);
            buffer[position + 2] = (byte)(value >>> 16 & 0xFF);
            buffer[position + 3] = (byte)(value >>> 24 & 0xFF);
        }

        public static void putLong(long value, byte[] buffer, int position) {
            buffer[position + 0] = (byte)(value & 0xFFL);
            buffer[position + 1] = (byte)(value >>> 8 & 0xFFL);
            buffer[position + 2] = (byte)(value >>> 16 & 0xFFL);
            buffer[position + 3] = (byte)(value >>> 24 & 0xFFL);
            buffer[position + 4] = (byte)(value >>> 32 & 0xFFL);
            buffer[position + 5] = (byte)(value >>> 40 & 0xFFL);
            buffer[position + 6] = (byte)(value >>> 48 & 0xFFL);
            buffer[position + 7] = (byte)(value >>> 56 & 0xFFL);
        }
    }
}

