/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.Theme;

public class DefaultTheme
implements Theme {
    private final Map<String, Template> templates = Collections.synchronizedMap(new HashMap());

    public void addTemplate(String templateName, Template template) {
        this.templates.put(templateName, template);
    }

    public Template getTemplate(String templateName) {
        return this.templates.get(templateName);
    }

    @Override
    public void render(String templateName, TemplateContext templateContext, Writer writer) throws TemplateException, IOException {
        Template template = this.getTemplate(templateName);
        if (template == null) {
            throw new TemplateException(String.format("Template \u201c%s\u201d not found.", templateName));
        }
        templateContext.mergeContext(template.getInitialContext());
        template.render(templateContext, writer);
    }
}

