/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.thread;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.Logging;

public class DumpingThread
extends Thread {
    private static final Logger logger = Logging.getLogger(DumpingThread.class.getName());
    private static int counter = 0;
    private boolean logThreadStartAndEnd;

    public DumpingThread(Runnable runnable) {
        this(runnable, "DumpingThread-" + counter++);
    }

    public DumpingThread(Runnable runnable, String name) {
        this(runnable, name, false);
    }

    public DumpingThread(Runnable runnable, String name, boolean logThreadStartAndEnd) {
        super(runnable, name);
        this.logThreadStartAndEnd = logThreadStartAndEnd;
    }

    public void setLogThreadStartAndEnd(boolean logThreadStartAndEnd) {
        this.logThreadStartAndEnd = logThreadStartAndEnd;
    }

    @Override
    public void run() {
        if (this.logThreadStartAndEnd) {
            logger.log(Level.INFO, "thread starting");
        }
        try {
            super.run();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "***** THREAD EXITED UNEXPECTEDLY! *****", t);
            throw new RuntimeException(t);
        }
        if (this.logThreadStartAndEnd) {
            logger.log(Level.INFO, "thread exited.");
        }
    }
}

