/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.thread;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.thread.DumpingThreadFactory;

public class Ticker
implements Runnable {
    private static final Logger logger = Logging.getLogger(Ticker.class.getName());
    private static final Ticker globalInstance = new Ticker();
    private static int counter = 0;
    private ThreadFactory threadFactory;
    private final Object syncObject = new Object();
    private final Queue<EventIdentifier> executionTimes = new PriorityBlockingQueue<EventIdentifier>();
    private final Map<EventIdentifier, Runnable> runnables = Collections.synchronizedMap(new HashMap());
    private boolean running = false;

    public Ticker() {
        this(new DumpingThreadFactory());
    }

    public Ticker(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public static Ticker getInstance() {
        return globalInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object registerEvent(long executionTime, Runnable thread) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.registerEvent(executionTime, thread, "Event-" + counter++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerEvent(long executionTime, Runnable thread, String eventName) {
        Object object = this.syncObject;
        synchronized (object) {
            logger.log(Level.INFO, "Ticker registered %s at %d.", new Object[]{eventName, executionTime});
            EventIdentifier identifierObject = new EventIdentifier(executionTime, eventName);
            this.runnables.put(identifierObject, thread);
            this.executionTimes.add(identifierObject);
            if (!this.running) {
                this.running = true;
                Thread tickerThread = this.threadFactory.newThread(this);
                tickerThread.setName("Ticker Thread");
                tickerThread.start();
            } else {
                this.syncObject.notify();
            }
            return identifierObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeExecutionTime(Object identifierObject, long newExecutionTime) {
        if (!(identifierObject instanceof EventIdentifier)) {
            return;
        }
        EventIdentifier eventIdentifier = (EventIdentifier)identifierObject;
        Object object = this.syncObject;
        synchronized (object) {
            this.executionTimes.remove(eventIdentifier);
            eventIdentifier.setExecutionTime(newExecutionTime);
            this.executionTimes.add(eventIdentifier);
            this.syncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterEvent(Object eventIdentifier) {
        if (!(eventIdentifier instanceof EventIdentifier)) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            logger.log(Level.INFO, "Ticker removes event %s at %d.", new Object[]{((EventIdentifier)eventIdentifier).getEventName(), ((EventIdentifier)eventIdentifier).getExecutionTime()});
            this.runnables.remove(eventIdentifier);
            this.removeEventIdentifier((EventIdentifier)eventIdentifier);
            this.syncObject.notify();
        }
    }

    private boolean removeEventIdentifier(EventIdentifier eventIdentifier) {
        Iterator iterator = this.executionTimes.iterator();
        while (iterator.hasNext()) {
            if (!((EventIdentifier)iterator.next()).equals(eventIdentifier)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.syncObject;
        synchronized (object) {
            this.running = false;
            this.syncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        logger.log(Level.INFO, "Ticker started.");
        Object object = this.syncObject;
        synchronized (object) {
            while (this.running) {
                if (this.executionTimes.isEmpty()) {
                    logger.log(Level.INFO, "Ticker is waiting for events.");
                    try {
                        this.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                EventIdentifier eventIdentifier = this.executionTimes.peek();
                if (eventIdentifier == null) continue;
                long now = System.currentTimeMillis();
                long executionTime = eventIdentifier.getExecutionTime();
                if (executionTime > now) {
                    logger.log(Level.INFO, "Ticker is waiting up to %d for %s to execute at %d.", new Object[]{executionTime - now, eventIdentifier.getEventName(), executionTime});
                    try {
                        this.syncObject.wait(executionTime - now);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.removeEventIdentifier(eventIdentifier);
                Runnable runnable = this.runnables.remove(eventIdentifier);
                if (runnable == null) continue;
                logger.log(Level.INFO, "Ticker executes %s, %d ms late", new Object[]{eventIdentifier.getEventName(), now - executionTime});
                Thread eventThread = this.threadFactory.newThread(runnable);
                eventThread.setName("Event Thread for " + eventIdentifier.getEventName() + " @ " + executionTime);
                eventThread.start();
            }
            return;
        }
    }

    private static class EventIdentifier
    implements Comparable<EventIdentifier> {
        private long executionTime;
        private final String eventName;

        public EventIdentifier(long executionTime, String eventName) {
            this.executionTime = executionTime;
            this.eventName = eventName;
        }

        public void setExecutionTime(long newExecutionTime) {
            this.executionTime = newExecutionTime;
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public String getEventName() {
            return this.eventName;
        }

        @Override
        public int compareTo(EventIdentifier o) {
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, this.executionTime - o.executionTime));
        }
    }
}

