/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.validation;

import net.pterodactylus.util.validation.Validator;

public class DoubleRangeValidator
implements Validator<Double> {
    private final double lowerBound;
    private final boolean includeLowerBound;
    private final double upperBound;
    private final boolean includeUpperBound;

    public DoubleRangeValidator(double lowerBound, boolean includeLowerBound, double upperBound, boolean includeUpperBound) {
        this.lowerBound = lowerBound;
        this.includeLowerBound = includeLowerBound;
        this.upperBound = upperBound;
        this.includeUpperBound = includeUpperBound;
    }

    @Override
    public boolean validate(Double value) {
        return (this.includeLowerBound ? value >= this.lowerBound : value > this.lowerBound) && (this.includeUpperBound ? value <= this.upperBound : value < this.upperBound);
    }

    public String toString() {
        return "((x " + (this.includeLowerBound ? ">=" : ">") + " " + this.lowerBound + ") && (x " + (this.includeUpperBound ? "<=" : "<") + " " + this.upperBound + "))";
    }
}

