/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.web.Header;

public class Response {
    private int statusCode = 200;
    private String statusText = "OK";
    private String contentType = "text/plain; charset=utf-8";
    private Map<String, Header> headers = new HashMap<String, Header>();
    private final OutputStream content;

    public Response(OutputStream content) {
        this.content = content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Response setStatusText(String statusText) {
        this.statusText = statusText;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Response setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Response write(String text) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(this.content, "UTF-8");
            outputStreamWriter.write(text);
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            Closer.close(outputStreamWriter);
            throw throwable;
        }
        Closer.close(outputStreamWriter);
        return this;
    }

    public Response write(byte[] data) throws IOException {
        this.content.write(data);
        return this;
    }

    public Iterable<Header> getHeaders() {
        return this.headers.values();
    }

    public Response addHeader(String name, String value) {
        this.getHeader(name).addValue(value);
        return this;
    }

    public OutputStream getContent() {
        return this.content;
    }

    private Header getHeader(String name) {
        Header header = this.headers.get(name);
        if (header == null) {
            header = new Header(name);
            this.headers.put(name, header);
        }
        return header;
    }

    protected static Map<String, String> createHeader(String name, String value) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(name, value);
        return headers;
    }
}

