/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@Beta
@GwtCompatible(emulated=true)
public final class Utf8 {
    public static int encodedLength(CharSequence sequence) {
        int i2;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i2 = 0; i2 < utf16Length && sequence.charAt(i2) < '\u0080'; ++i2) {
        }
        while (i2 < utf16Length) {
            char c = sequence.charAt(i2);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i2);
                break;
            }
            ++i2;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start2) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i2 = start2; i2 < utf16Length; ++i2) {
            char c = sequence.charAt(i2);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            if (Character.codePointAt(sequence, i2) == c) {
                throw new IllegalArgumentException(Utf8.unpairedSurrogateMsg(i2));
            }
            ++i2;
        }
        return utf8Length;
    }

    public static boolean isWellFormed(byte[] bytes2) {
        return Utf8.isWellFormed(bytes2, 0, bytes2.length);
    }

    public static boolean isWellFormed(byte[] bytes2, int off, int len) {
        int end = off + len;
        Preconditions.checkPositionIndexes(off, end, bytes2.length);
        for (int i2 = off; i2 < end; ++i2) {
            if (bytes2[i2] >= 0) continue;
            return Utf8.isWellFormedSlowPath(bytes2, i2, end);
        }
        return true;
    }

    private static boolean isWellFormedSlowPath(byte[] bytes2, int off, int end) {
        int index = off;
        while (true) {
            byte byte2;
            byte byte1;
            if (index >= end) {
                return true;
            }
            if ((byte1 = bytes2[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index == end) {
                    return false;
                }
                if (byte1 >= -62 && bytes2[index++] <= -65) continue;
                return false;
            }
            if (byte1 < -16) {
                if (index + 1 >= end) {
                    return false;
                }
                if (!((byte2 = bytes2[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && -96 <= byte2) && bytes2[index++] <= -65) continue;
                return false;
            }
            if (index + 2 >= end) {
                return false;
            }
            if ((byte2 = bytes2[index++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes2[index++] > -65 || bytes2[index++] > -65) break;
        }
        return false;
    }

    private static String unpairedSurrogateMsg(int i2) {
        return "Unpaired surrogate at index " + i2;
    }

    private Utf8() {
    }
}

