/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.cglib.core;

import com.google.inject.internal.asm.$Attribute;
import com.google.inject.internal.asm.$Type;
import com.google.inject.internal.cglib.core.$ClassInfo;
import com.google.inject.internal.cglib.core.$CodeGenerationException;
import com.google.inject.internal.cglib.core.$Constants;
import com.google.inject.internal.cglib.core.$MethodInfo;
import com.google.inject.internal.cglib.core.$Signature;
import com.google.inject.internal.cglib.core.$TypeUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class $ReflectUtils {
    private static final Map primitives;
    private static final Map transforms;
    private static final ClassLoader defaultLoader;
    private static Method DEFINE_CLASS;
    private static Method DEFINE_CLASS_UNSAFE;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final Object UNSAFE;
    private static final Throwable THROWABLE;
    private static final List<Method> OBJECT_METHODS;
    private static final String[] CGLIB_PACKAGES;

    private $ReflectUtils() {
    }

    public static ProtectionDomain getProtectionDomain(final Class source) {
        if (source == null) {
            return null;
        }
        return (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return source.getProtectionDomain();
            }
        });
    }

    public static $Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            return $TypeUtils.getTypes(((Method)member).getExceptionTypes());
        }
        if (member instanceof Constructor) {
            return $TypeUtils.getTypes(((Constructor)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static $Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new $Signature(member.getName(), $Type.getMethodDescriptor((Method)member));
        }
        if (member instanceof Constructor) {
            $Type[] types = $TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new $Signature("<init>", $Type.getMethodDescriptor($Type.VOID_TYPE, types));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String desc) {
        return $ReflectUtils.findConstructor(desc, defaultLoader);
    }

    public static Constructor findConstructor(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            String className = desc.substring(0, lparen).trim();
            return $ReflectUtils.getClass(className, loader).getConstructor($ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e) {
            throw new $CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new $CodeGenerationException(e);
        }
    }

    public static Method findMethod(String desc) {
        return $ReflectUtils.findMethod(desc, defaultLoader);
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            int dot = desc.lastIndexOf(46, lparen);
            String className = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            return $ReflectUtils.getClass(className, loader).getDeclaredMethod(methodName, $ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e) {
            throw new $CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new $CodeGenerationException(e);
        }
    }

    private static Class[] parseTypes(String desc, ClassLoader loader) throws ClassNotFoundException {
        int comma;
        int lparen = desc.indexOf(40);
        int rparen = desc.indexOf(41, lparen);
        ArrayList<String> params = new ArrayList<String>();
        int start2 = lparen + 1;
        while ((comma = desc.indexOf(44, start2)) >= 0) {
            params.add(desc.substring(start2, comma).trim());
            start2 = comma + 1;
        }
        if (start2 < rparen) {
            params.add(desc.substring(start2, rparen).trim());
        }
        Class[] types = new Class[params.size()];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = $ReflectUtils.getClass((String)params.get(i2), loader);
        }
        return types;
    }

    private static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return $ReflectUtils.getClass(className, loader, CGLIB_PACKAGES);
    }

    private static Class getClass(String className, ClassLoader loader, String[] packages) throws ClassNotFoundException {
        String save = className;
        int dimensions = 0;
        int index = 0;
        while ((index = className.indexOf("[]", index) + 1) > 0) {
            ++dimensions;
        }
        StringBuffer brackets = new StringBuffer(className.length() - dimensions);
        for (int i2 = 0; i2 < dimensions; ++i2) {
            brackets.append('[');
        }
        className = className.substring(0, className.length() - 2 * dimensions);
        String prefix = dimensions > 0 ? brackets + "L" : "";
        String suffix = dimensions > 0 ? ";" : "";
        try {
            return Class.forName(prefix + className + suffix, false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (int i3 = 0; i3 < packages.length; ++i3) {
                try {
                    return Class.forName(prefix + packages[i3] + '.' + className + suffix, false, loader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    continue;
                }
            }
            if (dimensions == 0) {
                Class c = (Class)primitives.get(className);
                if (c != null) {
                    return c;
                }
            } else {
                String transform2 = (String)transforms.get(className);
                if (transform2 != null) {
                    try {
                        return Class.forName(brackets + transform2, false, loader);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(save);
        }
    }

    public static Object newInstance(Class type) {
        return $ReflectUtils.newInstance(type, $Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class type, Class[] parameterTypes, Object[] args2) {
        return $ReflectUtils.newInstance($ReflectUtils.getConstructor(type, parameterTypes), args2);
    }

    public static Object newInstance(Constructor cstruct, Object[] args2) {
        boolean flag = cstruct.isAccessible();
        try {
            Object result2;
            if (!flag) {
                cstruct.setAccessible(true);
            }
            Object t = result2 = cstruct.newInstance(args2);
            return t;
        }
        catch (InstantiationException e) {
            throw new $CodeGenerationException(e);
        }
        catch (IllegalAccessException e) {
            throw new $CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new $CodeGenerationException(e.getTargetException());
        }
        finally {
            if (!flag) {
                cstruct.setAccessible(flag);
            }
        }
    }

    public static Constructor getConstructor(Class type, Class[] parameterTypes) {
        try {
            Constructor constructor = type.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new $CodeGenerationException(e);
        }
    }

    public static String[] getNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] names = new String[classes.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = classes[i2].getName();
        }
        return names;
    }

    public static Class[] getClasses(Object[] objects) {
        Class[] classes = new Class[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            classes[i2] = objects[i2].getClass();
        }
        return classes;
    }

    public static Method findNewInstance(Class iface) {
        Method m3 = $ReflectUtils.findInterfaceMethod(iface);
        if (!m3.getName().equals("newInstance")) {
            throw new IllegalArgumentException(iface + " missing newInstance method");
        }
        return m3;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties2, boolean read, boolean write) {
        HashSet<Method> methods = new HashSet<Method>();
        for (int i2 = 0; i2 < properties2.length; ++i2) {
            PropertyDescriptor pd = properties2[i2];
            if (read) {
                methods.add(pd.getReadMethod());
            }
            if (!write) continue;
            methods.add(pd.getWriteMethod());
        }
        methods.remove(null);
        return methods.toArray(new Method[methods.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class type) {
        return $ReflectUtils.getPropertiesHelper(type, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class type) {
        return $ReflectUtils.getPropertiesHelper(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type) {
        return $ReflectUtils.getPropertiesHelper(type, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class type, boolean read, boolean write) {
        try {
            BeanInfo info = Introspector.getBeanInfo(type, Object.class);
            PropertyDescriptor[] all2 = info.getPropertyDescriptors();
            if (read && write) {
                return all2;
            }
            ArrayList<PropertyDescriptor> properties2 = new ArrayList<PropertyDescriptor>(all2.length);
            for (int i2 = 0; i2 < all2.length; ++i2) {
                PropertyDescriptor pd = all2[i2];
                if ((!read || pd.getReadMethod() == null) && (!write || pd.getWriteMethod() == null)) continue;
                properties2.add(pd);
            }
            return properties2.toArray(new PropertyDescriptor[properties2.size()]);
        }
        catch (IntrospectionException e) {
            throw new $CodeGenerationException(e);
        }
    }

    public static Method findDeclaredMethod(Class type, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        for (Class cl = type; cl != null; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static List addAllMethods(Class type, List list) {
        if (type == Object.class) {
            list.addAll(OBJECT_METHODS);
        } else {
            list.addAll(Arrays.asList(type.getDeclaredMethods()));
        }
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            $ReflectUtils.addAllMethods(superclass, list);
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            $ReflectUtils.addAllMethods(interfaces[i2], list);
        }
        return list;
    }

    public static List addAllInterfaces(Class type, List list) {
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            list.addAll(Arrays.asList(type.getInterfaces()));
            $ReflectUtils.addAllInterfaces(superclass, list);
        }
        return list;
    }

    public static Method findInterfaceMethod(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method[] methods = iface.getDeclaredMethods();
        if (methods.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
        }
        return methods[0];
    }

    public static Class defineClass(String className, byte[] b, ClassLoader loader) throws Exception {
        return $ReflectUtils.defineClass(className, b, loader, PROTECTION_DOMAIN);
    }

    public static Class defineClass(String className, byte[] b, ClassLoader loader, ProtectionDomain protectionDomain) throws Exception {
        Class c;
        if (DEFINE_CLASS != null) {
            Object[] args2 = new Object[]{className, b, new Integer(0), new Integer(b.length), protectionDomain};
            c = (Class)DEFINE_CLASS.invoke((Object)loader, args2);
        } else if (DEFINE_CLASS_UNSAFE != null) {
            Object[] args3 = new Object[]{className, b, new Integer(0), new Integer(b.length), loader, protectionDomain};
            c = (Class)DEFINE_CLASS_UNSAFE.invoke(UNSAFE, args3);
        } else {
            throw new $CodeGenerationException(THROWABLE);
        }
        Class.forName(className, true, loader);
        return c;
    }

    public static int findPackageProtected(Class[] classes) {
        for (int i2 = 0; i2 < classes.length; ++i2) {
            if (Modifier.isPublic(classes[i2].getModifiers())) continue;
            return i2;
        }
        return 0;
    }

    public static $MethodInfo getMethodInfo(final Member member, final int modifiers) {
        final $Signature sig = $ReflectUtils.getSignature(member);
        return new $MethodInfo(){
            private $ClassInfo ci;

            public $ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = $ReflectUtils.getClassInfo(member.getDeclaringClass());
                }
                return this.ci;
            }

            public int getModifiers() {
                return modifiers;
            }

            public $Signature getSignature() {
                return sig;
            }

            public $Type[] getExceptionTypes() {
                return $ReflectUtils.getExceptionTypes(member);
            }

            public $Attribute getAttribute() {
                return null;
            }
        };
    }

    public static $MethodInfo getMethodInfo(Member member) {
        return $ReflectUtils.getMethodInfo(member, member.getModifiers());
    }

    public static $ClassInfo getClassInfo(final Class clazz) {
        final $Type type = $Type.getType(clazz);
        final $Type sc = clazz.getSuperclass() == null ? null : $Type.getType(clazz.getSuperclass());
        return new $ClassInfo(){

            public $Type getType() {
                return type;
            }

            public $Type getSuperType() {
                return sc;
            }

            public $Type[] getInterfaces() {
                return $TypeUtils.getTypes(clazz.getInterfaces());
            }

            public int getModifiers() {
                return clazz.getModifiers();
            }
        };
    }

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods) {
        HashMap<String, Method> map2 = new HashMap<String, Method>();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method method = methods[i2];
            map2.put(method.getName() + $Type.getMethodDescriptor(method), method);
        }
        Method[] result2 = new Method[namesAndDescriptors.length / 2];
        for (int i3 = 0; i3 < result2.length; ++i3) {
            result2[i3] = (Method)map2.get(namesAndDescriptors[i3 * 2] + namesAndDescriptors[i3 * 2 + 1]);
            if (result2[i3] != null) continue;
        }
        return result2;
    }

    static {
        Object unsafe;
        Method defineClassUnsafe;
        Method defineClass;
        ProtectionDomain protectionDomain;
        primitives = new HashMap(8);
        transforms = new HashMap(8);
        defaultLoader = $ReflectUtils.class.getClassLoader();
        OBJECT_METHODS = new ArrayList<Method>();
        Throwable throwable = null;
        try {
            protectionDomain = $ReflectUtils.getProtectionDomain($ReflectUtils.class);
            try {
                defineClass = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Class<?> loader = Class.forName("java.lang.ClassLoader");
                        Method defineClass = loader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                        defineClass.setAccessible(true);
                        return defineClass;
                    }
                });
                defineClassUnsafe = null;
                unsafe = null;
            }
            catch (Throwable t) {
                throwable = t;
                defineClass = null;
                unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Class<?> u = Class.forName("sun.misc.Unsafe");
                        Field theUnsafe = u.getDeclaredField("theUnsafe");
                        theUnsafe.setAccessible(true);
                        return theUnsafe.get(null);
                    }
                });
                Class<?> u = Class.forName("sun.misc.Unsafe");
                defineClassUnsafe = u.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method[] methods;
                    for (Method method : methods = Object.class.getDeclaredMethods()) {
                        if ("finalize".equals(method.getName()) || (method.getModifiers() & 0x18) > 0) continue;
                        OBJECT_METHODS.add(method);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            if (throwable == null) {
                throwable = t;
            }
            protectionDomain = null;
            defineClass = null;
            defineClassUnsafe = null;
            unsafe = null;
        }
        PROTECTION_DOMAIN = protectionDomain;
        DEFINE_CLASS = defineClass;
        DEFINE_CLASS_UNSAFE = defineClassUnsafe;
        UNSAFE = unsafe;
        THROWABLE = throwable;
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

