/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.SoneComparison;
import net.pterodactylus.sone.core.UpdatedSoneProcessor;
import net.pterodactylus.sone.core.event.NewPostFoundEvent;
import net.pterodactylus.sone.core.event.NewPostReplyFoundEvent;
import net.pterodactylus.sone.core.event.PostRemovedEvent;
import net.pterodactylus.sone.core.event.PostReplyRemovedEvent;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.Database;
import net.pterodactylus.sone.utils.BooleansKt;
import net.pterodactylus.util.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH$J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lnet/pterodactylus/sone/core/BasicUpdateSoneProcessor;", "Lnet/pterodactylus/sone/core/UpdatedSoneProcessor;", "database", "Lnet/pterodactylus/sone/database/Database;", "eventBus", "Lcom/google/common/eventbus/EventBus;", "(Lnet/pterodactylus/sone/database/Database;Lcom/google/common/eventbus/EventBus;)V", "logger", "Ljava/util/logging/Logger;", "followingTime", "", "Lnet/pterodactylus/sone/data/Sone;", "getFollowingTime", "(Lnet/pterodactylus/sone/data/Sone;)J", "soneCanBeUpdated", "", "storedSone", "newSone", "updateSone", "", "sone", "Sone"})
public abstract class BasicUpdateSoneProcessor
implements UpdatedSoneProcessor {
    private final Logger logger;
    private final Database database;
    private final EventBus eventBus;

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateSone(@NotNull Sone sone) {
        void $this$mapTo$iv$iv;
        Object object;
        Object it;
        Object object2;
        void $this$mapTo$iv$iv2;
        Object p1;
        void $this$forEach$iv;
        boolean bl;
        Object it$iv$iv;
        Object object3;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(sone, "sone");
        Sone sone2 = this.database.getSone(sone.getId());
        if (sone2 == null) {
            return;
        }
        Sone storedSone = sone2;
        if (!this.soneCanBeUpdated(storedSone, sone)) {
            this.logger.fine("Downloaded Sone " + sone + " can not update stored Sone " + storedSone + '.');
            return;
        }
        SoneComparison soneComparison = new SoneComparison(storedSone, sone);
        boolean bl5 = false;
        boolean bl6 = false;
        SoneComparison $this$apply = soneComparison;
        boolean bl7 = false;
        Iterable $this$onEach$iv = $this$apply.getNewPosts();
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        boolean bl8 = false;
        boolean bl9 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl10 = false;
        for (Object element$iv : $this$apply$iv) {
            Post post = (Post)element$iv;
            boolean bl11 = false;
            if (post.getTime() > this.getFollowingTime(sone)) continue;
            post.setKnown(true);
        }
        Iterable $this$mapNotNull$iv = iterable;
        boolean $i$f$mapNotNull22 = false;
        iterable = $this$mapNotNull$iv;
        Iterator destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object4 = $this$forEach$iv$iv$iv.iterator();
        while (object4.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = object4.next();
            bl4 = false;
            Post post = (Post)element$iv$iv;
            boolean bl12 = false;
            if ((NewPostFoundEvent)BooleansKt.ifFalse(post.isKnown(), (Function0)new Function0<NewPostFoundEvent>(post){
                final /* synthetic */ Post $post;

                @NotNull
                public final NewPostFoundEvent invoke() {
                    return new NewPostFoundEvent(this.$post);
                }
                {
                    this.$post = post;
                    super(0);
                }
            }) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = object3;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)((Object)destination$iv$iv);
        EventBus $i$f$mapNotNull22 = this.eventBus;
        boolean $i$f$forEach22 = false;
        destination$iv$iv = $this$forEach$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv;
            p1 = element$iv = destination$iv$iv.next();
            boolean bl13 = false;
            $i$f$mapNotNull22.post(p1);
        }
        Iterable $this$map$iv = $this$apply.getRemovedPosts();
        boolean $i$f$map22 = false;
        Iterable $i$f$forEach22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            object4 = (Post)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl14 = false;
            object = new PostRemovedEvent((Post)it);
            object2.add((PostRemovedEvent)object);
        }
        $this$map$iv = (List)((Object)destination$iv$iv);
        EventBus $i$f$map22 = this.eventBus;
        boolean $i$f$forEach32 = false;
        for (Object element$iv : $this$forEach$iv) {
            p1 = element$iv;
            boolean bl15 = false;
            $i$f$map22.post(p1);
        }
        $this$onEach$iv = $this$apply.getNewPostReplies();
        $i$f$onEach = false;
        Iterable $i$f$forEach32 = $this$onEach$iv;
        boolean destination$iv$iv2 = false;
        boolean element$iv = false;
        $this$apply$iv = $i$f$forEach32;
        bl10 = false;
        for (Object element$iv2 : $this$apply$iv) {
            PostReply postReply = (PostReply)element$iv2;
            boolean bl16 = false;
            if (postReply.getTime() > this.getFollowingTime(sone)) continue;
            this.database.setPostReplyKnown(postReply);
        }
        $this$mapNotNull$iv = $i$f$forEach32;
        boolean $i$f$mapNotNull32 = false;
        $i$f$forEach32 = $this$mapNotNull$iv;
        Object destination$iv$iv3 = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = it.next();
            bl4 = false;
            PostReply postReply = (PostReply)element$iv$iv;
            boolean bl17 = false;
            if ((NewPostReplyFoundEvent)BooleansKt.ifFalse(postReply.isKnown(), (Function0)new Function0<NewPostReplyFoundEvent>(postReply){
                final /* synthetic */ PostReply $postReply;

                @NotNull
                public final NewPostReplyFoundEvent invoke() {
                    return new NewPostReplyFoundEvent(this.$postReply);
                }
                {
                    this.$postReply = postReply;
                    super(0);
                }
            }) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = object3;
            bl = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        EventBus $i$f$mapNotNull32 = this.eventBus;
        boolean $i$f$forEach42 = false;
        destination$iv$iv3 = $this$forEach$iv.iterator();
        while (destination$iv$iv3.hasNext()) {
            p1 = element$iv = destination$iv$iv3.next();
            boolean bl18 = false;
            $i$f$mapNotNull32.post(p1);
        }
        $this$map$iv = $this$apply.getRemovedPostReplies();
        boolean $i$f$map = false;
        Iterable $i$f$forEach42 = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PostReply)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl19 = false;
            object = new PostReplyRemovedEvent((PostReply)it);
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv3;
        EventBus eventBus = this.eventBus;
        boolean $i$f$forEach5 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            p1 = element$iv3;
            boolean bl20 = false;
            eventBus.post(p1);
        }
        this.database.storeSone(sone);
        sone.setOptions(storedSone.getOptions());
        sone.setKnown(storedSone.isKnown());
        sone.setStatus(sone.getTime() != 0L ? Sone.SoneStatus.idle : Sone.SoneStatus.unknown);
    }

    protected abstract boolean soneCanBeUpdated(@NotNull Sone var1, @NotNull Sone var2);

    private final long getFollowingTime(@NotNull Sone $this$followingTime) {
        Long l = this.database.getFollowingTime($this$followingTime.getId());
        return l != null ? l : 0L;
    }

    public BasicUpdateSoneProcessor(@NotNull Database database, @NotNull EventBus eventBus) {
        Intrinsics.checkParameterIsNotNull(database, "database");
        Intrinsics.checkParameterIsNotNull(eventBus, "eventBus");
        this.database = database;
        this.eventBus = eventBus;
        Logger logger = Logging.getLogger("javaClass");
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        this.logger = logger;
    }
}

