/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Profile;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.AlbumBuilderFactory;
import net.pterodactylus.sone.database.ImageBuilderFactory;
import net.pterodactylus.sone.database.PostBuilder;
import net.pterodactylus.sone.database.PostBuilderFactory;
import net.pterodactylus.sone.database.PostReplyBuilder;
import net.pterodactylus.sone.database.PostReplyBuilderFactory;
import net.pterodactylus.util.config.Configuration;

public class ConfigurationSoneParser {
    private final Configuration configuration;
    private final Sone sone;
    private final String sonePrefix;
    private final Map<String, Album> albums = new HashMap<String, Album>();
    private final List<Album> topLevelAlbums = new ArrayList<Album>();
    private final Map<String, Image> images = new HashMap<String, Image>();

    public ConfigurationSoneParser(Configuration configuration, Sone sone) {
        this.configuration = configuration;
        this.sone = sone;
        this.sonePrefix = "Sone/" + sone.getId();
    }

    public Profile parseProfile() {
        String fieldPrefix;
        String fieldName;
        Profile profile = new Profile(this.sone);
        profile.setFirstName(this.getString("/Profile/FirstName", null));
        profile.setMiddleName(this.getString("/Profile/MiddleName", null));
        profile.setLastName(this.getString("/Profile/LastName", null));
        profile.setBirthDay(this.getInt("/Profile/BirthDay", null));
        profile.setBirthMonth(this.getInt("/Profile/BirthMonth", null));
        profile.setBirthYear(this.getInt("/Profile/BirthYear", null));
        int fieldCount = 0;
        while ((fieldName = this.getString((fieldPrefix = "/Profile/Fields/" + fieldCount++) + "/Name", null)) != null) {
            String fieldValue = this.getString(fieldPrefix + "/Value", "");
            profile.addField(fieldName).setValue(fieldValue);
        }
        return profile;
    }

    private String getString(String nodeName, @Nullable String defaultValue) {
        return this.configuration.getStringValue(this.sonePrefix + nodeName).getValue(defaultValue);
    }

    private Integer getInt(String nodeName, @Nullable Integer defaultValue) {
        return this.configuration.getIntValue(this.sonePrefix + nodeName).getValue(defaultValue);
    }

    private Long getLong(String nodeName, @Nullable Long defaultValue) {
        return this.configuration.getLongValue(this.sonePrefix + nodeName).getValue(defaultValue);
    }

    public Set<Post> parsePosts(PostBuilderFactory postBuilderFactory) throws InvalidPostFound {
        String postPrefix;
        String postId;
        HashSet<Post> posts = new HashSet<Post>();
        while ((postId = this.getString((postPrefix = "/Posts/" + posts.size()) + "/ID", null)) != null) {
            String postText;
            long postTime = this.getLong(postPrefix + "/Time", 0L);
            if (this.postAttributesAreInvalid(postTime, postText = this.getString(postPrefix + "/Text", null))) {
                throw new InvalidPostFound();
            }
            PostBuilder postBuilder = postBuilderFactory.newPostBuilder().withId(postId).from(this.sone.getId()).withTime(postTime).withText(postText);
            String postRecipientId = this.getString(postPrefix + "/Recipient", null);
            if (this.postRecipientIsValid(postRecipientId)) {
                postBuilder.to(postRecipientId);
            }
            posts.add(postBuilder.build());
        }
        return posts;
    }

    private boolean postAttributesAreInvalid(long postTime, String postText) {
        return postTime == 0L || postText == null;
    }

    private boolean postRecipientIsValid(String postRecipientId) {
        return postRecipientId != null && postRecipientId.length() == 43;
    }

    public Set<PostReply> parsePostReplies(PostReplyBuilderFactory postReplyBuilderFactory) {
        String replyPrefix;
        String replyId;
        HashSet<PostReply> replies = new HashSet<PostReply>();
        while ((replyId = this.getString((replyPrefix = "/Replies/" + replies.size()) + "/ID", null)) != null) {
            String postId = this.getString(replyPrefix + "/Post/ID", null);
            long replyTime = this.getLong(replyPrefix + "/Time", 0L);
            String replyText = this.getString(replyPrefix + "/Text", null);
            if (postId == null || replyTime == 0L || replyText == null) {
                throw new InvalidPostReplyFound();
            }
            PostReplyBuilder postReplyBuilder = (PostReplyBuilder)((PostReplyBuilder)((PostReplyBuilder)((PostReplyBuilder)postReplyBuilderFactory.newPostReplyBuilder().withId(replyId)).from(this.sone.getId())).to(postId).withTime(replyTime)).withText(replyText);
            replies.add(postReplyBuilder.build());
        }
        return replies;
    }

    public Set<String> parseLikedPostIds() {
        String likedPostId;
        HashSet<String> likedPostIds = new HashSet<String>();
        while ((likedPostId = this.getString("/Likes/Post/" + likedPostIds.size() + "/ID", null)) != null) {
            likedPostIds.add(likedPostId);
        }
        return likedPostIds;
    }

    public Set<String> parseLikedPostReplyIds() {
        String likedReplyId;
        HashSet<String> likedPostReplyIds = new HashSet<String>();
        while ((likedReplyId = this.getString("/Likes/Reply/" + likedPostReplyIds.size() + "/ID", null)) != null) {
            likedPostReplyIds.add(likedReplyId);
        }
        return likedPostReplyIds;
    }

    public Set<String> parseFriends() {
        String friendId;
        HashSet<String> friends = new HashSet<String>();
        while ((friendId = this.getString("/Friends/" + friends.size() + "/ID", null)) != null) {
            friends.add(friendId);
        }
        return friends;
    }

    public List<Album> parseTopLevelAlbums(AlbumBuilderFactory albumBuilderFactory) {
        String albumPrefix;
        String albumId;
        int albumCounter = 0;
        while ((albumId = this.getString((albumPrefix = "/Albums/" + albumCounter++) + "/ID", null)) != null) {
            String albumTitle = this.getString(albumPrefix + "/Title", null);
            String albumDescription = this.getString(albumPrefix + "/Description", null);
            String albumParentId = this.getString(albumPrefix + "/Parent", null);
            if (albumTitle == null || albumDescription == null) {
                throw new InvalidAlbumFound();
            }
            Album album = albumBuilderFactory.newAlbumBuilder().withId(albumId).by(this.sone).build().modify().setTitle(albumTitle).setDescription(albumDescription).update();
            if (albumParentId != null) {
                Album parentAlbum = this.albums.get(albumParentId);
                if (parentAlbum == null) {
                    throw new InvalidParentAlbumFound(albumParentId);
                }
                parentAlbum.addAlbum(album);
            } else {
                this.topLevelAlbums.add(album);
            }
            this.albums.put(albumId, album);
        }
        return this.topLevelAlbums;
    }

    public Map<String, Album> getAlbums() {
        return Collections.unmodifiableMap(this.albums);
    }

    public void parseImages(ImageBuilderFactory imageBuilderFactory) {
        String imagePrefix;
        String imageId;
        int imageCounter = 0;
        while ((imageId = this.getString((imagePrefix = "/Images/" + imageCounter++) + "/ID", null)) != null) {
            Integer height;
            Integer width;
            Long creationTime;
            String description;
            String title;
            String key;
            String albumId = this.getString(imagePrefix + "/Album", null);
            if (this.albumAttributesAreInvalid(albumId, key = this.getString(imagePrefix + "/Key", null), title = this.getString(imagePrefix + "/Title", null), description = this.getString(imagePrefix + "/Description", null), creationTime = this.getLong(imagePrefix + "/CreationTime", null), width = this.getInt(imagePrefix + "/Width", null), height = this.getInt(imagePrefix + "/Height", null))) {
                throw new InvalidImageFound();
            }
            Album album = this.albums.get(albumId);
            if (album == null) {
                throw new InvalidParentAlbumFound(albumId);
            }
            Image image = imageBuilderFactory.newImageBuilder().withId(imageId).build().modify().setSone(this.sone).setCreationTime(creationTime).setKey(key).setTitle(title).setDescription(description).setWidth(width).setHeight(height).update();
            album.addImage(image);
            this.images.put(image.getId(), image);
        }
    }

    public Map<String, Image> getImages() {
        return this.images;
    }

    private boolean albumAttributesAreInvalid(String albumId, String key, String title, String description, Long creationTime, Integer width, Integer height) {
        return albumId == null || key == null || title == null || description == null || creationTime == null || width == null || height == null;
    }

    public static class InvalidImageFound
    extends RuntimeException {
    }

    public static class InvalidParentAlbumFound
    extends RuntimeException {
        private final String albumParentId;

        public InvalidParentAlbumFound(String albumParentId) {
            this.albumParentId = albumParentId;
        }

        public String getAlbumParentId() {
            return this.albumParentId;
        }
    }

    public static class InvalidAlbumFound
    extends RuntimeException {
    }

    public static class InvalidPostReplyFound
    extends RuntimeException {
    }

    public static class InvalidPostFound
    extends RuntimeException {
    }
}

