/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function1;
import net.pterodactylus.sone.core.ConfigurationSoneParser;
import net.pterodactylus.sone.core.FreenetInterface;
import net.pterodactylus.sone.core.ImageInserter;
import net.pterodactylus.sone.core.Preferences;
import net.pterodactylus.sone.core.PreferencesLoader;
import net.pterodactylus.sone.core.SoneComparison;
import net.pterodactylus.sone.core.SoneDownloader;
import net.pterodactylus.sone.core.SoneInserter;
import net.pterodactylus.sone.core.SoneRescuer;
import net.pterodactylus.sone.core.SoneUriCreator;
import net.pterodactylus.sone.core.UpdateChecker;
import net.pterodactylus.sone.core.WebOfTrustUpdater;
import net.pterodactylus.sone.core.event.DebugActivatedEvent;
import net.pterodactylus.sone.core.event.ImageInsertFinishedEvent;
import net.pterodactylus.sone.core.event.InsertionDelayChangedEvent;
import net.pterodactylus.sone.core.event.MarkPostKnownEvent;
import net.pterodactylus.sone.core.event.MarkPostReplyKnownEvent;
import net.pterodactylus.sone.core.event.MarkSoneKnownEvent;
import net.pterodactylus.sone.core.event.NewPostFoundEvent;
import net.pterodactylus.sone.core.event.NewPostReplyFoundEvent;
import net.pterodactylus.sone.core.event.NewSoneFoundEvent;
import net.pterodactylus.sone.core.event.PostRemovedEvent;
import net.pterodactylus.sone.core.event.PostReplyRemovedEvent;
import net.pterodactylus.sone.core.event.SoneLockedEvent;
import net.pterodactylus.sone.core.event.SoneLockedOnStartup;
import net.pterodactylus.sone.core.event.SoneRemovedEvent;
import net.pterodactylus.sone.core.event.SoneUnlockedEvent;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.AlbumKt;
import net.pterodactylus.sone.data.Client;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Profile;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneKt;
import net.pterodactylus.sone.data.SoneOptions;
import net.pterodactylus.sone.data.TemporaryImage;
import net.pterodactylus.sone.database.AlbumBuilder;
import net.pterodactylus.sone.database.Database;
import net.pterodactylus.sone.database.DatabaseException;
import net.pterodactylus.sone.database.ImageBuilder;
import net.pterodactylus.sone.database.PostBuilder;
import net.pterodactylus.sone.database.PostProvider;
import net.pterodactylus.sone.database.PostReplyBuilder;
import net.pterodactylus.sone.database.PostReplyProvider;
import net.pterodactylus.sone.database.SoneBuilder;
import net.pterodactylus.sone.database.SoneProvider;
import net.pterodactylus.sone.freenet.wot.Identity;
import net.pterodactylus.sone.freenet.wot.IdentityManager;
import net.pterodactylus.sone.freenet.wot.OwnIdentity;
import net.pterodactylus.sone.freenet.wot.event.IdentityAddedEvent;
import net.pterodactylus.sone.freenet.wot.event.IdentityRemovedEvent;
import net.pterodactylus.sone.freenet.wot.event.IdentityUpdatedEvent;
import net.pterodactylus.sone.freenet.wot.event.OwnIdentityAddedEvent;
import net.pterodactylus.sone.freenet.wot.event.OwnIdentityRemovedEvent;
import net.pterodactylus.sone.main.SonePlugin;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.service.AbstractService;
import net.pterodactylus.util.thread.NamedThreadFactory;

@Singleton
public class Core
extends AbstractService
implements SoneProvider,
PostProvider,
PostReplyProvider {
    private static final Logger logger = Logger.getLogger(Core.class.getName());
    private final long startupTime = System.currentTimeMillis();
    private final AtomicBoolean debug = new AtomicBoolean(false);
    private final Preferences preferences;
    private final EventBus eventBus;
    private final Configuration configuration;
    private boolean storingConfiguration = false;
    private final IdentityManager identityManager;
    private final FreenetInterface freenetInterface;
    private final SoneDownloader soneDownloader;
    private final ImageInserter imageInserter;
    private final ExecutorService soneDownloaders = Executors.newFixedThreadPool(10, new NamedThreadFactory("Sone Downloader %2$d"));
    private final UpdateChecker updateChecker;
    private final WebOfTrustUpdater webOfTrustUpdater;
    private final Set<Sone> lockedSones = new HashSet<Sone>();
    private final Map<Sone, SoneInserter> soneInserters = new HashMap<Sone, SoneInserter>();
    private final Map<Sone, SoneRescuer> soneRescuers = new HashMap<Sone, SoneRescuer>();
    private final Set<String> knownSones = new HashSet<String>();
    private final Database database;
    private final Multimap<OwnIdentity, Identity> trustedIdentities = Multimaps.synchronizedSetMultimap(HashMultimap.create());
    private final Map<String, TemporaryImage> temporaryImages = new HashMap<String, TemporaryImage>();
    private final ScheduledExecutorService localElementTicker = Executors.newScheduledThreadPool(1);
    private volatile long lastConfigurationUpdate;
    private final MetricRegistry metricRegistry;
    private final Histogram configurationSaveTimeHistogram;
    private final SoneUriCreator soneUriCreator;

    @Inject
    public Core(Configuration configuration, FreenetInterface freenetInterface, IdentityManager identityManager, SoneDownloader soneDownloader, ImageInserter imageInserter, UpdateChecker updateChecker, WebOfTrustUpdater webOfTrustUpdater, EventBus eventBus, Database database, MetricRegistry metricRegistry, SoneUriCreator soneUriCreator) {
        super("Sone Core");
        this.configuration = configuration;
        this.freenetInterface = freenetInterface;
        this.identityManager = identityManager;
        this.soneDownloader = soneDownloader;
        this.imageInserter = imageInserter;
        this.updateChecker = updateChecker;
        this.webOfTrustUpdater = webOfTrustUpdater;
        this.eventBus = eventBus;
        this.database = database;
        this.metricRegistry = metricRegistry;
        this.soneUriCreator = soneUriCreator;
        this.preferences = new Preferences(eventBus);
        this.configurationSaveTimeHistogram = metricRegistry.histogram("configuration.save.duration", () -> new Histogram(new ExponentiallyDecayingReservoir(3000, 0.0)));
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    @Nonnull
    public boolean getDebug() {
        return this.debug.get();
    }

    public void setDebug() {
        this.debug.set(true);
        this.eventBus.post(new DebugActivatedEvent());
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoneRescuer getSoneRescuer(Sone sone) {
        Preconditions.checkNotNull(sone, "sone must not be null");
        Preconditions.checkArgument(sone.isLocal(), "sone must be local");
        Map<Sone, SoneRescuer> map2 = this.soneRescuers;
        synchronized (map2) {
            SoneRescuer soneRescuer = this.soneRescuers.get(sone);
            if (soneRescuer == null) {
                soneRescuer = new SoneRescuer(this, this.soneDownloader, sone);
                this.soneRescuers.put(sone, soneRescuer);
                soneRescuer.start();
            }
            return soneRescuer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(Sone sone) {
        Set<Sone> set = this.lockedSones;
        synchronized (set) {
            return this.lockedSones.contains(sone);
        }
    }

    public SoneBuilder soneBuilder() {
        return this.database.newSoneBuilder();
    }

    @Override
    @Nonnull
    public Collection<Sone> getSones() {
        return this.database.getSones();
    }

    @Override
    @Nonnull
    public Function1<String, Sone> getSoneLoader() {
        return this.database.getSoneLoader();
    }

    @Override
    @Nullable
    public Sone getSone(@Nonnull String id) {
        return this.database.getSone(id);
    }

    @Override
    public Collection<Sone> getLocalSones() {
        return this.database.getLocalSones();
    }

    public Sone getLocalSone(String id) {
        Sone sone = this.database.getSone(id);
        if (sone != null && sone.isLocal()) {
            return sone;
        }
        return null;
    }

    @Override
    public Collection<Sone> getRemoteSones() {
        return this.database.getRemoteSones();
    }

    public Sone getRemoteSone(String id) {
        return this.database.getSone(id);
    }

    public boolean isModifiedSone(Sone sone) {
        return this.soneInserters.containsKey(sone) && this.soneInserters.get(sone).isModified();
    }

    public PostBuilder postBuilder() {
        return this.database.newPostBuilder();
    }

    @Override
    @Nullable
    public Post getPost(@Nonnull String postId) {
        return this.database.getPost(postId);
    }

    @Override
    public Collection<Post> getPosts(String soneId2) {
        return this.database.getPosts(soneId2);
    }

    @Override
    public Collection<Post> getDirectedPosts(String recipientId) {
        Preconditions.checkNotNull(recipientId, "recipient must not be null");
        return this.database.getDirectedPosts(recipientId);
    }

    public PostReplyBuilder postReplyBuilder() {
        return this.database.newPostReplyBuilder();
    }

    @Override
    @Nullable
    public PostReply getPostReply(String replyId) {
        return this.database.getPostReply(replyId);
    }

    @Override
    public List<PostReply> getReplies(String postId) {
        return this.database.getReplies(postId);
    }

    public Set<Sone> getLikes(Post post) {
        HashSet<Sone> sones = new HashSet<Sone>();
        for (Sone sone : this.getSones()) {
            if (!sone.getLikedPostIds().contains(post.getId())) continue;
            sones.add(sone);
        }
        return sones;
    }

    public Set<Sone> getLikes(PostReply reply) {
        HashSet<Sone> sones = new HashSet<Sone>();
        for (Sone sone : this.getSones()) {
            if (!sone.getLikedReplyIds().contains(reply.getId())) continue;
            sones.add(sone);
        }
        return sones;
    }

    public boolean isBookmarked(Post post) {
        return this.database.isPostBookmarked(post);
    }

    public Set<Post> getBookmarkedPosts() {
        return this.database.getBookmarkedPosts();
    }

    public AlbumBuilder albumBuilder() {
        return this.database.newAlbumBuilder();
    }

    @Nullable
    public Album getAlbum(@Nonnull String albumId) {
        return this.database.getAlbum(albumId);
    }

    public ImageBuilder imageBuilder() {
        return this.database.newImageBuilder();
    }

    @Nullable
    public Image getImage(String imageId) {
        return this.getImage(imageId, true);
    }

    @Nullable
    public Image getImage(String imageId, boolean create) {
        Image image = this.database.getImage(imageId);
        if (image != null) {
            return image;
        }
        if (!create) {
            return null;
        }
        Image newImage = this.database.newImageBuilder().withId(imageId).build();
        this.database.storeImage(newImage);
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryImage getTemporaryImage(String imageId) {
        Map<String, TemporaryImage> map2 = this.temporaryImages;
        synchronized (map2) {
            return this.temporaryImages.get(imageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockSone(Sone sone) {
        Set<Sone> set = this.lockedSones;
        synchronized (set) {
            if (this.lockedSones.add(sone)) {
                this.eventBus.post(new SoneLockedEvent(sone));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockSone(Sone sone) {
        Set<Sone> set = this.lockedSones;
        synchronized (set) {
            if (this.lockedSones.remove(sone)) {
                this.eventBus.post(new SoneUnlockedEvent(sone));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sone addLocalSone(OwnIdentity ownIdentity) {
        if (ownIdentity == null) {
            logger.log(Level.WARNING, "Given OwnIdentity is null!");
            return null;
        }
        logger.info(String.format("Adding Sone from OwnIdentity: %s", ownIdentity));
        Sone sone = this.database.newSoneBuilder().local().from(ownIdentity).build();
        String property = Optional.fromNullable(ownIdentity.getProperty("Sone.LatestEdition")).or("0");
        sone.setLatestEdition(Optional.fromNullable(Longs.tryParse(property)).or(0L));
        sone.setClient(new Client("Sone", SonePlugin.getPluginVersion()));
        sone.setKnown(true);
        SoneInserter soneInserter = new SoneInserter(this, this.eventBus, this.freenetInterface, this.metricRegistry, this.soneUriCreator, ownIdentity.getId());
        soneInserter.insertionDelayChanged(new InsertionDelayChangedEvent(this.preferences.getInsertionDelay()));
        this.eventBus.register(soneInserter);
        Map<Sone, SoneInserter> map2 = this.soneInserters;
        synchronized (map2) {
            this.soneInserters.put(sone, soneInserter);
        }
        this.loadSone(sone);
        this.database.storeSone(sone);
        sone.setStatus(Sone.SoneStatus.idle);
        if (sone.getPosts().isEmpty() && sone.getReplies().isEmpty() && AlbumKt.getAllImages(sone.getRootAlbum()).isEmpty()) {
            this.lockSone(sone);
            this.eventBus.post(new SoneLockedOnStartup(sone));
        }
        soneInserter.start();
        return sone;
    }

    public Sone createSone(OwnIdentity ownIdentity) {
        if (!this.webOfTrustUpdater.addContextWait(ownIdentity, "Sone")) {
            logger.log(Level.SEVERE, String.format("Could not add \u201cSone\u201d context to own identity: %s", ownIdentity));
            return null;
        }
        Sone sone = this.addLocalSone(ownIdentity);
        this.followSone(sone, "nwa8lHa271k2QvJ8aa0Ov7IHAV-DFOCFgmDt3X6BpCI");
        this.touchConfiguration();
        return sone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sone addRemoteSone(Identity identity) {
        if (identity == null) {
            logger.log(Level.WARNING, "Given Identity is null!");
            return null;
        }
        String property = Optional.fromNullable(identity.getProperty("Sone.LatestEdition")).or("0");
        long latestEdition = Optional.fromNullable(Longs.tryParse(property)).or(0L);
        Sone existingSone = this.getSone(identity.getId());
        if (existingSone != null && existingSone.isLocal()) {
            return existingSone;
        }
        boolean newSone = existingSone == null;
        Sone sone = !newSone ? existingSone : this.database.newSoneBuilder().from(identity).build();
        sone.setLatestEdition(latestEdition);
        if (newSone) {
            Set<String> set = this.knownSones;
            synchronized (set) {
                newSone = !this.knownSones.contains(sone.getId());
            }
            sone.setKnown(!newSone);
            if (newSone) {
                this.eventBus.post(new NewSoneFoundEvent(sone));
                for (Sone localSone : this.getLocalSones()) {
                    if (!localSone.getOptions().isAutoFollow()) continue;
                    this.followSone(localSone, sone.getId());
                }
            }
        }
        this.database.storeSone(sone);
        this.soneDownloader.addSone(sone);
        this.soneDownloaders.execute(this.soneDownloader.fetchSoneAsUskAction(sone));
        return sone;
    }

    public void followSone(Sone sone, String soneId2) {
        Preconditions.checkNotNull(sone, "sone must not be null");
        Preconditions.checkNotNull(soneId2, "soneId must not be null");
        this.database.addFriend(sone, soneId2);
        long now = this.database.getFollowingTime(soneId2);
        Sone followedSone = this.getSone(soneId2);
        if (followedSone == null) {
            return;
        }
        for (Post post : followedSone.getPosts()) {
            if (post.getTime() >= now) continue;
            this.markPostKnown(post);
        }
        for (PostReply reply : followedSone.getReplies()) {
            if (reply.getTime() >= now) continue;
            this.markReplyKnown(reply);
        }
        this.touchConfiguration();
    }

    public void unfollowSone(Sone sone, String soneId2) {
        Preconditions.checkNotNull(sone, "sone must not be null");
        Preconditions.checkNotNull(soneId2, "soneId must not be null");
        this.database.removeFriend(sone, soneId2);
        this.touchConfiguration();
    }

    public void updateSone(Sone sone) {
        this.updateSone(sone, false);
    }

    public void updateSone(Sone sone, boolean soneRescueMode) {
        Sone storedSone = this.getSone(sone.getId());
        if (storedSone != null) {
            if (!soneRescueMode && sone.getTime() <= storedSone.getTime()) {
                logger.log(Level.FINE, String.format("Downloaded Sone %s is not newer than stored Sone %s.", sone, storedSone));
                return;
            }
            List<Object> events = this.collectEventsForChangesInSone(storedSone, sone);
            this.database.storeSone(sone);
            for (Object event : events) {
                this.eventBus.post(event);
            }
            sone.setOptions(storedSone.getOptions());
            sone.setKnown(storedSone.isKnown());
            sone.setStatus(sone.getTime() == 0L ? Sone.SoneStatus.unknown : Sone.SoneStatus.idle);
            if (sone.isLocal()) {
                this.touchConfiguration();
            }
        }
    }

    private List<Object> collectEventsForChangesInSone(Sone oldSone, Sone newSone) {
        ArrayList<Object> events = new ArrayList<Object>();
        SoneComparison soneComparison = new SoneComparison(oldSone, newSone);
        for (Post newPost : soneComparison.getNewPosts()) {
            if (newPost.getSone().equals(newSone)) {
                newPost.setKnown(true);
                continue;
            }
            if (newPost.getTime() < this.database.getFollowingTime(newSone.getId())) {
                newPost.setKnown(true);
                continue;
            }
            if (newPost.isKnown()) continue;
            events.add(new NewPostFoundEvent(newPost));
        }
        for (Post post : soneComparison.getRemovedPosts()) {
            events.add(new PostRemovedEvent(post));
        }
        for (PostReply postReply : soneComparison.getNewPostReplies()) {
            if (postReply.getSone().equals(newSone)) {
                this.database.setPostReplyKnown(postReply);
                continue;
            }
            if (postReply.getTime() < this.database.getFollowingTime(newSone.getId())) {
                this.database.setPostReplyKnown(postReply);
                continue;
            }
            if (postReply.isKnown()) continue;
            events.add(new NewPostReplyFoundEvent(postReply));
        }
        for (PostReply postReply : soneComparison.getRemovedPostReplies()) {
            events.add(new PostReplyRemovedEvent(postReply));
        }
        return events;
    }

    public void deleteSone(Sone sone) {
        if (!(sone.getIdentity() instanceof OwnIdentity)) {
            logger.log(Level.WARNING, String.format("Tried to delete Sone of non-own identity: %s", sone));
            return;
        }
        if (!this.getLocalSones().contains(sone)) {
            logger.log(Level.WARNING, String.format("Tried to delete non-local Sone: %s", sone));
            return;
        }
        SoneInserter soneInserter = this.soneInserters.remove(sone);
        soneInserter.stop();
        this.database.removeSone(sone);
        this.webOfTrustUpdater.removeContext((OwnIdentity)sone.getIdentity(), "Sone");
        this.webOfTrustUpdater.removeProperty((OwnIdentity)sone.getIdentity(), "Sone.LatestEdition");
        try {
            this.configuration.getLongValue("Sone/" + sone.getId() + "/Time").setValue(null);
        }
        catch (ConfigurationException ce1) {
            logger.log(Level.WARNING, "Could not remove Sone from configuration!", ce1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSoneKnown(Sone sone) {
        if (!sone.isKnown()) {
            sone.setKnown(true);
            Set<String> set = this.knownSones;
            synchronized (set) {
                this.knownSones.add(sone.getId());
            }
            this.eventBus.post(new MarkSoneKnownEvent(sone));
            this.touchConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSone(Sone sone) {
        List<Album> topLevelAlbums;
        Set<PostReply> replies;
        Set<Post> posts;
        if (!sone.isLocal()) {
            logger.log(Level.FINE, String.format("Tried to load non-local Sone: %s", sone));
            return;
        }
        logger.info(String.format("Loading local Sone: %s", sone));
        String sonePrefix = "Sone/" + sone.getId();
        Long soneTime = this.configuration.getLongValue(sonePrefix + "/Time").getValue(null);
        if (soneTime == null) {
            logger.log(Level.INFO, "Could not load Sone because no Sone has been saved.");
            return;
        }
        String lastInsertFingerprint = this.configuration.getStringValue(sonePrefix + "/LastInsertFingerprint").getValue("");
        ConfigurationSoneParser configurationSoneParser = new ConfigurationSoneParser(this.configuration, sone);
        Profile profile = configurationSoneParser.parseProfile();
        try {
            posts = configurationSoneParser.parsePosts(this.database);
        }
        catch (ConfigurationSoneParser.InvalidPostFound ipf) {
            logger.log(Level.WARNING, "Invalid post found, aborting load!");
            return;
        }
        try {
            replies = configurationSoneParser.parsePostReplies(this.database);
        }
        catch (ConfigurationSoneParser.InvalidPostReplyFound iprf) {
            logger.log(Level.WARNING, "Invalid reply found, aborting load!");
            return;
        }
        Set<String> likedPostIds = configurationSoneParser.parseLikedPostIds();
        Set<String> likedReplyIds = configurationSoneParser.parseLikedPostReplyIds();
        try {
            topLevelAlbums = configurationSoneParser.parseTopLevelAlbums(this.database);
        }
        catch (ConfigurationSoneParser.InvalidAlbumFound iaf) {
            logger.log(Level.WARNING, "Invalid album found, aborting load!");
            return;
        }
        catch (ConfigurationSoneParser.InvalidParentAlbumFound ipaf) {
            logger.log(Level.WARNING, String.format("Invalid parent album ID: %s", ipaf.getAlbumParentId()));
            return;
        }
        try {
            configurationSoneParser.parseImages(this.database);
        }
        catch (ConfigurationSoneParser.InvalidImageFound iif) {
            logger.log(Level.WARNING, "Invalid image found, aborting load!");
            return;
        }
        catch (ConfigurationSoneParser.InvalidParentAlbumFound ipaf) {
            logger.log(Level.WARNING, String.format("Invalid album image (%s) encountered, aborting load!", ipaf.getAlbumParentId()));
            return;
        }
        String avatarId = this.configuration.getStringValue(sonePrefix + "/Profile/Avatar").getValue(null);
        if (avatarId != null) {
            Map<String, Image> images = configurationSoneParser.getImages();
            profile.setAvatar(images.get(avatarId));
        }
        sone.getOptions().setAutoFollow(this.configuration.getBooleanValue(sonePrefix + "/Options/AutoFollow").getValue(false));
        sone.getOptions().setSoneInsertNotificationEnabled(this.configuration.getBooleanValue(sonePrefix + "/Options/EnableSoneInsertNotifications").getValue(false));
        sone.getOptions().setShowNewSoneNotifications(this.configuration.getBooleanValue(sonePrefix + "/Options/ShowNotification/NewSones").getValue(true));
        sone.getOptions().setShowNewPostNotifications(this.configuration.getBooleanValue(sonePrefix + "/Options/ShowNotification/NewPosts").getValue(true));
        sone.getOptions().setShowNewReplyNotifications(this.configuration.getBooleanValue(sonePrefix + "/Options/ShowNotification/NewReplies").getValue(true));
        sone.getOptions().setShowCustomAvatars(SoneOptions.LoadExternalContent.valueOf(this.configuration.getStringValue(sonePrefix + "/Options/ShowCustomAvatars").getValue(SoneOptions.LoadExternalContent.NEVER.name())));
        sone.getOptions().setLoadLinkedImages(SoneOptions.LoadExternalContent.valueOf(this.configuration.getStringValue(sonePrefix + "/Options/LoadLinkedImages").getValue(SoneOptions.LoadExternalContent.NEVER.name())));
        Iterator iterator2 = sone;
        synchronized (iterator2) {
            sone.setTime(soneTime);
            sone.setProfile(profile);
            sone.setPosts(posts);
            sone.setReplies(replies);
            sone.setLikePostIds(likedPostIds);
            sone.setLikeReplyIds(likedReplyIds);
            for (Album album : sone.getRootAlbum().getAlbums()) {
                sone.getRootAlbum().removeAlbum(album);
            }
            for (Album album : topLevelAlbums) {
                sone.getRootAlbum().addAlbum(album);
            }
            Map<Sone, SoneInserter> map2 = this.soneInserters;
            synchronized (map2) {
                this.soneInserters.get(sone).setLastInsertFingerprint(lastInsertFingerprint);
            }
        }
        for (Post post : posts) {
            post.setKnown(true);
        }
        for (PostReply reply : replies) {
            this.database.setPostReplyKnown(reply);
        }
        logger.info(String.format("Sone loaded successfully: %s", sone));
    }

    public Post createPost(Sone sone, @Nullable Sone recipient, String text) {
        Preconditions.checkNotNull(text, "text must not be null");
        Preconditions.checkArgument(text.trim().length() > 0, "text must not be empty");
        if (!sone.isLocal()) {
            logger.log(Level.FINE, String.format("Tried to create post for non-local Sone: %s", sone));
            return null;
        }
        PostBuilder postBuilder = this.database.newPostBuilder();
        postBuilder.from(sone.getId()).randomId().currentTime().withText(text.trim());
        if (recipient != null) {
            postBuilder.to(recipient.getId());
        }
        Post post = postBuilder.build();
        this.database.storePost(post);
        this.eventBus.post(new NewPostFoundEvent(post));
        sone.addPost(post);
        this.touchConfiguration();
        this.localElementTicker.schedule(new MarkPostKnown(post), 10L, TimeUnit.SECONDS);
        return post;
    }

    public void deletePost(Post post) {
        if (!post.getSone().isLocal()) {
            logger.log(Level.WARNING, String.format("Tried to delete post of non-local Sone: %s", post.getSone()));
            return;
        }
        this.database.removePost(post);
        this.eventBus.post(new PostRemovedEvent(post));
        this.markPostKnown(post);
        this.touchConfiguration();
    }

    public void markPostKnown(Post post) {
        post.setKnown(true);
        this.eventBus.post(new MarkPostKnownEvent(post));
        this.touchConfiguration();
        for (PostReply reply : this.getReplies(post.getId())) {
            this.markReplyKnown(reply);
        }
    }

    public void bookmarkPost(Post post) {
        this.database.bookmarkPost(post);
    }

    public void unbookmarkPost(Post post) {
        this.database.unbookmarkPost(post);
    }

    public PostReply createReply(Sone sone, Post post, String text) {
        Preconditions.checkNotNull(text, "text must not be null");
        Preconditions.checkArgument(text.trim().length() > 0, "text must not be empty");
        if (!sone.isLocal()) {
            logger.log(Level.FINE, String.format("Tried to create reply for non-local Sone: %s", sone));
            return null;
        }
        PostReplyBuilder postReplyBuilder = this.postReplyBuilder();
        ((PostReplyBuilder)((PostReplyBuilder)((PostReplyBuilder)postReplyBuilder.randomId()).from(sone.getId())).to(post.getId()).currentTime()).withText(text.trim());
        PostReply reply = postReplyBuilder.build();
        this.database.storePostReply(reply);
        this.eventBus.post(new NewPostReplyFoundEvent(reply));
        sone.addReply(reply);
        this.touchConfiguration();
        this.localElementTicker.schedule(new MarkReplyKnown(reply), 10L, TimeUnit.SECONDS);
        return reply;
    }

    public void deleteReply(PostReply reply) {
        Sone sone = reply.getSone();
        if (!sone.isLocal()) {
            logger.log(Level.FINE, String.format("Tried to delete non-local reply: %s", reply));
            return;
        }
        this.database.removePostReply(reply);
        this.markReplyKnown(reply);
        sone.removeReply(reply);
        this.touchConfiguration();
    }

    public void markReplyKnown(PostReply reply) {
        boolean previouslyKnown = reply.isKnown();
        this.database.setPostReplyKnown(reply);
        this.eventBus.post(new MarkPostReplyKnownEvent(reply));
        if (!previouslyKnown) {
            this.touchConfiguration();
        }
    }

    public Album createAlbum(Sone sone, Album parent) {
        Album album = this.database.newAlbumBuilder().randomId().by(sone).build();
        this.database.storeAlbum(album);
        parent.addAlbum(album);
        return album;
    }

    public void deleteAlbum(Album album) {
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkArgument(album.getSone().isLocal(), "album\u2019s Sone must be a local Sone");
        if (!album.isEmpty()) {
            return;
        }
        album.getParent().removeAlbum(album);
        this.database.removeAlbum(album);
        this.touchConfiguration();
    }

    public Image createImage(Sone sone, Album album, TemporaryImage temporaryImage) {
        Preconditions.checkNotNull(sone, "sone must not be null");
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkNotNull(temporaryImage, "temporaryImage must not be null");
        Preconditions.checkArgument(sone.isLocal(), "sone must be a local Sone");
        Preconditions.checkArgument(sone.equals(album.getSone()), "album must belong to the given Sone");
        Image image = this.database.newImageBuilder().withId(temporaryImage.getId()).build().modify().setSone(sone).setCreationTime(System.currentTimeMillis()).update();
        album.addImage(image);
        this.database.storeImage(image);
        this.imageInserter.insertImage(temporaryImage, image);
        return image;
    }

    public void deleteImage(Image image) {
        Preconditions.checkNotNull(image, "image must not be null");
        Preconditions.checkArgument(image.getSone().isLocal(), "image must belong to a local Sone");
        this.deleteTemporaryImage(image.getId());
        image.getAlbum().removeImage(image);
        this.database.removeImage(image);
        this.touchConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryImage createTemporaryImage(String mimeType, byte[] imageData) {
        TemporaryImage temporaryImage = new TemporaryImage();
        temporaryImage.setMimeType(mimeType).setImageData(imageData);
        Map<String, TemporaryImage> map2 = this.temporaryImages;
        synchronized (map2) {
            this.temporaryImages.put(temporaryImage.getId(), temporaryImage);
        }
        return temporaryImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryImage(String imageId) {
        Preconditions.checkNotNull(imageId, "imageId must not be null");
        Map<String, TemporaryImage> map2 = this.temporaryImages;
        synchronized (map2) {
            this.temporaryImages.remove(imageId);
        }
        Image image = this.getImage(imageId, false);
        if (image != null) {
            this.imageInserter.cancelImageInsert(image);
        }
    }

    public void touchConfiguration() {
        this.lastConfigurationUpdate = System.currentTimeMillis();
    }

    @Override
    public void serviceStart() {
        this.loadConfiguration();
        this.updateChecker.start();
        this.identityManager.start();
        this.webOfTrustUpdater.init();
        this.webOfTrustUpdater.start();
        this.database.startAsync();
    }

    @Override
    public void serviceRun() {
        long lastSaved = System.currentTimeMillis();
        while (!this.shouldStop()) {
            this.sleep(1000L);
            long now = System.currentTimeMillis();
            if (!this.shouldStop() && (this.lastConfigurationUpdate <= lastSaved || now - this.lastConfigurationUpdate <= 5000L)) continue;
            for (Sone localSone : this.getLocalSones()) {
                this.saveSone(localSone);
            }
            this.saveConfiguration();
            lastSaved = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceStop() {
        this.localElementTicker.shutdownNow();
        Map<Sone, AbstractService> map2 = this.soneInserters;
        synchronized (map2) {
            for (Map.Entry<Sone, SoneInserter> soneInserter : this.soneInserters.entrySet()) {
                soneInserter.getValue().stop();
                Sone latestSone = this.getLocalSone(soneInserter.getKey().getId());
                this.saveSone(latestSone);
            }
        }
        map2 = this.soneRescuers;
        synchronized (map2) {
            for (SoneRescuer soneRescuer : this.soneRescuers.values()) {
                soneRescuer.stop();
            }
        }
        this.saveConfiguration();
        this.database.stopAsync();
        this.webOfTrustUpdater.stop();
        this.updateChecker.stop();
        this.soneDownloader.stop();
        this.soneDownloaders.shutdown();
        this.identityManager.stop();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void saveSone(Sone sone) {
        if (!sone.isLocal()) {
            logger.log(Level.FINE, String.format("Tried to save non-local Sone: %s", sone));
            return;
        }
        if (!(sone.getIdentity() instanceof OwnIdentity)) {
            logger.log(Level.WARNING, String.format("Local Sone without OwnIdentity found, refusing to save: %s", sone));
            return;
        }
        logger.log(Level.INFO, String.format("Saving Sone: %s", sone));
        try {
            void var8_23;
            void var7_17;
            void var6_11;
            String sonePrefix = "Sone/" + sone.getId();
            this.configuration.getLongValue(sonePrefix + "/Time").setValue(sone.getTime());
            this.configuration.getStringValue(sonePrefix + "/LastInsertFingerprint").setValue(this.soneInserters.get(sone).getLastInsertFingerprint());
            Profile profile = sone.getProfile();
            this.configuration.getStringValue(sonePrefix + "/Profile/FirstName").setValue(profile.getFirstName());
            this.configuration.getStringValue(sonePrefix + "/Profile/MiddleName").setValue(profile.getMiddleName());
            this.configuration.getStringValue(sonePrefix + "/Profile/LastName").setValue(profile.getLastName());
            this.configuration.getIntValue(sonePrefix + "/Profile/BirthDay").setValue(profile.getBirthDay());
            this.configuration.getIntValue(sonePrefix + "/Profile/BirthMonth").setValue(profile.getBirthMonth());
            this.configuration.getIntValue(sonePrefix + "/Profile/BirthYear").setValue(profile.getBirthYear());
            this.configuration.getStringValue(sonePrefix + "/Profile/Avatar").setValue(profile.getAvatar());
            int fieldCounter = 0;
            for (Profile.Field field : profile.getFields()) {
                String string = sonePrefix + "/Profile/Fields/" + fieldCounter++;
                this.configuration.getStringValue(string + "/Name").setValue(field.getName());
                this.configuration.getStringValue(string + "/Value").setValue(field.getValue());
            }
            this.configuration.getStringValue(sonePrefix + "/Profile/Fields/" + fieldCounter + "/Name").setValue(null);
            int postCounter = 0;
            for (Post post : sone.getPosts()) {
                String string = sonePrefix + "/Posts/" + postCounter++;
                this.configuration.getStringValue(string + "/ID").setValue(post.getId());
                this.configuration.getStringValue(string + "/Recipient").setValue(post.getRecipientId().orNull());
                this.configuration.getLongValue(string + "/Time").setValue(post.getTime());
                this.configuration.getStringValue(string + "/Text").setValue(post.getText());
            }
            this.configuration.getStringValue(sonePrefix + "/Posts/" + postCounter + "/ID").setValue(null);
            boolean bl = false;
            for (PostReply postReply : sone.getReplies()) {
                String string = sonePrefix + "/Replies/" + (int)(++var6_11);
                this.configuration.getStringValue(string + "/ID").setValue(postReply.getId());
                this.configuration.getStringValue(string + "/Post/ID").setValue(postReply.getPostId());
                this.configuration.getLongValue(string + "/Time").setValue(postReply.getTime());
                this.configuration.getStringValue(string + "/Text").setValue(postReply.getText());
            }
            this.configuration.getStringValue(sonePrefix + "/Replies/" + (int)var6_11 + "/ID").setValue(null);
            boolean bl2 = false;
            for (String string : sone.getLikedPostIds()) {
                this.configuration.getStringValue(sonePrefix + "/Likes/Post/" + (int)(++var7_17) + "/ID").setValue(string);
            }
            this.configuration.getStringValue(sonePrefix + "/Likes/Post/" + (int)var7_17 + "/ID").setValue(null);
            boolean bl3 = false;
            for (String replyId : sone.getLikedReplyIds()) {
                this.configuration.getStringValue(sonePrefix + "/Likes/Reply/" + (int)(++var8_23) + "/ID").setValue(replyId);
            }
            this.configuration.getStringValue(sonePrefix + "/Likes/Reply/" + (int)var8_23 + "/ID").setValue(null);
            List<Album> list = SoneKt.getAllAlbums(sone);
            int albumCounter = 0;
            for (Album album : list) {
                String albumPrefix = sonePrefix + "/Albums/" + albumCounter++;
                this.configuration.getStringValue(albumPrefix + "/ID").setValue(album.getId());
                this.configuration.getStringValue(albumPrefix + "/Title").setValue(album.getTitle());
                this.configuration.getStringValue(albumPrefix + "/Description").setValue(album.getDescription());
                this.configuration.getStringValue(albumPrefix + "/Parent").setValue(album.getParent().equals(sone.getRootAlbum()) ? null : album.getParent().getId());
            }
            this.configuration.getStringValue(sonePrefix + "/Albums/" + albumCounter + "/ID").setValue(null);
            int imageCounter = 0;
            for (Album album : list) {
                for (Image image : album.getImages()) {
                    if (!image.isInserted()) continue;
                    String imagePrefix = sonePrefix + "/Images/" + imageCounter++;
                    this.configuration.getStringValue(imagePrefix + "/ID").setValue(image.getId());
                    this.configuration.getStringValue(imagePrefix + "/Album").setValue(album.getId());
                    this.configuration.getStringValue(imagePrefix + "/Key").setValue(image.getKey());
                    this.configuration.getStringValue(imagePrefix + "/Title").setValue(image.getTitle());
                    this.configuration.getStringValue(imagePrefix + "/Description").setValue(image.getDescription());
                    this.configuration.getLongValue(imagePrefix + "/CreationTime").setValue(image.getCreationTime());
                    this.configuration.getIntValue(imagePrefix + "/Width").setValue(image.getWidth());
                    this.configuration.getIntValue(imagePrefix + "/Height").setValue(image.getHeight());
                }
            }
            this.configuration.getStringValue(sonePrefix + "/Images/" + imageCounter + "/ID").setValue(null);
            this.configuration.getBooleanValue(sonePrefix + "/Options/AutoFollow").setValue(sone.getOptions().isAutoFollow());
            this.configuration.getBooleanValue(sonePrefix + "/Options/EnableSoneInsertNotifications").setValue(sone.getOptions().isSoneInsertNotificationEnabled());
            this.configuration.getBooleanValue(sonePrefix + "/Options/ShowNotification/NewSones").setValue(sone.getOptions().isShowNewSoneNotifications());
            this.configuration.getBooleanValue(sonePrefix + "/Options/ShowNotification/NewPosts").setValue(sone.getOptions().isShowNewPostNotifications());
            this.configuration.getBooleanValue(sonePrefix + "/Options/ShowNotification/NewReplies").setValue(sone.getOptions().isShowNewReplyNotifications());
            this.configuration.getStringValue(sonePrefix + "/Options/ShowCustomAvatars").setValue(sone.getOptions().getShowCustomAvatars().name());
            this.configuration.getStringValue(sonePrefix + "/Options/LoadLinkedImages").setValue(sone.getOptions().getLoadLinkedImages().name());
            this.webOfTrustUpdater.setProperty((OwnIdentity)sone.getIdentity(), "Sone.LatestEdition", String.valueOf(sone.getLatestEdition()));
            logger.log(Level.INFO, String.format("Sone %s saved.", sone));
        }
        catch (ConfigurationException ce1) {
            logger.log(Level.WARNING, String.format("Could not save Sone: %s", sone), ce1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfiguration() {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            if (this.storingConfiguration) {
                logger.log(Level.FINE, "Already storing configuration\u2026");
                return;
            }
            this.storingConfiguration = true;
        }
        try {
            this.preferences.saveTo(this.configuration);
            int soneCounter = 0;
            Set<String> set = this.knownSones;
            synchronized (set) {
                for (String knownSoneId : this.knownSones) {
                    this.configuration.getStringValue("KnownSone/" + soneCounter++ + "/ID").setValue(knownSoneId);
                }
                this.configuration.getStringValue("KnownSone/" + soneCounter + "/ID").setValue(null);
            }
            this.database.save();
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.configuration.save();
            this.configurationSaveTimeHistogram.update(stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        catch (ConfigurationException ce1) {
            logger.log(Level.SEVERE, "Could not store configuration!", ce1);
        }
        catch (DatabaseException de1) {
            logger.log(Level.SEVERE, "Could not save database!", de1);
        }
        finally {
            Configuration ce1 = this.configuration;
            synchronized (ce1) {
                this.storingConfiguration = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        String knownSoneId;
        new PreferencesLoader(this.preferences).loadFrom(this.configuration);
        int soneCounter = 0;
        while ((knownSoneId = (String)this.configuration.getStringValue("KnownSone/" + soneCounter++ + "/ID").getValue(null)) != null) {
            Set<String> set = this.knownSones;
            synchronized (set) {
                this.knownSones.add(knownSoneId);
            }
        }
    }

    @Subscribe
    public void ownIdentityAdded(OwnIdentityAddedEvent ownIdentityAddedEvent) {
        OwnIdentity ownIdentity = ownIdentityAddedEvent.getOwnIdentity();
        logger.log(Level.FINEST, String.format("Adding OwnIdentity: %s", ownIdentity));
        if (ownIdentity.hasContext("Sone")) {
            this.addLocalSone(ownIdentity);
        }
    }

    @Subscribe
    public void ownIdentityRemoved(OwnIdentityRemovedEvent ownIdentityRemovedEvent) {
        OwnIdentity ownIdentity = ownIdentityRemovedEvent.getOwnIdentity();
        logger.log(Level.FINEST, String.format("Removing OwnIdentity: %s", ownIdentity));
        this.trustedIdentities.removeAll(ownIdentity);
    }

    @Subscribe
    public void identityAdded(IdentityAddedEvent identityAddedEvent) {
        Identity identity = identityAddedEvent.getIdentity();
        logger.log(Level.FINEST, String.format("Adding Identity: %s", identity));
        this.trustedIdentities.put(identityAddedEvent.getOwnIdentity(), identity);
        this.addRemoteSone(identity);
    }

    @Subscribe
    public void identityUpdated(IdentityUpdatedEvent identityUpdatedEvent) {
        Long parsedNewLatestEdition;
        Identity identity = identityUpdatedEvent.getIdentity();
        Sone sone = this.getRemoteSone(identity.getId());
        if (sone.isLocal()) {
            return;
        }
        String newLatestEdition = identity.getProperty("Sone.LatestEdition");
        if (newLatestEdition != null && (parsedNewLatestEdition = Longs.tryParse(newLatestEdition)) != null) {
            sone.setLatestEdition(parsedNewLatestEdition);
        }
        this.soneDownloader.addSone(sone);
        this.soneDownloaders.execute(this.soneDownloader.fetchSoneAsSskAction(sone));
    }

    @Subscribe
    public void identityRemoved(IdentityRemovedEvent identityRemovedEvent) {
        OwnIdentity ownIdentity = identityRemovedEvent.getOwnIdentity();
        Identity identity = identityRemovedEvent.getIdentity();
        this.trustedIdentities.remove(ownIdentity, identity);
        for (Map.Entry<OwnIdentity, Collection<Identity>> trustedIdentity : this.trustedIdentities.asMap().entrySet()) {
            if (trustedIdentity.getKey().equals(ownIdentity) || !trustedIdentity.getValue().contains(identity)) continue;
            return;
        }
        Sone sone = this.getSone(identity.getId());
        if (sone == null) {
            return;
        }
        for (PostReply postReply : sone.getReplies()) {
            this.eventBus.post(new PostReplyRemovedEvent(postReply));
        }
        for (Post post : sone.getPosts()) {
            this.eventBus.post(new PostRemovedEvent(post));
        }
        this.eventBus.post(new SoneRemovedEvent(sone));
        this.database.removeSone(sone);
    }

    @Subscribe
    public void imageInsertFinished(ImageInsertFinishedEvent imageInsertFinishedEvent) {
        logger.log(Level.WARNING, String.format("Image insert finished for %s: %s", imageInsertFinishedEvent.getImage(), imageInsertFinishedEvent.getResultingUri()));
        imageInsertFinishedEvent.getImage().modify().setKey(imageInsertFinishedEvent.getResultingUri().toString()).update();
        this.deleteTemporaryImage(imageInsertFinishedEvent.getImage().getId());
        this.touchConfiguration();
    }

    @VisibleForTesting
    class MarkReplyKnown
    implements Runnable {
        private final PostReply postReply;

        public MarkReplyKnown(PostReply postReply) {
            this.postReply = postReply;
        }

        @Override
        public void run() {
            Core.this.markReplyKnown(this.postReply);
        }
    }

    @VisibleForTesting
    class MarkPostKnown
    implements Runnable {
        private final Post post;

        public MarkPostKnown(Post post) {
            this.post = post;
        }

        @Override
        public void run() {
            Core.this.markPostKnown(this.post);
        }
    }
}

