/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import freenet.keys.FreenetURI;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.activation.MimeType;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.core.DefaultElementLoader;
import net.pterodactylus.sone.core.ElementLoader;
import net.pterodactylus.sone.core.FreenetInterface;
import net.pterodactylus.sone.core.LinkedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\t\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\f\u0010\u0014\u001a\u00020\r*\u00020\rH\u0002J\f\u0010\u0015\u001a\u00020\r*\u00020\rH\u0002R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/pterodactylus/sone/core/DefaultElementLoader;", "Lnet/pterodactylus/sone/core/ElementLoader;", "freenetInterface", "Lnet/pterodactylus/sone/core/FreenetInterface;", "(Lnet/pterodactylus/sone/core/FreenetInterface;)V", "ticker", "Lcom/google/common/base/Ticker;", "(Lnet/pterodactylus/sone/core/FreenetInterface;Lcom/google/common/base/Ticker;)V", "callback", "net/pterodactylus/sone/core/DefaultElementLoader$callback$1", "Lnet/pterodactylus/sone/core/DefaultElementLoader$callback$1;", "elementCache", "Lcom/google/common/cache/Cache;", "", "Lnet/pterodactylus/sone/core/LinkedElement;", "failureCache", "", "loadingLinks", "loadElement", "link", "decode", "normalize", "Sone"})
public final class DefaultElementLoader
implements ElementLoader {
    private final Cache<String, Boolean> loadingLinks;
    private final Cache<String, Boolean> failureCache;
    private final Cache<String, LinkedElement> elementCache;
    private final callback.1 callback;
    private final FreenetInterface freenetInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LinkedElement loadElement(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull(link, "link");
        String normalizedLink = this.normalize(this.decode(link));
        Cache<String, Boolean> cache = this.loadingLinks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (cache) {
            block7: {
                block6: {
                    boolean bl3 = false;
                    LinkedElement linkedElement = this.elementCache.getIfPresent(normalizedLink);
                    if (linkedElement == null) break block6;
                    LinkedElement linkedElement2 = linkedElement;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    LinkedElement $this$run = linkedElement2;
                    boolean bl6 = false;
                    LinkedElement linkedElement3 = $this$run;
                    Intrinsics.checkExpressionValueIsNotNull(linkedElement3, "this");
                    LinkedElement linkedElement4 = linkedElement3;
                    return linkedElement4;
                }
                Boolean bl7 = this.failureCache.getIfPresent(normalizedLink);
                if (bl7 == null) break block7;
                Boolean bl8 = bl7;
                boolean bl9 = false;
                boolean bl10 = false;
                Boolean $this$run = bl8;
                boolean bl11 = false;
                LinkedElement linkedElement = new LinkedElement(link, true, false, null, 12, null);
                return linkedElement;
            }
            if (this.loadingLinks.getIfPresent(normalizedLink) == null) {
                this.loadingLinks.put(normalizedLink, true);
                this.freenetInterface.startFetch(new FreenetURI(link), this.callback);
            }
            Unit unit = Unit.INSTANCE;
        }
        return new LinkedElement(link, false, true, null, 10, null);
    }

    private final String decode(@NotNull String $this$decode) {
        String string = URLDecoder.decode($this$decode, "UTF-8");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final String normalize(@NotNull String $this$normalize) {
        String string = Normalizer.normalize($this$normalize, Normalizer.Form.NFC);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public DefaultElementLoader(@NotNull FreenetInterface freenetInterface, @NotNull Ticker ticker2) {
        Intrinsics.checkParameterIsNotNull(freenetInterface, "freenetInterface");
        Intrinsics.checkParameterIsNotNull(ticker2, "ticker");
        this.freenetInterface = freenetInterface;
        Cache cache = CacheBuilder.newBuilder().build();
        Intrinsics.checkExpressionValueIsNotNull(cache, "CacheBuilder.newBuilder().build()");
        this.loadingLinks = cache;
        Cache cache2 = CacheBuilder.newBuilder().ticker(ticker2).expireAfterWrite(30L, TimeUnit.MINUTES).build();
        Intrinsics.checkExpressionValueIsNotNull(cache2, "CacheBuilder.newBuilder(\u2026rite(30, MINUTES).build()");
        this.failureCache = cache2;
        Cache cache3 = CacheBuilder.newBuilder().build();
        Intrinsics.checkExpressionValueIsNotNull(cache3, "CacheBuilder.newBuilder().build()");
        this.elementCache = cache3;
        this.callback = new FreenetInterface.BackgroundFetchCallback(this){
            final /* synthetic */ DefaultElementLoader this$0;

            public boolean shouldCancel(@NotNull FreenetURI uri, @NotNull String mimeType, long size) {
                Intrinsics.checkParameterIsNotNull(uri, "uri");
                Intrinsics.checkParameterIsNotNull(mimeType, "mimeType");
                return size > (long)0x200000 || !StringsKt.startsWith$default(mimeType, "image/", false, 2, null) && !StringsKt.startsWith$default(mimeType, "text/html", false, 2, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void loaded(@NotNull FreenetURI uri, @NotNull String mimeTypeText, @NotNull byte[] data) {
                Intrinsics.checkParameterIsNotNull(uri, "uri");
                Intrinsics.checkParameterIsNotNull(mimeTypeText, "mimeTypeText");
                Intrinsics.checkParameterIsNotNull(data, "data");
                MimeType mimeType = new MimeType(mimeTypeText);
                boolean bl = false;
                boolean bl2 = false;
                MimeType mimeType2 = mimeType;
                boolean bl3 = false;
                if (Intrinsics.areEqual(mimeType2.getPrimaryType(), "image")) {
                    Object object;
                    Object it2;
                    Object object2 = new ByteArrayInputStream(data);
                    boolean bl4 = false;
                    Throwable throwable = null;
                    try {
                        it2 = (ByteArrayInputStream)object2;
                        boolean bl5 = false;
                        it2 = ImageIO.read((InputStream)it2);
                        object = it2;
                    }
                    catch (Throwable it2) {
                        throwable = it2;
                        throw it2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, throwable);
                    }
                    if (object != null) {
                        object2 = object;
                        bl4 = false;
                        boolean bl6 = false;
                        it2 = object2;
                        boolean bl7 = false;
                        Cache cache = DefaultElementLoader.access$getElementCache$p(this.this$0);
                        String string = uri.toString();
                        Intrinsics.checkExpressionValueIsNotNull(string, "uri.toString()");
                        LinkedElement cfr_ignored_0 = (LinkedElement)cache.get(DefaultElementLoader.access$normalize(this.this$0, DefaultElementLoader.access$decode(this.this$0, string)), (Callable)new Callable<LinkedElement>(this, data, uri){
                            final /* synthetic */ callback.1 this$0;
                            final /* synthetic */ byte[] $data$inlined;
                            final /* synthetic */ FreenetURI $uri$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$data$inlined = byArray;
                                this.$uri$inlined = freenetURI;
                            }

                            @NotNull
                            public final LinkedElement call() {
                                String string = this.$uri$inlined.toString();
                                Intrinsics.checkExpressionValueIsNotNull(string, "uri.toString()");
                                return new LinkedElement(string, false, false, MapsKt.mapOf(TuplesKt.to("type", "image"), TuplesKt.to("size", this.$data$inlined.length), TuplesKt.to("sizeHuman", callback.1.access$getHuman$p(this.this$0, this.$data$inlined.length))), 6, null);
                            }
                        });
                    }
                } else if (Intrinsics.areEqual(mimeType2.getBaseType(), "text/html")) {
                    byte[] byArray = data;
                    String string = mimeType2.getParameter("charset");
                    if (string == null) {
                        string = "UTF-8";
                    }
                    Charset charset = Charset.forName(string);
                    Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.forName(mimeType\u2026er(\"charset\") ?: \"UTF-8\")");
                    Charset charset2 = charset;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Document document = Jsoup.parse(new String(byArray, charset2));
                    Cache cache = DefaultElementLoader.access$getElementCache$p(this.this$0);
                    String string2 = uri.toString();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "uri.toString()");
                    cache.get(DefaultElementLoader.access$normalize(this.this$0, DefaultElementLoader.access$decode(this.this$0, string2)), (Callable)new Callable<LinkedElement>(document, this, data, uri){
                        final /* synthetic */ Document $document;
                        final /* synthetic */ callback.1 this$0;
                        final /* synthetic */ byte[] $data$inlined;
                        final /* synthetic */ FreenetURI $uri$inlined;
                        {
                            this.$document = document;
                            this.this$0 = var2_2;
                            this.$data$inlined = byArray;
                            this.$uri$inlined = freenetURI;
                        }

                        @NotNull
                        public final LinkedElement call() {
                            String string = this.$uri$inlined.toString();
                            Intrinsics.checkExpressionValueIsNotNull(string, "uri.toString()");
                            Pair[] pairArray = new Pair[5];
                            pairArray[0] = TuplesKt.to("type", "html");
                            pairArray[1] = TuplesKt.to("size", this.$data$inlined.length);
                            pairArray[2] = TuplesKt.to("sizeHuman", callback.1.access$getHuman$p(this.this$0, this.$data$inlined.length));
                            pairArray[3] = TuplesKt.to("title", callback.1.access$getEmptyToNull$p(this.this$0, this.$document.title()));
                            Document document = this.$document;
                            Intrinsics.checkExpressionValueIsNotNull(document, "document");
                            String string2 = callback.1.access$getMetaDescription$p(this.this$0, document);
                            if (string2 == null) {
                                Document document2 = this.$document;
                                Intrinsics.checkExpressionValueIsNotNull(document2, "document");
                                string2 = callback.1.access$getFirstNonHeadingParagraph$p(this.this$0, document2);
                            }
                            pairArray[4] = TuplesKt.to("description", string2);
                            return new LinkedElement(string, false, false, MapsKt.mapOf(pairArray), 6, null);
                        }
                    });
                }
                this.removeLoadingLink(uri);
            }

            private final String getEmptyToNull(@Nullable String $this$emptyToNull) {
                return Intrinsics.areEqual($this$emptyToNull, "") ? null : $this$emptyToNull;
            }

            /*
             * WARNING - void declaration
             */
            private final String getMetaDescription(@NotNull Document $this$metaDescription) {
                Object v1;
                block2: {
                    void $this$mapTo$iv$iv;
                    Elements elements = $this$metaDescription.head().getElementsByTag("meta");
                    Intrinsics.checkExpressionValueIsNotNull(elements, "head().getElementsByTag(\"meta\")");
                    Iterable $this$map$iv = elements;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Element element = (Element)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Pair<String, String> pair = TuplesKt.to(it.attr("name"), it.attr("content"));
                        collection.add(pair);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((String)it.getFirst(), "description")) continue;
                        v1 = element$iv;
                        break block2;
                    }
                    v1 = null;
                }
                Pair pair = v1;
                return pair != null ? (String)pair.getSecond() : null;
            }

            /*
             * WARNING - void declaration
             */
            private final String getFirstNonHeadingParagraph(@NotNull Document $this$firstNonHeadingParagraph) {
                Object v4;
                block8: {
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$mapTo$iv$iv;
                    Object it;
                    Iterable $this$filterTo$iv$iv;
                    Elements elements = $this$firstNonHeadingParagraph.body().children();
                    Intrinsics.checkExpressionValueIsNotNull(elements, "body().children()");
                    Iterable $this$filter$iv = elements;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        boolean bl;
                        block7: {
                            it = (Element)element$iv$iv;
                            boolean bl2 = false;
                            Elements elements2 = ((Element)it).children();
                            Intrinsics.checkExpressionValueIsNotNull(elements2, "it.children()");
                            Iterable $this$all$iv = elements2;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    Element it2 = (Element)element$iv;
                                    boolean bl3 = false;
                                    if (it2 instanceof TextNode) continue;
                                    bl = false;
                                    break block7;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Element)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Pair<Element, String> pair = TuplesKt.to(it, ((Element)it).text());
                        collection.add(pair);
                    }
                    Iterable $this$filterNot$iv = (List)destination$iv$iv;
                    boolean $i$f$filterNot = false;
                    $this$mapTo$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (Pair)element$iv$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((String)((Pair)it).getSecond(), "")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        Pair it3 = (Pair)element$iv;
                        boolean bl = false;
                        String string = ((Element)it3.getFirst()).tagName();
                        Intrinsics.checkExpressionValueIsNotNull(string, "it.first.tagName()");
                        if (!(!StringsKt.startsWith(string, "h", true))) continue;
                        v4 = element$iv;
                        break block8;
                    }
                    v4 = null;
                }
                Pair pair = v4;
                return pair != null ? (String)pair.getSecond() : null;
            }

            private final String getHuman(int $this$human) {
                int n = $this$human;
                int n2 = n;
                return 0 <= n2 && 1023 >= n2 ? $this$human + " B" : (1024 <= (n2 = n) && 1048575 >= n2 ? $this$human / 1024 + " KiB" : (0x100000 <= (n2 = n) && 0x3FFFFFFF >= n2 ? $this$human / 0x100000 + " MiB" : $this$human / 0x40000000 + " GiB"));
            }

            public void failed(@NotNull FreenetURI uri) {
                Intrinsics.checkParameterIsNotNull(uri, "uri");
                Cache cache = DefaultElementLoader.access$getFailureCache$p(this.this$0);
                String string = uri.toString();
                Intrinsics.checkExpressionValueIsNotNull(string, "uri.toString()");
                cache.put(DefaultElementLoader.access$normalize(this.this$0, DefaultElementLoader.access$decode(this.this$0, string)), true);
                this.removeLoadingLink(uri);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void removeLoadingLink(FreenetURI uri) {
                Cache cache = DefaultElementLoader.access$getLoadingLinks$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (cache) {
                    boolean bl3 = false;
                    Cache cache2 = DefaultElementLoader.access$getLoadingLinks$p(this.this$0);
                    String string = uri.toString();
                    Intrinsics.checkExpressionValueIsNotNull(string, "uri.toString()");
                    cache2.invalidate(DefaultElementLoader.access$normalize(this.this$0, DefaultElementLoader.access$decode(this.this$0, string)));
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = $outer;
            }

            public static final /* synthetic */ String access$getHuman$p(callback.1 $this, int $this$access_u24human_u24p) {
                return $this.getHuman($this$access_u24human_u24p);
            }

            public static final /* synthetic */ String access$getEmptyToNull$p(callback.1 $this, String $this$access_u24emptyToNull_u24p) {
                return $this.getEmptyToNull($this$access_u24emptyToNull_u24p);
            }

            public static final /* synthetic */ String access$getMetaDescription$p(callback.1 $this, Document $this$access_u24metaDescription_u24p) {
                return $this.getMetaDescription($this$access_u24metaDescription_u24p);
            }

            public static final /* synthetic */ String access$getFirstNonHeadingParagraph$p(callback.1 $this, Document $this$access_u24firstNonHeadingParagraph_u24p) {
                return $this.getFirstNonHeadingParagraph($this$access_u24firstNonHeadingParagraph_u24p);
            }
        };
    }

    @Inject
    public DefaultElementLoader(@NotNull FreenetInterface freenetInterface) {
        Intrinsics.checkParameterIsNotNull(freenetInterface, "freenetInterface");
        Ticker ticker2 = Ticker.systemTicker();
        Intrinsics.checkExpressionValueIsNotNull(ticker2, "Ticker.systemTicker()");
        this(freenetInterface, ticker2);
    }

    public static final /* synthetic */ Cache access$getElementCache$p(DefaultElementLoader $this) {
        return $this.elementCache;
    }

    public static final /* synthetic */ String access$normalize(DefaultElementLoader $this, String $this$access_u24normalize) {
        return $this.normalize($this$access_u24normalize);
    }

    public static final /* synthetic */ String access$decode(DefaultElementLoader $this, String $this$access_u24decode) {
        return $this.decode($this$access_u24decode);
    }

    public static final /* synthetic */ Cache access$getFailureCache$p(DefaultElementLoader $this) {
        return $this.failureCache;
    }

    public static final /* synthetic */ Cache access$getLoadingLinks$p(DefaultElementLoader $this) {
        return $this.loadingLinks;
    }
}

