/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.base.Function;
import com.google.common.eventbus.EventBus;
import com.google.inject.Singleton;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.SnoopMetadata;
import freenet.client.async.USKCallback;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.USK;
import freenet.node.Node;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.pterodactylus.sone.core.Fetched;
import net.pterodactylus.sone.core.SoneException;
import net.pterodactylus.sone.core.SoneInsertException;
import net.pterodactylus.sone.core.SoneUriCreator;
import net.pterodactylus.sone.core.event.ImageInsertAbortedEvent;
import net.pterodactylus.sone.core.event.ImageInsertFailedEvent;
import net.pterodactylus.sone.core.event.ImageInsertFinishedEvent;
import net.pterodactylus.sone.core.event.ImageInsertStartedEvent;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.TemporaryImage;
import net.pterodactylus.sone.freenet.FreenetURIsKt;

@Singleton
public class FreenetInterface {
    private static final Logger logger = Logger.getLogger(FreenetInterface.class.getName());
    private final EventBus eventBus;
    private final Node node;
    private final SoneUriCreator soneUriCreator;
    private final HighLevelSimpleClient client;
    private final RequestClient requestClient = new RequestClientBuilder().realTime().build();
    private final Map<String, USKCallback> soneUskCallbacks = new HashMap<String, USKCallback>();
    private final Map<FreenetURI, USKCallback> uriUskCallbacks = Collections.synchronizedMap(new HashMap());
    private final RequestClient imageInserts = new RequestClientBuilder().realTime().build();
    private final RequestClient imageLoader = new RequestClientBuilder().realTime().build();

    @Inject
    public FreenetInterface(EventBus eventBus, Node node, SoneUriCreator soneUriCreator) {
        this.eventBus = eventBus;
        this.node = node;
        this.soneUriCreator = soneUriCreator;
        this.client = node.clientCore.makeClient((short)1, false, true);
    }

    public Fetched fetchUri(FreenetURI uri) {
        FreenetURI currentUri2 = new FreenetURI(uri);
        while (true) {
            try {
                FetchResult fetchResult = this.client.fetch(currentUri2);
                return new Fetched(currentUri2, fetchResult);
            }
            catch (FetchException fe1) {
                if (fe1.getMode() == FetchException.FetchExceptionMode.PERMANENT_REDIRECT) {
                    currentUri2 = fe1.newURI;
                    continue;
                }
                logger.log(Level.WARNING, String.format("Could not fetch \u201c%s\u201d!", uri), fe1);
                return null;
            }
            break;
        }
    }

    public void startFetch(final FreenetURI uri, final BackgroundFetchCallback backgroundFetchCallback) {
        ClientGetCallback callback2 = new ClientGetCallback(){

            public void onSuccess(FetchResult result2, ClientGetter state) {
                try {
                    backgroundFetchCallback.loaded(uri, result2.getMimeType(), result2.asByteArray());
                }
                catch (IOException e) {
                    backgroundFetchCallback.failed(uri);
                }
            }

            public void onFailure(FetchException e, ClientGetter state) {
                backgroundFetchCallback.failed(uri);
            }

            public void onResume(ClientContext context) throws ResumeFailedException {
            }

            public RequestClient getRequestClient() {
                return FreenetInterface.this.imageLoader;
            }
        };
        SnoopMetadata snoop = new SnoopMetadata(){

            public boolean snoopMetadata(Metadata meta, ClientContext context) {
                boolean cancel;
                String mimeType = meta.getMIMEType();
                boolean bl = cancel = mimeType == null || backgroundFetchCallback.shouldCancel(uri, mimeType, meta.dataLength());
                if (cancel) {
                    backgroundFetchCallback.failed(uri);
                }
                return cancel;
            }
        };
        FetchContext fetchContext = this.client.getFetchContext();
        try {
            ClientGetter clientGetter = this.client.fetch(uri, 0x200000L, callback2, fetchContext, (short)1);
            clientGetter.setMetaSnoop(snoop);
            clientGetter.restart(uri, fetchContext.filterData, this.node.clientCore.clientContext);
        }
        catch (FetchException fetchException) {
            // empty catch block
        }
    }

    public void insertImage(TemporaryImage temporaryImage, Image image, InsertToken insertToken) throws SoneException {
        String filenameHint = image.getId() + "." + temporaryImage.getMimeType().substring(temporaryImage.getMimeType().lastIndexOf("/") + 1);
        InsertableClientSSK key = InsertableClientSSK.createRandom((RandomSource)this.node.random, (String)"");
        FreenetURI targetUri = key.getInsertURI().setDocName(filenameHint);
        InsertContext insertContext = this.client.getInsertContext(true);
        ArrayBucket bucket = new ArrayBucket(temporaryImage.getImageData());
        insertToken.setBucket((Bucket)bucket);
        ClientMetadata metadata = new ClientMetadata(temporaryImage.getMimeType());
        InsertBlock insertBlock = new InsertBlock((RandomAccessBucket)bucket, metadata, targetUri);
        try {
            ClientPutter clientPutter = this.client.insert(insertBlock, null, false, insertContext, (ClientPutCallback)insertToken, (short)1);
            insertToken.setClientPutter(clientPutter);
        }
        catch (InsertException ie1) {
            throw new SoneInsertException("Could not start image insert.", ie1);
        }
    }

    public FreenetURI insertDirectory(FreenetURI insertUri, HashMap<String, Object> manifestEntries, String defaultFile) throws SoneException {
        try {
            return this.client.insertManifest(insertUri, manifestEntries, defaultFile);
        }
        catch (InsertException ie1) {
            throw new SoneException(ie1);
        }
    }

    public void registerActiveUsk(FreenetURI requestUri, USKCallback uskCallback) {
        try {
            this.soneUskCallbacks.put(FreenetURIsKt.getRoutingKeyString(requestUri), uskCallback);
            this.node.clientCore.uskManager.subscribe(USK.create((FreenetURI)requestUri), uskCallback, true, this.requestClient);
        }
        catch (MalformedURLException mue1) {
            logger.log(Level.WARNING, String.format("Could not subscribe USK \u201c%s\u201d!", requestUri), mue1);
        }
    }

    public void registerPassiveUsk(FreenetURI requestUri, USKCallback uskCallback) {
        try {
            this.soneUskCallbacks.put(FreenetURIsKt.getRoutingKeyString(requestUri), uskCallback);
            this.node.clientCore.uskManager.subscribe(USK.create((FreenetURI)requestUri), uskCallback, false, this.requestClient);
        }
        catch (MalformedURLException mue1) {
            logger.log(Level.WARNING, String.format("Could not subscribe USK \u201c%s\u201d!", requestUri), mue1);
        }
    }

    public void unregisterUsk(Sone sone) {
        USKCallback uskCallback = this.soneUskCallbacks.remove(sone.getId());
        if (uskCallback == null) {
            return;
        }
        try {
            logger.log(Level.FINEST, String.format("Unsubscribing from USK for %s\u2026", sone));
            this.node.clientCore.uskManager.unsubscribe(USK.create((FreenetURI)this.soneUriCreator.getRequestUri(sone)), uskCallback);
        }
        catch (MalformedURLException mue1) {
            logger.log(Level.FINE, String.format("Could not unsubscribe USK \u201c%s\u201d!", this.soneUriCreator.getRequestUri(sone)), mue1);
        }
    }

    public void registerUsk(FreenetURI uri, final Callback callback2) {
        USKCallback uskCallback = new USKCallback(){

            public void onFoundEdition(long edition, USK key, ClientContext clientContext, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
                callback2.editionFound(key.getURI(), edition, newKnownGood, newSlotToo);
            }

            public short getPollingPriorityNormal() {
                return 5;
            }

            public short getPollingPriorityProgress() {
                return 1;
            }
        };
        try {
            this.node.clientCore.uskManager.subscribe(USK.create((FreenetURI)uri), uskCallback, true, this.requestClient);
            this.uriUskCallbacks.put(USK.create((FreenetURI)uri).clearCopy().getURI(), uskCallback);
        }
        catch (MalformedURLException mue1) {
            logger.log(Level.WARNING, String.format("Could not subscribe to USK: %s", uri), mue1);
        }
    }

    public void unregisterUsk(FreenetURI uri) {
        try {
            USKCallback uskCallback = this.uriUskCallbacks.remove(USK.create((FreenetURI)uri).clearCopy().getURI());
            if (uskCallback == null) {
                logger.log(Level.INFO, String.format("Could not unregister unknown USK: %s", uri));
                return;
            }
            this.node.clientCore.uskManager.unsubscribe(USK.create((FreenetURI)uri), uskCallback);
        }
        catch (MalformedURLException mue1) {
            logger.log(Level.INFO, String.format("Could not unregister invalid USK: %s", uri), mue1);
        }
    }

    public static class InsertTokenSupplier
    implements Function<Image, InsertToken> {
        private final FreenetInterface freenetInterface;

        @Inject
        public InsertTokenSupplier(FreenetInterface freenetInterface) {
            this.freenetInterface = freenetInterface;
        }

        @Override
        public InsertToken apply(Image image) {
            FreenetInterface freenetInterface = this.freenetInterface;
            freenetInterface.getClass();
            return freenetInterface.new InsertToken(image);
        }
    }

    public class InsertToken
    implements ClientPutCallback {
        private final Image image;
        private ClientPutter clientPutter;
        private Bucket bucket;
        private volatile FreenetURI resultingUri;

        public InsertToken(Image image) {
            this.image = image;
        }

        public void setClientPutter(ClientPutter clientPutter) {
            this.clientPutter = clientPutter;
            FreenetInterface.this.eventBus.post(new ImageInsertStartedEvent(this.image));
        }

        public void setBucket(Bucket bucket) {
            this.bucket = bucket;
        }

        public void cancel() {
            this.clientPutter.cancel(((FreenetInterface)FreenetInterface.this).node.clientCore.clientContext);
            FreenetInterface.this.eventBus.post(new ImageInsertAbortedEvent(this.image));
            this.bucket.free();
        }

        public RequestClient getRequestClient() {
            return FreenetInterface.this.imageInserts;
        }

        public void onResume(ClientContext context) throws ResumeFailedException {
        }

        public void onFailure(InsertException insertException, BaseClientPutter clientPutter) {
            if (insertException != null && "Cancelled by user".equals(insertException.getMessage())) {
                FreenetInterface.this.eventBus.post(new ImageInsertAbortedEvent(this.image));
            } else {
                FreenetInterface.this.eventBus.post(new ImageInsertFailedEvent(this.image, (Throwable)insertException));
            }
            this.bucket.free();
        }

        public void onFetchable(BaseClientPutter clientPutter) {
        }

        public void onGeneratedMetadata(Bucket metadata, BaseClientPutter clientPutter) {
        }

        public void onGeneratedURI(FreenetURI generatedUri, BaseClientPutter clientPutter) {
            this.resultingUri = generatedUri;
        }

        public void onSuccess(BaseClientPutter clientPutter) {
            FreenetInterface.this.eventBus.post(new ImageInsertFinishedEvent(this.image, this.resultingUri));
            this.bucket.free();
        }
    }

    public static interface Callback {
        public void editionFound(FreenetURI var1, long var2, boolean var4, boolean var5);
    }

    public static interface BackgroundFetchCallback {
        public boolean shouldCancel(@Nonnull FreenetURI var1, @Nonnull String var2, long var3);

        public void loaded(@Nonnull FreenetURI var1, @Nonnull String var2, @Nonnull byte[] var3);

        public void failed(@Nonnull FreenetURI var1);
    }
}

