/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.sone.utils.Option;

public class Options {
    private final Map<String, Option<Boolean>> booleanOptions = Collections.synchronizedMap(new HashMap());
    private final Map<String, Option<Integer>> integerOptions = Collections.synchronizedMap(new HashMap());
    private final Map<String, Option<String>> stringOptions = Collections.synchronizedMap(new HashMap());
    private final Map<String, Option<? extends Enum<?>>> enumOptions = Collections.synchronizedMap(new HashMap());

    public Option<Boolean> addBooleanOption(String name, Option<Boolean> booleanOption) {
        this.booleanOptions.put(name, booleanOption);
        return booleanOption;
    }

    public Option<Boolean> getBooleanOption(String name) {
        return this.booleanOptions.get(name);
    }

    public Option<Integer> addIntegerOption(String name, Option<Integer> integerOption) {
        this.integerOptions.put(name, integerOption);
        return integerOption;
    }

    public Option<Integer> getIntegerOption(String name) {
        return this.integerOptions.get(name);
    }

    public Option<String> addStringOption(String name, Option<String> stringOption) {
        this.stringOptions.put(name, stringOption);
        return stringOption;
    }

    public Option<String> getStringOption(String name) {
        return this.stringOptions.get(name);
    }

    public <T extends Enum<T>> Option<T> addEnumOption(String name, Option<T> enumOption) {
        this.enumOptions.put(name, enumOption);
        return enumOption;
    }

    public <T extends Enum<T>> Option<T> getEnumOption(String name) {
        return this.enumOptions.get(name);
    }
}

