/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.Preferences;
import net.pterodactylus.sone.fcp.FcpInterface;
import net.pterodactylus.util.config.Configuration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/pterodactylus/sone/core/PreferencesLoader;", "", "preferences", "Lnet/pterodactylus/sone/core/Preferences;", "(Lnet/pterodactylus/sone/core/Preferences;)V", "loadCharactersPerPost", "", "configuration", "Lnet/pterodactylus/util/config/Configuration;", "loadFcpFullAccessRequired", "loadFcpInterfaceActive", "loadFrom", "loadImagesPerPage", "loadInsertionDelay", "loadPostCutOffLength", "loadPostsPerPage", "loadRequireFullAccess", "loadStrictFiltering", "Sone"})
public final class PreferencesLoader {
    private final Preferences preferences;

    public final void loadFrom(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.loadInsertionDelay(configuration);
        this.loadPostsPerPage(configuration);
        this.loadImagesPerPage(configuration);
        this.loadCharactersPerPost(configuration);
        this.loadPostCutOffLength(configuration);
        this.loadRequireFullAccess(configuration);
        this.loadFcpInterfaceActive(configuration);
        this.loadFcpFullAccessRequired(configuration);
        this.loadStrictFiltering(configuration);
    }

    private final void loadInsertionDelay(Configuration configuration) {
        this.preferences.setNewInsertionDelay(configuration.getIntValue("Option/InsertionDelay").getValue(null));
    }

    private final void loadPostsPerPage(Configuration configuration) {
        this.preferences.setNewPostsPerPage(configuration.getIntValue("Option/PostsPerPage").getValue(null));
    }

    private final void loadImagesPerPage(Configuration configuration) {
        this.preferences.setNewImagesPerPage(configuration.getIntValue("Option/ImagesPerPage").getValue(null));
    }

    private final void loadCharactersPerPost(Configuration configuration) {
        this.preferences.setNewCharactersPerPost(configuration.getIntValue("Option/CharactersPerPost").getValue(null));
    }

    private final void loadPostCutOffLength(Configuration configuration) {
        try {
            this.preferences.setNewPostCutOffLength(configuration.getIntValue("Option/PostCutOffLength").getValue(null));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private final void loadRequireFullAccess(Configuration configuration) {
        this.preferences.setNewRequireFullAccess(configuration.getBooleanValue("Option/RequireFullAccess").getValue(null));
    }

    private final void loadFcpInterfaceActive(Configuration configuration) {
        this.preferences.setNewFcpInterfaceActive(configuration.getBooleanValue("Option/ActivateFcpInterface").getValue(null));
    }

    private final void loadFcpFullAccessRequired(Configuration configuration) {
        FcpInterface.FullAccessRequired fullAccessRequired;
        Integer fullAccessRequiredInteger = configuration.getIntValue("Option/FcpFullAccessRequired").getValue(null);
        Preferences preferences = this.preferences;
        Integer n = fullAccessRequiredInteger;
        if (n != null) {
            Integer n2 = n;
            Preferences preferences2 = preferences;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            FcpInterface.FullAccessRequired fullAccessRequired2 = FcpInterface.FullAccessRequired.values()[it];
            preferences = preferences2;
            fullAccessRequired = fullAccessRequired2;
        } else {
            fullAccessRequired = null;
        }
        preferences.setNewFcpFullAccessRequired(fullAccessRequired);
    }

    private final void loadStrictFiltering(Configuration configuration) {
        this.preferences.setNewStrictFiltering(configuration.getBooleanValue("Option/StrictFiltering").getValue(null));
    }

    public PreferencesLoader(@NotNull Preferences preferences) {
        Intrinsics.checkParameterIsNotNull(preferences, "preferences");
        this.preferences = preferences;
    }
}

