/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.USKCallback;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.support.api.Bucket;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import net.pterodactylus.sone.core.Fetched;
import net.pterodactylus.sone.core.FreenetInterface;
import net.pterodactylus.sone.core.SoneDownloader;
import net.pterodactylus.sone.core.SoneParser;
import net.pterodactylus.sone.core.UpdatedSoneProcessor;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.util.service.AbstractService;

public class SoneDownloaderImpl
extends AbstractService
implements SoneDownloader {
    private static final Logger logger = Logger.getLogger(SoneDownloaderImpl.class.getName());
    private static final int MAX_PROTOCOL_VERSION = 0;
    private final UpdatedSoneProcessor updatedSoneProcessor;
    private final SoneParser soneParser;
    private final FreenetInterface freenetInterface;
    private final Set<Sone> sones = new HashSet<Sone>();

    @Inject
    SoneDownloaderImpl(UpdatedSoneProcessor updatedSoneProcessor, FreenetInterface freenetInterface, SoneParser soneParser) {
        super("Sone Downloader", false);
        this.updatedSoneProcessor = updatedSoneProcessor;
        this.freenetInterface = freenetInterface;
        this.soneParser = soneParser;
    }

    @Override
    public void addSone(final Sone sone) {
        if (!this.sones.add(sone)) {
            this.freenetInterface.unregisterUsk(sone);
        }
        USKCallback uskCallback = new USKCallback(){

            public void onFoundEdition(long edition, USK key, ClientContext clientContext, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
                logger.log(Level.FINE, String.format("Found USK update for Sone \u201c%s\u201d at %s, new known good: %s, new slot too: %s.", sone, key, newKnownGood, newSlotToo));
                if (edition > sone.getLatestEdition()) {
                    sone.setLatestEdition(edition);
                    new Thread(SoneDownloaderImpl.this.fetchSoneAsSskAction(sone), "Sone Downloader").start();
                }
            }

            public short getPollingPriorityProgress() {
                return 1;
            }

            public short getPollingPriorityNormal() {
                return 1;
            }
        };
        if (this.soneHasBeenActiveRecently(sone)) {
            this.freenetInterface.registerActiveUsk(sone.getRequestUri(), uskCallback);
        } else {
            this.freenetInterface.registerPassiveUsk(sone.getRequestUri(), uskCallback);
        }
    }

    private boolean soneHasBeenActiveRecently(Sone sone) {
        return System.currentTimeMillis() - sone.getTime() < TimeUnit.DAYS.toMillis(7L);
    }

    private void fetchSoneAsSsk(Sone sone) {
        this.fetchSone(sone, sone.getRequestUri().sskForUSK(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sone fetchSone(Sone sone, FreenetURI soneUri, boolean fetchOnly) {
        Fetched fetchResults;
        block4: {
            Sone sone2;
            logger.log(Level.FINE, String.format("Starting fetch for Sone \u201c%s\u201d from %s\u2026", sone, soneUri));
            FreenetURI requestUri = soneUri.setMetaString(new String[]{"sone.xml"});
            sone.setStatus(Sone.SoneStatus.downloading);
            try {
                fetchResults = this.freenetInterface.fetchUri(requestUri);
                if (fetchResults != null) break block4;
                sone2 = null;
                sone.setStatus(sone.getTime() == 0L ? Sone.SoneStatus.unknown : Sone.SoneStatus.idle);
            }
            catch (Throwable throwable) {
                sone.setStatus(sone.getTime() == 0L ? Sone.SoneStatus.unknown : Sone.SoneStatus.idle);
                throw throwable;
            }
            return sone2;
        }
        logger.log(Level.FINEST, String.format("Got %d bytes back.", fetchResults.getFetchResult().size()));
        Sone parsedSone = this.parseSone(sone, fetchResults.getFetchResult(), fetchResults.getFreenetUri());
        if (parsedSone != null && !fetchOnly) {
            parsedSone.setStatus(parsedSone.getTime() == 0L ? Sone.SoneStatus.unknown : Sone.SoneStatus.idle);
            this.updatedSoneProcessor.updateSone(parsedSone);
            this.addSone(parsedSone);
        }
        Sone sone3 = parsedSone;
        sone.setStatus(sone.getTime() == 0L ? Sone.SoneStatus.unknown : Sone.SoneStatus.idle);
        return sone3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Sone parseSone(Sone originalSone, FetchResult fetchResult, FreenetURI requestUri) {
        logger.finest(() -> String.format("Parsing FetchResult (%d bytes, %s) for %s\u2026", fetchResult.size(), fetchResult.getMimeType(), originalSone));
        Bucket soneBucket = fetchResult.asBucket();
        try {
            Sone sone;
            Throwable throwable;
            InputStream soneInputStream;
            block18: {
                block19: {
                    soneInputStream = soneBucket.getInputStream();
                    throwable = null;
                    Sone parsedSone = this.soneParser.parseSone(originalSone, soneInputStream);
                    if (parsedSone != null) {
                        logger.finer(() -> String.format("Sone %s was successfully parsed.", parsedSone));
                        parsedSone.setLatestEdition(requestUri.getEdition());
                    }
                    sone = parsedSone;
                    if (soneInputStream == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        soneInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                soneInputStream.close();
            }
            return sone;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (soneInputStream != null) {
                            if (throwable != null) {
                                try {
                                    soneInputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                soneInputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, e1, () -> String.format("Could not parse Sone from %s!", requestUri));
                }
            }
        }
        finally {
            soneBucket.free();
        }
        return null;
    }

    @Override
    public Runnable fetchSoneAsUskAction(final Sone sone) {
        return new Runnable(){

            @Override
            public void run() {
                SoneDownloaderImpl.this.fetchSone(sone, sone.getRequestUri(), false);
            }
        };
    }

    @Override
    public Runnable fetchSoneAsSskAction(final Sone sone) {
        return new Runnable(){

            @Override
            public void run() {
                SoneDownloaderImpl.this.fetchSoneAsSsk(sone);
            }
        };
    }

    @Override
    protected void serviceStop() {
        for (Sone sone : this.sones) {
            this.freenetInterface.unregisterUsk(sone);
        }
    }
}

