/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class SoneModificationDetector {
    private final Ticker ticker;
    private final LockableFingerprintProvider lockableFingerprintProvider;
    private final AtomicInteger insertionDelay;
    private Long lastModificationTime;
    private String lastInsertFingerprint;
    private String lastCheckFingerprint;

    SoneModificationDetector(LockableFingerprintProvider lockableFingerprintProvider, AtomicInteger insertionDelay) {
        this(Ticker.systemTicker(), lockableFingerprintProvider, insertionDelay);
    }

    @VisibleForTesting
    SoneModificationDetector(Ticker ticker2, LockableFingerprintProvider lockableFingerprintProvider, AtomicInteger insertionDelay) {
        this.ticker = ticker2;
        this.lockableFingerprintProvider = lockableFingerprintProvider;
        this.insertionDelay = insertionDelay;
        this.lastCheckFingerprint = this.lastInsertFingerprint;
    }

    public boolean isEligibleForInsert() {
        if (this.lockableFingerprintProvider.isLocked()) {
            this.lastModificationTime = null;
            this.lastCheckFingerprint = "";
            return false;
        }
        String fingerprint = this.lockableFingerprintProvider.getFingerprint();
        if (fingerprint.equals(this.lastInsertFingerprint)) {
            this.lastModificationTime = null;
            this.lastCheckFingerprint = fingerprint;
            return false;
        }
        if (!Objects.equal(this.lastCheckFingerprint, fingerprint)) {
            this.lastModificationTime = this.ticker.read();
            this.lastCheckFingerprint = fingerprint;
            return false;
        }
        return this.insertionDelayHasPassed();
    }

    public String getLastInsertFingerprint() {
        return this.lastInsertFingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.lastCheckFingerprint = this.lastInsertFingerprint = fingerprint;
        this.lastModificationTime = null;
    }

    private boolean insertionDelayHasPassed() {
        return TimeUnit.NANOSECONDS.toSeconds(this.ticker.read() - this.lastModificationTime) >= (long)this.insertionDelay.get();
    }

    public boolean isModified() {
        return !Objects.equal(this.lockableFingerprintProvider.getFingerprint(), this.lastInsertFingerprint);
    }

    static interface LockableFingerprintProvider {
        public boolean isLocked();

        public String getFingerprint();
    }
}

