/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import freenet.keys.FreenetURI;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.core.SoneDownloader;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.util.service.AbstractService;

public class SoneRescuer
extends AbstractService {
    private final Core core;
    private final SoneDownloader soneDownloader;
    private final Sone sone;
    private volatile boolean fetching;
    private volatile long currentEdition;
    private volatile boolean lastFetchSuccessful = true;

    public SoneRescuer(Core core, SoneDownloader soneDownloader, Sone sone) {
        super("Sone Rescuer for " + sone.getName());
        this.core = core;
        this.soneDownloader = soneDownloader;
        this.sone = sone;
        this.currentEdition = sone.getRequestUri().getEdition();
    }

    public boolean isFetching() {
        return this.fetching;
    }

    public long getCurrentEdition() {
        return this.currentEdition;
    }

    public boolean hasNextEdition() {
        return this.currentEdition > 0L;
    }

    public long getNextEdition() {
        return this.currentEdition - 1L;
    }

    public SoneRescuer setEdition(long edition) {
        this.currentEdition = edition;
        return this;
    }

    public boolean isLastFetchSuccessful() {
        return this.lastFetchSuccessful;
    }

    public void startNextFetch() {
        this.fetching = true;
        this.notifySyncObject();
    }

    @Override
    protected void serviceRun() {
        while (!this.shouldStop()) {
            while (!this.shouldStop() && !this.fetching) {
                this.sleep();
            }
            if (!this.fetching) continue;
            this.core.lockSone(this.sone);
            FreenetURI soneUri = this.sone.getRequestUri().setKeyType("SSK").setDocName("Sone-" + this.currentEdition).setMetaString(new String[]{"sone.xml"});
            System.out.println("URI: " + soneUri);
            Sone fetchedSone = this.soneDownloader.fetchSone(this.sone, soneUri, true);
            System.out.println("Sone: " + fetchedSone);
            boolean bl = this.lastFetchSuccessful = fetchedSone != null;
            if (this.lastFetchSuccessful) {
                this.core.updateSone(fetchedSone, true);
            }
            this.fetching = false;
        }
    }
}

