/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.eventbus.EventBus;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import freenet.keys.FreenetURI;
import freenet.support.api.Bucket;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.core.Fetched;
import net.pterodactylus.sone.core.FreenetInterface;
import net.pterodactylus.sone.core.UpdateChecker;
import net.pterodactylus.sone.core.VersionInformation;
import net.pterodactylus.sone.core.event.UpdateFoundEvent;
import net.pterodactylus.sone.main.PluginHomepage;
import net.pterodactylus.sone.main.SonePlugin;
import net.pterodactylus.sone.utils.BucketsKt;
import net.pterodactylus.sone.utils.ObjectsKt;
import net.pterodactylus.util.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010#\u001a\u00020\u001eJ\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0018\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/pterodactylus/sone/core/UpdateChecker;", "", "eventBus", "Lcom/google/common/eventbus/EventBus;", "freenetInterface", "Lnet/pterodactylus/sone/core/FreenetInterface;", "currentRunningVersion", "Lnet/pterodactylus/util/version/Version;", "pluginHomepage", "Lnet/pterodactylus/sone/main/PluginHomepage;", "(Lcom/google/common/eventbus/EventBus;Lnet/pterodactylus/sone/core/FreenetInterface;Lnet/pterodactylus/util/version/Version;Lnet/pterodactylus/sone/main/PluginHomepage;)V", "currentUri", "Lfreenet/keys/FreenetURI;", "getCurrentUri", "()Lfreenet/keys/FreenetURI;", "currentUri$delegate", "Lkotlin/Lazy;", "<set-?>", "", "latestEdition", "getLatestEdition", "()J", "latestVersion", "getLatestVersion", "()Lnet/pterodactylus/util/version/Version;", "latestVersionDate", "getLatestVersionDate", "logger", "Ljava/util/logging/Logger;", "disruptiveVersionBetweenCurrentAndFound", "", "properties", "Ljava/util/Properties;", "extractCurrentVersion", "Lnet/pterodactylus/sone/core/VersionInformation;", "hasLatestVersion", "parseProperties", "propertiesInputStream", "Ljava/io/InputStream;", "start", "", "stop", "updateVersionInformation", "versionInformation", "edition", "Sone"})
public final class UpdateChecker {
    private final Logger logger;
    private final Lazy currentUri$delegate;
    private long latestEdition;
    @NotNull
    private Version latestVersion;
    private long latestVersionDate;
    private final EventBus eventBus;
    private final FreenetInterface freenetInterface;
    private final Version currentRunningVersion;

    private final FreenetURI getCurrentUri() {
        Lazy lazy = this.currentUri$delegate;
        UpdateChecker updateChecker = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FreenetURI)lazy.getValue();
    }

    public final long getLatestEdition() {
        return this.latestEdition;
    }

    @NotNull
    public final Version getLatestVersion() {
        return this.latestVersion;
    }

    public final long getLatestVersionDate() {
        return this.latestVersionDate;
    }

    public final boolean hasLatestVersion() {
        return this.latestVersion.compareTo(this.currentRunningVersion) > 0;
    }

    public final void start() {
        this.freenetInterface.registerUsk(this.getCurrentUri(), new FreenetInterface.Callback(this){
            final /* synthetic */ UpdateChecker this$0;

            public final void editionFound(FreenetURI uri, long edition, boolean newKnownGood, boolean newSlot) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object object = "Found update for %s: %d, %s, %s";
                Object object2 = new Object[]{uri, edition, newKnownGood, newSlot};
                Level level = Level.FINEST;
                Logger logger = UpdateChecker.access$getLogger$p(this.this$0);
                boolean bl = false;
                String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(format, *args)");
                String string2 = string;
                logger.log(level, string2);
                if (newKnownGood || newSlot) {
                    try {
                        Fetched fetched = UpdateChecker.access$getFreenetInterface$p(this.this$0).fetchUri(uri.setMetaString(new String[]{"sone.properties"}));
                        if (fetched != null && (fetched = ObjectsKt.onNull(fetched, new Function0<Unit>(this, uri){
                            final /* synthetic */ start.1 this$0;
                            final /* synthetic */ FreenetURI $uri;

                            public final void invoke() {
                                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                String string = "Could not fetch properties of latest homepage: %s";
                                Object[] objectArray = new Object[]{this.$uri};
                                Level level = Level.WARNING;
                                Logger logger = UpdateChecker.access$getLogger$p(this.this$0.this$0);
                                boolean bl = false;
                                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
                                String string3 = string2;
                                logger.log(level, string3);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$uri = freenetURI;
                                super(0);
                            }
                        })) != null && (fetched = fetched.getFetchResult()) != null && (fetched = fetched.asBucket()) != null) {
                            VersionInformation cfr_ignored_0 = (VersionInformation)BucketsKt.use((Bucket)fetched, (Function1)new Function1<Bucket, VersionInformation>(this, edition){
                                final /* synthetic */ start.1 this$0;
                                final /* synthetic */ long $edition;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final VersionInformation invoke(@NotNull Bucket resultBucket) {
                                    Intrinsics.checkParameterIsNotNull(resultBucket, "resultBucket");
                                    Object object = resultBucket.getInputStream();
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    Object it = object;
                                    boolean bl3 = false;
                                    UpdateChecker updateChecker = this.this$0.this$0;
                                    InputStream inputStream = it;
                                    Intrinsics.checkExpressionValueIsNotNull(inputStream, "it");
                                    object = UpdateChecker.access$parseProperties(updateChecker, inputStream);
                                    bl = false;
                                    bl2 = false;
                                    it = object;
                                    boolean bl4 = false;
                                    VersionInformation versionInformation = ObjectsKt.onNull(UpdateChecker.access$extractCurrentVersion(this.this$0.this$0, (Properties)it), new Function0<Unit>(this){
                                        final /* synthetic */ start.2 this$0;

                                        public final void invoke() {
                                            UpdateChecker.access$getLogger$p(this.this$0.this$0.this$0).log(Level.INFO, "Invalid data parsed from properties.");
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    });
                                    Object object2 = versionInformation;
                                    if (versionInformation == null) return null;
                                    object = object2;
                                    bl = false;
                                    bl2 = false;
                                    it = object;
                                    boolean bl5 = false;
                                    if (((VersionInformation)it).getVersion().compareTo(this.this$0.this$0.getLatestVersion()) <= 0) return null;
                                    boolean bl6 = true;
                                    if (!bl6) return null;
                                    Object object3 = object;
                                    object2 = object3;
                                    if (object3 == null) return null;
                                    object = object2;
                                    bl = false;
                                    bl2 = false;
                                    it = object;
                                    boolean bl7 = false;
                                    UpdateChecker.access$updateVersionInformation(this.this$0.this$0, (VersionInformation)it, this.$edition);
                                    Object object4 = object;
                                    object2 = object4;
                                    if (object4 == null) return null;
                                    object = object2;
                                    bl = false;
                                    bl2 = false;
                                    it = object;
                                    boolean bl8 = false;
                                    UpdateChecker.access$getLogger$p(this.this$0.this$0).info(new Supplier<String>((VersionInformation)it){
                                        final /* synthetic */ VersionInformation $it;

                                        @NotNull
                                        public final String get() {
                                            String string = "Found new version: %s (%tc%s)";
                                            Object[] objectArray = new Object[]{this.$it.getVersion(), this.$it.getTime(), this.$it.getDisruptive() ? ", disruptive" : ""};
                                            boolean bl = false;
                                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                            Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(this, *args)");
                                            return string2;
                                        }
                                        {
                                            this.$it = versionInformation;
                                        }
                                    });
                                    Object object5 = object;
                                    object2 = object5;
                                    if (object5 == null) return null;
                                    object = object2;
                                    bl = false;
                                    bl2 = false;
                                    it = object;
                                    boolean bl9 = false;
                                    UpdateChecker.access$getEventBus$p(this.this$0.this$0).post(new UpdateFoundEvent(((VersionInformation)it).getVersion(), ((VersionInformation)it).getTime(), this.$edition, ((VersionInformation)it).getDisruptive()));
                                    Object object6 = object;
                                    return object6;
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$edition = l;
                                    super(1);
                                }
                            });
                        }
                    }
                    catch (IOException ioe1) {
                        object = StringCompanionObject.INSTANCE;
                        object2 = "Could not parse sone.properties of %s!";
                        Object[] objectArray = new Object[]{uri};
                        level = Level.WARNING;
                        logger = UpdateChecker.access$getLogger$p(this.this$0);
                        boolean bl2 = false;
                        String string3 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
                        string2 = string3;
                        logger.log(level, string2, ioe1);
                    }
                }
            }
            {
                this.this$0 = updateChecker;
            }
        });
    }

    public final void stop() {
        this.freenetInterface.unregisterUsk(this.getCurrentUri());
    }

    private final void updateVersionInformation(VersionInformation versionInformation, long edition) {
        this.latestVersion = versionInformation.getVersion();
        this.latestVersionDate = versionInformation.getTime();
        this.latestEdition = edition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Properties parseProperties(InputStream propertiesInputStream) {
        Properties properties2 = new Properties();
        boolean bl = false;
        boolean bl2 = false;
        Properties $this$apply = properties2;
        boolean bl3 = false;
        Closeable closeable = new InputStreamReader(propertiesInputStream, "UTF-8");
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            InputStreamReader inputStreamReader = (InputStreamReader)closeable;
            boolean bl5 = false;
            $this$apply.load(inputStreamReader);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return properties2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VersionInformation extractCurrentVersion(Properties properties2) {
        String string = properties2.getProperty("CurrentVersion/Version");
        Object object = string;
        if (string == null) return null;
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        String it = object2;
        boolean bl3 = false;
        Version version = Version.parse(it);
        object = version;
        if (version == null) return null;
        object2 = object;
        bl = false;
        bl2 = false;
        Object version2 = object2;
        boolean bl4 = false;
        String string2 = properties2.getProperty("CurrentVersion/ReleaseTime");
        Object object3 = string2;
        if (string2 == null) return null;
        Object object4 = object3;
        boolean bl5 = false;
        boolean bl6 = false;
        String it2 = object4;
        boolean bl7 = false;
        Long l = Longs.tryParse(it2);
        object3 = l;
        if (l == null) return null;
        object4 = object3;
        bl5 = false;
        bl6 = false;
        Object time = object4;
        boolean bl8 = false;
        Object object5 = time;
        Intrinsics.checkExpressionValueIsNotNull(object5, "time");
        VersionInformation versionInformation = new VersionInformation((Version)version2, (Long)object5, this.disruptiveVersionBetweenCurrentAndFound(properties2));
        return versionInformation;
    }

    private final boolean disruptiveVersionBetweenCurrentAndFound(Properties properties2) {
        boolean bl;
        block6: {
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Set<String> set = properties2.stringPropertyNames();
            Intrinsics.checkExpressionValueIsNotNull(set, "properties.stringPropertyNames()");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull(string, "it");
                if (!StringsKt.startsWith$default(string, "DisruptiveVersion/", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull(string, "it");
                object = StringsKt.removePrefix(string, (CharSequence)"DisruptiveVersion/");
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                object = Version.parse(it);
                collection.add(object);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Version it2 = (Version)element$iv;
                    boolean bl5 = false;
                    if (!(it2.compareTo(this.currentRunningVersion) > 0)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Inject
    public UpdateChecker(@NotNull EventBus eventBus, @NotNull FreenetInterface freenetInterface, @NotNull Version currentRunningVersion, @NotNull PluginHomepage pluginHomepage) {
        Intrinsics.checkParameterIsNotNull(eventBus, "eventBus");
        Intrinsics.checkParameterIsNotNull(freenetInterface, "freenetInterface");
        Intrinsics.checkParameterIsNotNull(currentRunningVersion, "currentRunningVersion");
        Intrinsics.checkParameterIsNotNull(pluginHomepage, "pluginHomepage");
        this.eventBus = eventBus;
        this.freenetInterface = freenetInterface;
        this.currentRunningVersion = currentRunningVersion;
        Logger logger = Logger.getLogger(UpdateChecker.class.getName());
        Intrinsics.checkExpressionValueIsNotNull(logger, "getLogger(UpdateChecker::class.java.name)");
        this.logger = logger;
        this.currentUri$delegate = LazyKt.lazy((Function0)new Function0<FreenetURI>(pluginHomepage){
            final /* synthetic */ PluginHomepage $pluginHomepage;

            @NotNull
            public final FreenetURI invoke() {
                return new FreenetURI(this.$pluginHomepage.getHomepage());
            }
            {
                this.$pluginHomepage = pluginHomepage;
                super(0);
            }
        });
        this.latestEdition = SonePlugin.getLatestEdition();
        this.latestVersion = this.currentRunningVersion;
    }

    public static final /* synthetic */ Logger access$getLogger$p(UpdateChecker $this) {
        return $this.logger;
    }

    public static final /* synthetic */ FreenetInterface access$getFreenetInterface$p(UpdateChecker $this) {
        return $this.freenetInterface;
    }

    public static final /* synthetic */ Properties access$parseProperties(UpdateChecker $this, InputStream propertiesInputStream) {
        return $this.parseProperties(propertiesInputStream);
    }

    public static final /* synthetic */ VersionInformation access$extractCurrentVersion(UpdateChecker $this, Properties properties2) {
        return $this.extractCurrentVersion(properties2);
    }

    public static final /* synthetic */ Version access$getLatestVersion$p(UpdateChecker $this) {
        return $this.latestVersion;
    }

    public static final /* synthetic */ void access$setLatestVersion$p(UpdateChecker $this, Version version) {
        $this.latestVersion = version;
    }

    public static final /* synthetic */ void access$updateVersionInformation(UpdateChecker $this, VersionInformation versionInformation, long edition) {
        $this.updateVersionInformation(versionInformation, edition);
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(UpdateChecker $this) {
        return $this.eventBus;
    }
}

