/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.sone.core.WebOfTrustUpdater;
import net.pterodactylus.sone.freenet.plugin.PluginException;
import net.pterodactylus.sone.freenet.wot.OwnIdentity;
import net.pterodactylus.sone.freenet.wot.WebOfTrustConnector;
import net.pterodactylus.util.service.AbstractService;

@Singleton
public class WebOfTrustUpdaterImpl
extends AbstractService
implements WebOfTrustUpdater {
    private static final Logger logger = Logger.getLogger(WebOfTrustUpdaterImpl.class.getName());
    private final WebOfTrustUpdateJob stopJob = new WebOfTrustUpdateJob();
    private final WebOfTrustConnector webOfTrustConnector;
    private final BlockingQueue<WebOfTrustUpdateJob> updateJobs = new LinkedBlockingQueue<WebOfTrustUpdateJob>();

    @Inject
    public WebOfTrustUpdaterImpl(WebOfTrustConnector webOfTrustConnector) {
        super("Trust Updater");
        this.webOfTrustConnector = webOfTrustConnector;
    }

    @Override
    public boolean addContextWait(OwnIdentity ownIdentity, String context) {
        AddContextJob addContextJob = new AddContextJob(ownIdentity, context);
        if (!this.updateJobs.contains(addContextJob)) {
            logger.log(Level.FINER, "Adding Context Job: " + addContextJob);
            try {
                this.updateJobs.put(addContextJob);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return addContextJob.waitForCompletion();
        }
        for (WebOfTrustUpdateJob updateJob : this.updateJobs) {
            if (!updateJob.equals(addContextJob)) continue;
            return updateJob.waitForCompletion();
        }
        return false;
    }

    @Override
    public void removeContext(OwnIdentity ownIdentity, String context) {
        RemoveContextJob removeContextJob = new RemoveContextJob(ownIdentity, context);
        if (!this.updateJobs.contains(removeContextJob)) {
            logger.log(Level.FINER, "Adding Context Job: " + removeContextJob);
            try {
                this.updateJobs.put(removeContextJob);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setProperty(OwnIdentity ownIdentity, String propertyName, String propertyValue) {
        SetPropertyJob setPropertyJob = new SetPropertyJob(ownIdentity, propertyName, propertyValue);
        if (this.updateJobs.contains(setPropertyJob)) {
            this.updateJobs.remove(setPropertyJob);
        }
        logger.log(Level.FINER, "Adding Property Job: " + setPropertyJob);
        try {
            this.updateJobs.put(setPropertyJob);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void removeProperty(OwnIdentity ownIdentity, String propertyName) {
        this.setProperty(ownIdentity, propertyName, null);
    }

    @Override
    protected void serviceRun() {
        while (!this.shouldStop()) {
            try {
                WebOfTrustUpdateJob updateJob = this.updateJobs.take();
                if (this.shouldStop()) break;
                logger.log(Level.FINE, "Running Trust Update Job: " + updateJob);
                long startTime = System.currentTimeMillis();
                updateJob.run();
                long endTime = System.currentTimeMillis();
                logger.log(Level.FINE, "Trust Update Job finished, took " + (endTime - startTime) + " ms.");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void serviceStop() {
        try {
            this.updateJobs.put(this.stopJob);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    class SetPropertyJob
    extends WebOfTrustUpdateJob {
        private final OwnIdentity ownIdentity;
        private final String propertyName;
        private final String propertyValue;

        public SetPropertyJob(OwnIdentity ownIdentity, String propertyName, String propertyValue) {
            this.ownIdentity = ownIdentity;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @Override
        public void run() {
            try {
                if (this.propertyValue == null) {
                    WebOfTrustUpdaterImpl.this.webOfTrustConnector.removeProperty(this.ownIdentity, this.propertyName);
                    this.ownIdentity.removeProperty(this.propertyName);
                } else {
                    WebOfTrustUpdaterImpl.this.webOfTrustConnector.setProperty(this.ownIdentity, this.propertyName, this.propertyValue);
                    this.ownIdentity.setProperty(this.propertyName, this.propertyValue);
                }
                this.finish(true);
            }
            catch (PluginException pe1) {
                logger.log(Level.WARNING, String.format("Could not set Property \u201c%2$s\u201d to \u201c%3$s\u201d on Own Identity %1$s!", this.ownIdentity, this.propertyName, this.propertyValue), pe1);
                this.finish(false);
            }
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            SetPropertyJob updateJob = (SetPropertyJob)object;
            return updateJob.ownIdentity.equals(this.ownIdentity) && updateJob.propertyName.equals(this.propertyName);
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.ownIdentity.hashCode() ^ this.propertyName.hashCode();
        }

        public String toString() {
            return String.format("%s[ownIdentity=%s,propertyName=%s]", this.getClass().getSimpleName(), this.ownIdentity, this.propertyName);
        }
    }

    @VisibleForTesting
    class RemoveContextJob
    extends WebOfTrustContextUpdateJob {
        public RemoveContextJob(OwnIdentity ownIdentity, String context) {
            super(ownIdentity, context);
        }

        @Override
        public void run() {
            try {
                WebOfTrustUpdaterImpl.this.webOfTrustConnector.removeContext(this.ownIdentity, this.context);
                this.ownIdentity.removeContext(this.context);
                this.finish(true);
            }
            catch (PluginException pe1) {
                logger.log(Level.WARNING, String.format("Could not remove Context \u201c%2$s\u201d to Own Identity %1$s!", this.ownIdentity, this.context), pe1);
                this.finish(false);
            }
        }
    }

    @VisibleForTesting
    class AddContextJob
    extends WebOfTrustContextUpdateJob {
        public AddContextJob(OwnIdentity ownIdentity, String context) {
            super(ownIdentity, context);
        }

        @Override
        public void run() {
            try {
                WebOfTrustUpdaterImpl.this.webOfTrustConnector.addContext(this.ownIdentity, this.context);
                this.ownIdentity.addContext(this.context);
                this.finish(true);
            }
            catch (PluginException pe1) {
                logger.log(Level.WARNING, String.format("Could not add Context \u201c%2$s\u201d to Own Identity %1$s!", this.ownIdentity, this.context), pe1);
                this.finish(false);
            }
        }
    }

    @VisibleForTesting
    class WebOfTrustContextUpdateJob
    extends WebOfTrustUpdateJob {
        protected final OwnIdentity ownIdentity;
        protected final String context;

        public WebOfTrustContextUpdateJob(OwnIdentity ownIdentity, String context) {
            this.ownIdentity = Preconditions.checkNotNull(ownIdentity, "ownIdentity must not be null");
            this.context = Preconditions.checkNotNull(context, "context must not be null");
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            WebOfTrustContextUpdateJob updateJob = (WebOfTrustContextUpdateJob)object;
            return updateJob.ownIdentity.equals(this.ownIdentity) && updateJob.context.equals(this.context);
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.ownIdentity.hashCode() ^ this.context.hashCode();
        }

        public String toString() {
            return String.format("%s[ownIdentity=%s,context=%s]", this.getClass().getSimpleName(), this.ownIdentity, this.context);
        }
    }

    @VisibleForTesting
    class WebOfTrustUpdateJob
    implements Runnable {
        private final Object syncObject = new Object();
        private boolean finished;
        private boolean success;

        WebOfTrustUpdateJob() {
        }

        @Override
        public void run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForCompletion() {
            Object object = this.syncObject;
            synchronized (object) {
                while (!this.finished && !WebOfTrustUpdaterImpl.this.shouldStop()) {
                    try {
                        this.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.success;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finish(boolean success) {
            Object object = this.syncObject;
            synchronized (object) {
                this.finished = true;
                this.success = success;
                this.syncObject.notifyAll();
            }
        }
    }
}

