/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pterodactylus.sone.data.Fingerprintable;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Sone;

public class Profile
implements Fingerprintable {
    private final Sone sone;
    private volatile String firstName;
    private volatile String middleName;
    private volatile String lastName;
    private volatile Integer birthDay;
    private volatile Integer birthMonth;
    private volatile Integer birthYear;
    private volatile String avatar;
    private final List<Field> fields = Collections.synchronizedList(new ArrayList());

    public Profile(Sone sone) {
        this.sone = sone;
    }

    public Profile(@Nonnull Profile profile) {
        this.sone = profile.sone;
        this.firstName = profile.firstName;
        this.middleName = profile.middleName;
        this.lastName = profile.lastName;
        this.birthDay = profile.birthDay;
        this.birthMonth = profile.birthMonth;
        this.birthYear = profile.birthYear;
        this.avatar = profile.avatar;
        this.fields.addAll(profile.fields);
    }

    @Nonnull
    public Sone getSone() {
        return this.sone;
    }

    @Nullable
    public String getFirstName() {
        return this.firstName;
    }

    @Nonnull
    public Profile setFirstName(@Nullable String firstName) {
        this.firstName = "".equals(firstName) ? null : firstName;
        return this;
    }

    @Nullable
    public String getMiddleName() {
        return this.middleName;
    }

    @Nonnull
    public Profile setMiddleName(@Nullable String middleName) {
        this.middleName = "".equals(middleName) ? null : middleName;
        return this;
    }

    @Nullable
    public String getLastName() {
        return this.lastName;
    }

    @Nonnull
    public Profile setLastName(@Nullable String lastName) {
        this.lastName = "".equals(lastName) ? null : lastName;
        return this;
    }

    @Nullable
    public Integer getBirthDay() {
        return this.birthDay;
    }

    @Nonnull
    public Profile setBirthDay(@Nullable Integer birthDay) {
        this.birthDay = birthDay;
        return this;
    }

    @Nullable
    public Integer getBirthMonth() {
        return this.birthMonth;
    }

    @Nonnull
    public Profile setBirthMonth(@Nullable Integer birthMonth) {
        this.birthMonth = birthMonth;
        return this;
    }

    @Nullable
    public Integer getBirthYear() {
        return this.birthYear;
    }

    @Nullable
    public String getAvatar() {
        return this.avatar;
    }

    @Nonnull
    public Profile setAvatar(@Nullable Image avatar) {
        if (avatar == null) {
            this.avatar = null;
            return this;
        }
        Preconditions.checkArgument(avatar.getSone().equals(this.sone), "avatar must belong to Sone");
        this.avatar = avatar.getId();
        return this;
    }

    @Nonnull
    public Profile setBirthYear(@Nullable Integer birthYear) {
        this.birthYear = birthYear;
        return this;
    }

    @Nonnull
    public List<Field> getFields() {
        return new ArrayList<Field>(this.fields);
    }

    public boolean hasField(@Nonnull Field field) {
        return this.fields.contains(field);
    }

    @Nullable
    public Field getFieldById(@Nonnull String fieldId) {
        Preconditions.checkNotNull(fieldId, "fieldId must not be null");
        for (Field field : this.fields) {
            if (!field.getId().equals(fieldId)) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public Field getFieldByName(@Nonnull String fieldName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Nonnull
    public Field addField(@Nonnull String fieldName) throws IllegalArgumentException {
        Preconditions.checkNotNull(fieldName, "fieldName must not be null");
        if (fieldName.length() == 0) {
            throw new EmptyFieldName();
        }
        if (this.getFieldByName(fieldName) != null) {
            throw new DuplicateField();
        }
        Field field = new Field().setName(fieldName).setValue("");
        this.fields.add(field);
        return field;
    }

    public void moveFieldUp(@Nonnull Field field) {
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkArgument(this.hasField(field), "field must belong to this profile");
        Preconditions.checkArgument(this.getFieldIndex(field) > 0, "field index must be > 0");
        int fieldIndex = this.getFieldIndex(field);
        this.fields.remove(field);
        this.fields.add(fieldIndex - 1, field);
    }

    public void moveFieldDown(@Nonnull Field field) {
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkArgument(this.hasField(field), "field must belong to this profile");
        Preconditions.checkArgument(this.getFieldIndex(field) < this.fields.size() - 1, "field index must be < " + (this.fields.size() - 1));
        int fieldIndex = this.getFieldIndex(field);
        this.fields.remove(field);
        this.fields.add(fieldIndex + 1, field);
    }

    public void removeField(@Nonnull Field field) {
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkArgument(this.hasField(field), "field must belong to this profile");
        this.fields.remove(field);
    }

    private int getFieldIndex(@Nonnull Field field) {
        return this.fields.indexOf(field);
    }

    @Override
    public String getFingerprint() {
        Hasher hash = Hashing.sha256().newHasher();
        hash.putString("Profile(", StandardCharsets.UTF_8);
        if (this.firstName != null) {
            hash.putString("FirstName(", StandardCharsets.UTF_8).putString(this.firstName, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        if (this.middleName != null) {
            hash.putString("MiddleName(", StandardCharsets.UTF_8).putString(this.middleName, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        if (this.lastName != null) {
            hash.putString("LastName(", StandardCharsets.UTF_8).putString(this.lastName, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        if (this.birthDay != null) {
            hash.putString("BirthDay(", StandardCharsets.UTF_8).putInt(this.birthDay).putString(")", StandardCharsets.UTF_8);
        }
        if (this.birthMonth != null) {
            hash.putString("BirthMonth(", StandardCharsets.UTF_8).putInt(this.birthMonth).putString(")", StandardCharsets.UTF_8);
        }
        if (this.birthYear != null) {
            hash.putString("BirthYear(", StandardCharsets.UTF_8).putInt(this.birthYear).putString(")", StandardCharsets.UTF_8);
        }
        if (this.avatar != null) {
            hash.putString("Avatar(", StandardCharsets.UTF_8).putString(this.avatar, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        hash.putString("ContactInformation(", StandardCharsets.UTF_8);
        for (Field field : this.fields) {
            hash.putString(field.getName(), StandardCharsets.UTF_8).putString("(", StandardCharsets.UTF_8).putString(field.getValue(), StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        hash.putString(")", StandardCharsets.UTF_8);
        return hash.hash().toString();
    }

    public static class DuplicateField
    extends IllegalArgumentException {
    }

    public static class EmptyFieldName
    extends IllegalArgumentException {
    }

    public class Field {
        private final String id;
        private String name;
        private String value;

        private Field() {
            this(UUID.randomUUID().toString());
        }

        private Field(String id) {
            this.id = Preconditions.checkNotNull(id, "id must not be null");
        }

        @Nonnull
        public String getId() {
            return this.id;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public Field setName(@Nonnull String name) {
            Preconditions.checkNotNull(name, "name must not be null");
            Preconditions.checkArgument(Profile.this.getFieldByName(name) == null, "name must be unique");
            this.name = name;
            return this;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public Field setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Field)) {
                return false;
            }
            Field field = (Field)object;
            return this.id.equals(field.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

