/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data.impl;

import com.google.common.base.Preconditions;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.database.PostBuilder;
import net.pterodactylus.sone.database.SoneProvider;

public abstract class AbstractPostBuilder
implements PostBuilder {
    protected final SoneProvider soneProvider;
    protected boolean randomId;
    protected String id;
    protected String senderId;
    protected boolean currentTime;
    protected long time;
    protected String text;
    protected String recipientId;

    public AbstractPostBuilder(SoneProvider soneProvider) {
        this.soneProvider = soneProvider;
    }

    @Override
    public PostBuilder copyPost(Post post) {
        this.randomId = false;
        this.id = post.getId();
        this.senderId = post.getSone().getId();
        this.currentTime = false;
        this.time = post.getTime();
        this.text = post.getText();
        this.recipientId = post.getRecipientId().orNull();
        return this;
    }

    @Override
    public PostBuilder randomId() {
        this.randomId = true;
        return this;
    }

    @Override
    public PostBuilder withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public PostBuilder from(String senderId) {
        this.senderId = senderId;
        return this;
    }

    @Override
    public PostBuilder currentTime() {
        this.currentTime = true;
        return this;
    }

    @Override
    public PostBuilder withTime(long time) {
        this.time = time;
        return this;
    }

    @Override
    public PostBuilder withText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public PostBuilder to(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    protected void validate() throws IllegalStateException {
        Preconditions.checkState(this.randomId && this.id == null || !this.randomId && this.id != null, "exactly one of random ID or custom ID must be set");
        Preconditions.checkState(this.senderId != null, "sender must not be null");
        Preconditions.checkState(this.currentTime && this.time == 0L || !this.currentTime && this.time > 0L, "one of current time or custom time must be set");
        Preconditions.checkState(this.text != null && !this.text.trim().isEmpty(), "text must not be empty");
        Preconditions.checkState(this.recipientId == null || !this.recipientId.equals(this.senderId), "sender and recipient must not be the same");
    }
}

