/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Sone;

public class AlbumImpl
implements Album {
    private final String id;
    private final Sone sone;
    private final List<Album> albums = new ArrayList<Album>();
    private final List<String> imageIds = new ArrayList<String>();
    private final Map<String, Image> images = new HashMap<String, Image>();
    private Album parent;
    private String title;
    private String description;

    public AlbumImpl(Sone sone) {
        this(sone, UUID.randomUUID().toString());
    }

    public AlbumImpl(Sone sone, String id) {
        this.sone = Preconditions.checkNotNull(sone, "Sone must not be null");
        this.id = Preconditions.checkNotNull(id, "id must not be null");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Sone getSone() {
        return this.sone;
    }

    @Override
    public List<Album> getAlbums() {
        return new ArrayList<Album>(this.albums);
    }

    @Override
    public void addAlbum(Album album) {
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkArgument(album.getSone().equals(this.sone), "album must belong to the same Sone as this album");
        album.setParent(this);
        if (!this.albums.contains(album)) {
            this.albums.add(album);
        }
    }

    @Override
    public void removeAlbum(Album album) {
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkArgument(album.getSone().equals(this.sone), "album must belong this album\u2019s Sone");
        Preconditions.checkArgument(this.equals(album.getParent()), "album must belong to this album");
        this.albums.remove(album);
        album.removeParent();
    }

    @Override
    public Album moveAlbumUp(Album album) {
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkArgument(album.getSone().equals(this.sone), "album must belong to the same Sone as this album");
        Preconditions.checkArgument(this.equals(album.getParent()), "album must belong to this album");
        int oldIndex = this.albums.indexOf(album);
        if (oldIndex <= 0) {
            return album;
        }
        this.albums.remove(oldIndex);
        this.albums.add(oldIndex - 1, album);
        return this.albums.get(oldIndex);
    }

    @Override
    public Album moveAlbumDown(Album album) {
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkArgument(album.getSone().equals(this.sone), "album must belong to the same Sone as this album");
        Preconditions.checkArgument(this.equals(album.getParent()), "album must belong to this album");
        int oldIndex = this.albums.indexOf(album);
        if (oldIndex < 0 || oldIndex >= this.albums.size() - 1) {
            return album;
        }
        this.albums.remove(oldIndex);
        this.albums.add(oldIndex + 1, album);
        return this.albums.get(oldIndex);
    }

    @Override
    public List<Image> getImages() {
        return new ArrayList<Image>(Collections2.filter(Collections2.transform(this.imageIds, new Function<String, Image>(){

            @Override
            public Image apply(String imageId) {
                return (Image)AlbumImpl.this.images.get(imageId);
            }
        }), Predicates.notNull()));
    }

    @Override
    public void addImage(Image image) {
        Preconditions.checkNotNull(image, "image must not be null");
        Preconditions.checkNotNull(image.getSone(), "image must have an owner");
        Preconditions.checkArgument(image.getSone().equals(this.sone), "image must belong to the same Sone as this album");
        if (image.getAlbum() != null) {
            image.getAlbum().removeImage(image);
        }
        image.setAlbum(this);
        if (!this.imageIds.contains(image.getId())) {
            this.imageIds.add(image.getId());
            this.images.put(image.getId(), image);
        }
    }

    @Override
    public void removeImage(Image image) {
        Preconditions.checkNotNull(image, "image must not be null");
        Preconditions.checkNotNull(image.getSone(), "image must have an owner");
        Preconditions.checkArgument(image.getSone().equals(this.sone), "image must belong to the same Sone as this album");
        this.imageIds.remove(image.getId());
        this.images.remove(image.getId());
    }

    @Override
    public Image moveImageUp(Image image) {
        Preconditions.checkNotNull(image, "image must not be null");
        Preconditions.checkNotNull(image.getSone(), "image must have an owner");
        Preconditions.checkArgument(image.getSone().equals(this.sone), "image must belong to the same Sone as this album");
        Preconditions.checkArgument(image.getAlbum().equals(this), "image must belong to this album");
        int oldIndex = this.imageIds.indexOf(image.getId());
        if (oldIndex <= 0) {
            return image;
        }
        this.imageIds.remove(image.getId());
        this.imageIds.add(oldIndex - 1, image.getId());
        return this.images.get(this.imageIds.get(oldIndex));
    }

    @Override
    public Image moveImageDown(Image image) {
        Preconditions.checkNotNull(image, "image must not be null");
        Preconditions.checkNotNull(image.getSone(), "image must have an owner");
        Preconditions.checkArgument(image.getSone().equals(this.sone), "image must belong to the same Sone as this album");
        Preconditions.checkArgument(image.getAlbum().equals(this), "image must belong to this album");
        int oldIndex = this.imageIds.indexOf(image.getId());
        if (oldIndex == -1 || oldIndex >= this.imageIds.size() - 1) {
            return image;
        }
        this.imageIds.remove(image.getId());
        this.imageIds.add(oldIndex + 1, image.getId());
        return this.images.get(this.imageIds.get(oldIndex));
    }

    @Override
    public boolean isEmpty() {
        return this.albums.isEmpty() && this.images.isEmpty();
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public Album getParent() {
        return this.parent;
    }

    @Override
    public Album setParent(Album parent) {
        this.parent = Preconditions.checkNotNull(parent, "parent must not be null");
        return this;
    }

    @Override
    public Album removeParent() {
        this.parent = null;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Album.Modifier modify() throws IllegalStateException {
        return new Album.Modifier(){
            @Nullable
            private String title;
            @Nullable
            private String description;

            @Override
            public Album.Modifier setTitle(String title) {
                this.title = title;
                return this;
            }

            @Override
            public Album.Modifier setDescription(String description) {
                this.description = description;
                return this;
            }

            @Override
            public Album update() throws IllegalStateException {
                if (this.title != null && this.title.trim().isEmpty()) {
                    throw new Album.Modifier.AlbumTitleMustNotBeEmpty();
                }
                if (this.title != null) {
                    AlbumImpl.this.title = this.title;
                }
                if (this.description != null) {
                    AlbumImpl.this.description = this.description;
                }
                return AlbumImpl.this;
            }
        };
    }

    @Override
    public String getFingerprint() {
        Hasher hash = Hashing.sha256().newHasher();
        hash.putString("Album(", StandardCharsets.UTF_8);
        hash.putString("ID(", StandardCharsets.UTF_8).putString(this.id, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        hash.putString("Title(", StandardCharsets.UTF_8).putString(this.title, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        hash.putString("Description(", StandardCharsets.UTF_8).putString(this.description, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        hash.putString("Albums(", StandardCharsets.UTF_8);
        for (Album album : this.albums) {
            hash.putString(album.getFingerprint(), StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        hash.putString("Images(", StandardCharsets.UTF_8);
        for (Image image : this.getImages()) {
            if (!image.isInserted()) continue;
            hash.putString(image.getFingerprint(), StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        hash.putString(")", StandardCharsets.UTF_8);
        return hash.hash().toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlbumImpl)) {
            return false;
        }
        AlbumImpl album = (AlbumImpl)object;
        return this.id.equals(album.id);
    }
}

